/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs8;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class EncryptedPrivateKeyInfo
extends PKCSDerObject {
    private AlgorithmId algid;
    private byte[] encryptedKey;
    private byte[] encoded;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs8.EncryptedPrivateKeyInfo";
    private volatile int cachedHashVal = 0;

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", (Object)byArray);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", byArray, string);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", algorithmId, byArray);
        }
        this.setEncryptionAlgorithm(algorithmId);
        this.setEncryptionKey(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmId, byArray, string};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", objectArray);
        }
        this.setEncryptionAlgorithm(algorithmId);
        this.setEncryptionKey(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(char[] cArray, PrivateKeyInfo privateKeyInfo, String string, String string2) throws PKCSException, IOException {
        this(cArray, privateKeyInfo, string, string2, null);
    }

    public EncryptedPrivateKeyInfo(char[] cArray, PrivateKeyInfo privateKeyInfo, String string, String string2, String string3) throws PKCSException, IOException {
        super(string3);
        AlgorithmId algorithmId;
        AlgorithmId algorithmId2;
        byte[] byArray;
        Cipher cipher;
        SecretKey secretKey;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKeyInfo, string, string2, string3};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", objectArray);
        }
        if (cArray == null || cArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "EncryptedPrivateKeyInfo", "passwd not specified.");
            }
            throw new IllegalArgumentException("passwd not specified.");
        }
        if (privateKeyInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "EncryptedPrivateKeyInfo", "pki not specified.");
            }
            throw new IllegalArgumentException("pki not specified.");
        }
        objectArray = "PBEWith" + string + "And" + string2;
        byte[] byArray2 = privateKeyInfo.getKeyBytes();
        PKCSAttributes pKCSAttributes = privateKeyInfo.getAttributes();
        AlgorithmId algorithmId3 = privateKeyInfo.getAlgorithmId();
        DerOutputStream derOutputStream = new DerOutputStream();
        PrivateKeyInfo.encode(derOutputStream, algorithmId3, byArray2, pKCSAttributes);
        byte[] byArray3 = derOutputStream.toByteArray();
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = this.provider != null ? SecretKeyFactory.getInstance((String)objectArray, this.provider) : SecretKeyFactory.getInstance((String)objectArray);
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", exception);
            }
            throw new PKCSException(exception, "Error encrypting private key (" + exception.toString() + ")");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance((String)objectArray, this.provider) : Cipher.getInstance((String)objectArray);
            cipher.init(1, secretKey);
            byArray = cipher.doFinal(byArray3);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", exception);
            }
            throw new PKCSException(exception, "Error encrypting private key (" + exception.toString() + ")");
        }
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        byte[] byArray4 = null;
        if (algorithmParameters != null) {
            byArray4 = algorithmParameters.getEncoded();
        }
        try {
            algorithmId2 = AlgorithmId.get(cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "EncryptedPrivateKeyInfo", noSuchAlgorithmException);
            }
            throw new PKCSException(noSuchAlgorithmException, "Unsupported password-based encryption algorithm: " + cipher.getAlgorithm());
        }
        if (byArray4 != null) {
            ObjectIdentifier objectIdentifier = algorithmId2.getOID();
            algorithmId = new AlgorithmId(objectIdentifier, byArray4, this.provider);
        } else {
            algorithmId = algorithmId2;
        }
        this.setEncryptionAlgorithm(algorithmId);
        this.setEncryptionKey(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedPrivateKeyInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    public EncryptedPrivateKeyInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "EncryptedPrivateKeyInfo", objectArray);
            debug.exit(16384L, className, "EncryptedPrivateKeyInfo");
        }
    }

    private void setEncryptionAlgorithm(AlgorithmId algorithmId) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "SetEncryptionAlgorithm", algorithmId);
            debug.exit(8192L, className, "SetEncryptionAlgorithm");
        }
        this.algid = algorithmId;
    }

    private void setEncryptionKey(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "SetEncryptionKey", (Object)byArray);
        }
        this.encryptedKey = (byte[])byArray.clone();
        if (debug != null) {
            debug.exit(8192L, className, "SetEncryptionKey");
        }
    }

    public Object clone() {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", encryptedPrivateKeyInfo);
            }
            return encryptedPrivateKeyInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.algid.encode(derOutputStream);
        derOutputStream.putOctetString(this.encryptedKey);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof EncryptedPrivateKeyInfo) {
            bl = this.equals((EncryptedPrivateKeyInfo)object);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", bl);
            }
            return bl;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getAlgorithmId");
                debug.exit(16384L, (Object)className, "getAlgorithmId_1", new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAlgorithmId_2", new AlgorithmId(this.algid.getOID(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.provider);
        }
    }

    public byte[] getEncryptedData() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedData");
        }
        byte[] byArray = (byte[])this.encryptedKey.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedData", byArray);
        }
        return byArray;
    }

    public byte[] decrypt(char[] cArray) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)cArray);
        }
        String string = this.algid.getName();
        byte[] byArray = this.algid.getParameters();
        DerValue derValue = new DerValue(byArray);
        DerValue[] derValueArray = new DerValue[]{derValue.getData().getDerValue(), derValue.getData().getDerValue()};
        byte[] byArray2 = derValueArray[0].getOctetString();
        int n = derValueArray[1].getInteger().intValue();
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray2, n);
        try {
            AlgorithmParameters algorithmParameters = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
            algorithmParameters.init(pBEParameterSpec);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = this.provider != null ? Cipher.getInstance(string, this.provider) : Cipher.getInstance(string);
            cipher.init(2, (Key)secretKey, algorithmParameters);
            byte[] byArray3 = cipher.doFinal(this.encryptedKey);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", byArray3);
            }
            return byArray3;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", exception);
            }
            throw new PKCSException(exception, "Private key decryption error: (" + exception.toString() + ")");
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS #8 EncryptedPrivateKeyInfo:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + "\talgorithm identifier: " + this.algid;
        string = string + "\r\n\tencrypted key:\r\n" + hexDumpEncoder.encode(this.encryptedKey);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedPrivateKeyInfo parsing error.");
            }
            throw new IOException("EncryptedPrivateKeyInfo parsing error.");
        }
        this.algid = AlgorithmId.parse(derValue.getData().getDerValue());
        this.encryptedKey = derValue.getData().getOctetString();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedPrivateKeyInfo parsing error.  Field overrun.");
            }
            throw new IOException("EncryptedPrivateKeyInfo parsing error.  Field overrun.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", encryptedPrivateKeyInfo);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            encryptedPrivateKeyInfo.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

