/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignerIdentifier;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcs9.SigningTime;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public final class SignerInfo
extends PKCSDerObject
implements Cloneable,
DerEncoder {
    private static final byte TAG_SIGNED_ATTRS = 0;
    private static final byte TAG_UNSIGNED_ATTRS = 1;
    private BigInteger version;
    private SignerIdentifier sid;
    private AlgorithmId digestAlgorithm;
    private PKCSAttributes signedAttrs;
    private AlgorithmId signatureAlgorithm;
    private byte[] signature;
    private PKCSAttributes unsignedAttrs;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignerInfo";
    private volatile int cachedHashVal = 0;

    public SignerInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerInfo", (Object)byArray);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", byArray, string);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    SignerInfo(Certificate certificate) throws IOException {
        this(certificate, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerInfo", certificate);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    SignerInfo(Certificate certificate, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", certificate, string);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        this.setIssuer(certificate);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(SignerIdentifier signerIdentifier, ContentInfo contentInfo, String string, PrivateKey privateKey, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2) throws PKCSException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        this(signerIdentifier, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{signerIdentifier, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2};
            debug.entry(16384L, (Object)className, "SignerInfo", objectArray);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(SignerIdentifier signerIdentifier, ContentInfo contentInfo, String string, PrivateKey privateKey, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, String string2) throws PKCSException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{signerIdentifier, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2, string2};
            debug.entry(16384L, (Object)className, "SignerInfo", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Digest and signature algorithm not specified.");
            }
            throw new IllegalArgumentException("Digest and signature algorithm not specified.");
        }
        this.signedAttrs = pKCSAttributes;
        this.unsignedAttrs = pKCSAttributes2;
        this.sid = signerIdentifier;
        this.sign(contentInfo, string, privateKey);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(Certificate certificate, ContentInfo contentInfo, String string, PrivateKey privateKey, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2) throws PKCSException, IOException, NoSuchAlgorithmException {
        this(certificate, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificate, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2};
            debug.entry(16384L, (Object)className, "SignerInfo", objectArray);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(Certificate certificate, ContentInfo contentInfo, String string, PrivateKey privateKey, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, String string2) throws PKCSException, IOException, NoSuchAlgorithmException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificate, contentInfo, string, privateKey, pKCSAttributes, pKCSAttributes2, string2};
            debug.entry(16384L, (Object)className, "SignerInfo", objectArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerInfo", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        this.sid = new SignerIdentifier(certificate, string2);
        this.signedAttrs = pKCSAttributes;
        this.unsignedAttrs = pKCSAttributes2;
        this.sign(contentInfo, string, privateKey);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SignerInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public SignerInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SignerInfo", objectArray);
            debug.exit(16384L, className, "SignerInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SignerInfo signerInfo = new SignerInfo(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signerInfo);
            }
            return signerInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void setIssuer(Certificate certificate) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuer", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(8192L, className, "setIssuer", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        Principal principal = x509Certificate.getIssuerDN();
        String string = principal.getName();
        X500Name x500Name = new X500Name(string);
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x500Name, bigInteger, this.provider);
        this.sid = new SignerIdentifier(issuerAndSerialNumber, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setIssuer");
        }
    }

    byte[] signSignatureOnly(byte[] byArray, String string, PrivateKey privateKey) throws PKCSException, NoSuchAlgorithmException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, string, privateKey};
            debug.entry(16384L, (Object)className, "signSignatureOnly", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "signSignatureOnly", "Digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Digest and signature algorithm must be specified.");
        }
        this.signature = null;
        objectArray = PKCS7.getDigestAlgorithm(string);
        this.setDigestAlgorithm((String)objectArray);
        this.setSignatureAlgorithm(string);
        byte[] byArray2 = this.signSignatureOnly(byArray, privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "signSignatureOnly", byArray2);
        }
        return byArray2;
    }

    private byte[] signSignatureOnly(byte[] byArray, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object object;
        if (debug != null) {
            object = new Object[]{byArray, privateKey};
            debug.entry(8192L, (Object)className, "signSignatureOnly", (Object[])object);
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(8192L, className, "signSignatureOnly", "Message was not specified.");
            }
            throw new IllegalArgumentException("Message was not specified.");
        }
        this.signature = null;
        String string = this.signatureAlgorithm.getName();
        try {
            object = this.provider != null ? Signature.getInstance(string, this.provider) : Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", noSuchAlgorithmException);
            }
            this.removeSignedAttributes();
            throw new PKCSException(noSuchAlgorithmException, "Could not obtain the algorithm for " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", noSuchProviderException);
            }
            this.removeSignedAttributes();
            throw new PKCSException(noSuchProviderException, "Provider " + this.provider + " not found");
        }
        try {
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray);
            this.signature = ((Signature)object).sign();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "signSignatureOnly", exception);
            }
            throw new PKCSException(exception, "Error signing digest: " + exception.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "signSignatureOnly", this.signature);
        }
        return this.signature;
    }

    private byte[] sign(ContentInfo contentInfo, String string, PrivateKey privateKey) throws PKCSException, NoSuchAlgorithmException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, privateKey};
            debug.entry(8192L, (Object)className, "sign", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Message digest and signature algorithm must be specified.");
            }
            throw new IllegalArgumentException("Message digest and signature algorithm must be specified.");
        }
        objectArray = PKCS7.getDigestAlgorithm(string);
        this.signature = null;
        this.setDigestAlgorithm((String)objectArray);
        this.setSignatureAlgorithm(string);
        this.setSignedAttributes(contentInfo);
        byte[] byArray = this.sign(string, privateKey);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", byArray);
        }
        return byArray;
    }

    private byte[] sign(PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        Signature signature;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "sign", privateKey);
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (!this.hasSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID)) {
            String string = "Could not find the MESSAGE_DIGEST_OID signed attribute.  Message digest needs to be calculated.";
            if (debug != null) {
                debug.text(8192L, className, "sign", string);
            }
            throw new IllegalArgumentException(string);
        }
        this.signature = null;
        this.setSigningTime();
        byte[] byArray = this.calculatePreMessageDigest((byte)0);
        if (byArray == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Could not calculate a message digest.");
            }
            this.removeSignedAttributes();
            throw new PKCSException("Could not calculate a message digest.");
        }
        String string = this.signatureAlgorithm.getName();
        try {
            signature = this.provider != null ? Signature.getInstance(string, this.provider) : Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", noSuchAlgorithmException);
                debug.text(8192L, className, "sign", "Could not obtain the algorithm for " + string);
            }
            this.removeSignedAttributes();
            throw new PKCSException(noSuchAlgorithmException, "Could not obtain the algorithm for " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(8192L, className, "sign", noSuchProviderException);
                debug.text(8192L, className, "sign", "Provider " + this.provider + " not found.");
            }
            this.removeSignedAttributes();
            throw new PKCSException(noSuchProviderException, "Provider " + this.provider + " not found.");
        }
        try {
            signature.initSign(privateKey);
            signature.update(byArray);
            this.signature = signature.sign();
        }
        catch (Exception exception) {
            this.removeSignedAttributes();
            if (debug != null) {
                debug.exception(8192L, className, "sign", exception);
                debug.text(8192L, className, "sign", "Error signing digest: " + exception.toString());
            }
            throw new PKCSException(exception, "Error signing digest: " + exception.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", this.signature);
        }
        return this.signature;
    }

    private void setSigningTime() throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "setSigningTime");
        }
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SigningTime signingTime = new SigningTime(date);
        this.addSignedAttribute(signingTime.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setSigningTime");
        }
    }

    public SigningTime getSigningTime() {
        PKCSAttribute pKCSAttribute;
        if (debug != null) {
            debug.entry(8192L, className, "getSigningTime");
        }
        if ((pKCSAttribute = this.getSignedAttribute(PKCSOID.SIGNING_TIME_OID)) != null) {
            SigningTime signingTime = (SigningTime)pKCSAttribute.getPKCS9DerObject();
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSigningTime", signingTime);
            }
            return signingTime;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getSigningTime", null);
        }
        return null;
    }

    private byte[] sign(String string, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "sign", string, privateKey);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Signature algorithm was not specified.");
            }
            throw new IllegalArgumentException("Signature algorithm was not specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "sign", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        this.signature = null;
        this.setSignatureAlgorithm(string);
        byte[] byArray = this.sign(privateKey);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "sign", byArray);
        }
        return byArray;
    }

    public boolean verify(Certificate certificate, byte[] byArray) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", certificate, byArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(8192L, className, "verify", "Certificate was not specified.");
            }
            throw new IllegalArgumentException("Certificate was not specified.");
        }
        PublicKey publicKey = ((X509Certificate)certificate).getPublicKey();
        boolean bl = this.verify(publicKey, byArray);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(bl));
        }
        return bl;
    }

    public boolean verify(PublicKey publicKey, byte[] byArray) throws PKCSException, IOException, NoSuchAlgorithmException {
        return this.verify(publicKey, byArray, (byte)0);
    }

    boolean verify(PublicKey publicKey, byte[] byArray, byte by) throws PKCSException, IOException, NoSuchAlgorithmException {
        Signature signature;
        String string;
        if (debug != null) {
            debug.entry(16384L, className, "verify", publicKey, byArray);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Private key was not specified.");
            }
            throw new IllegalArgumentException("Private key was not specified.");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature was not set.");
            }
            throw new IllegalArgumentException("Signature was not set.");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature algorithm was not set.");
            }
            throw new IllegalArgumentException("Signature algorithm was not set.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array to compute the message digest comparision was not set.");
            }
            throw new IllegalArgumentException("Byte array to compute the message digest comparision was not set.");
        }
        if (!this.compareDigest(byArray)) {
            return false;
        }
        byte[] byArray2 = this.calculatePreMessageDigest(by);
        if (byArray2 == null && !this.hasSignedAttributes()) {
            byArray2 = byArray;
        }
        if (byArray2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Could not calculate the signature verification digest.");
            }
            throw new PKCSException("Could not calculate the signature verification digest.");
        }
        String string2 = this.signatureAlgorithm.getName();
        int n = string2.indexOf(string = this.digestAlgorithm.getName());
        if (n == -1) {
            string2 = this.digestAlgorithm.getName() + "/" + this.signatureAlgorithm.getName();
        }
        try {
            signature = this.provider != null ? Signature.getInstance(string2, this.provider) : Signature.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", noSuchAlgorithmException);
                debug.text(16384L, className, "verify", "Could not obtain the algorithm for " + string2);
            }
            throw new PKCSException(noSuchAlgorithmException, "Could not obtain the algorithm for " + string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", noSuchProviderException);
                debug.text(16384L, className, "verify", "Provider " + this.provider + " not found");
            }
            throw new PKCSException(noSuchProviderException, "Provider " + this.provider + " not found");
        }
        try {
            signature.initVerify(publicKey);
            signature.update(byArray2);
            boolean bl = signature.verify(this.signature);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(bl));
            }
            return bl;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Error verifying signature: " + exception.toString());
            }
            throw new PKCSException(exception, "Error verifying signature: " + exception.toString());
        }
    }

    public boolean compareDigest(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "compareDigest", (Object)byArray);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Byte array to compute the message digest comparision was not set.");
        }
        byte[] byArray2 = this.calculateMessageDigest(byArray);
        if (byArray2 == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_1", new Boolean(false));
            }
            return false;
        }
        byte[] byArray3 = this.getMessageDigest();
        if (byArray3 == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_2", new Boolean(true));
            }
            return true;
        }
        if (byArray2.length != byArray3.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_3", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray3[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "compareDigest_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "compareDigest", new Boolean(true));
        }
        return true;
    }

    private byte[] calculatePreMessageDigest(byte by) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculatePreMessageDigest");
        }
        if (this.signedAttrs == null || this.signedAttrs.size() < 2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMessageDigest_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = this.getSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        PKCSAttribute pKCSAttribute2 = this.getSignedAttribute(PKCSOID.CONTENT_TYPE_OID);
        if (pKCSAttribute2 == null || pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMessageDigest_2", null);
            }
            return null;
        }
        byte[] byArray = null;
        if (by == 0) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encodeSignedAttributesExplicit(derOutputStream);
            byArray = derOutputStream.toByteArray();
        } else if (by == 1) {
            if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
                byArray = this.signedAttrs.getOriginalEncoded();
                if (byArray == null) {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    this.encodeSignedAttributesExplicit(derOutputStream);
                    byArray = derOutputStream.toByteArray();
                }
            } else {
                byArray = new DerOutputStream().toByteArray();
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculatePreMessageDigest", byArray);
        }
        return byArray;
    }

    public byte[] getMessageDigest() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getMessageDigest");
        }
        if (this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = this.getSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_2", null);
            }
            return null;
        }
        MessageDigest messageDigest = (MessageDigest)pKCSAttribute.getPKCS9DerObject();
        if (messageDigest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMessageDigest_3", null);
            }
            return null;
        }
        byte[] byArray = messageDigest.getBytes();
        byte[] byArray2 = (byte[])byArray.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMessageDigest", byArray2);
        }
        return byArray2;
    }

    private void setSignedAttributes(ContentInfo contentInfo) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignedAttributes", contentInfo);
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "setSignedAttributes", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "setSignedAttributes", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        ContentType contentType = new ContentType(contentInfo.getContentType(), this.provider);
        byte[] byArray = this.calculateMessageDigest(contentInfo);
        MessageDigest messageDigest = new MessageDigest(this.provider);
        messageDigest.setData(byArray);
        this.addSignedAttribute(contentType.getPKCSAttribute());
        this.addSignedAttribute(messageDigest.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setSignedAttributes");
        }
    }

    private void removeSignedAttributes() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "removeSignedAttributes");
        }
        this.removeSignedAttribute(PKCSOID.CONTENT_TYPE_OID);
        this.removeSignedAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        this.removeSignedAttribute(PKCSOID.SIGNING_TIME_OID);
        if (debug != null) {
            debug.exit(8192L, className, "removeSignedAttributes");
        }
    }

    private void addSignedAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addSignedAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addSignedAttribute_1");
            }
            return;
        }
        this.signedAttrs = this.signedAttrs == null ? (PKCSAttributes)pKCSAttributes.clone() : this.signedAttrs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(8192L, className, "addSignedAttribute");
        }
    }

    private void addSignedAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addSignedAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.entry(8192L, className, "addSignedAttribute_1");
            }
            return;
        }
        if (this.signedAttrs == null) {
            this.signedAttrs = new PKCSAttributes(this.provider);
        }
        this.signedAttrs = this.signedAttrs.addAttribute(pKCSAttribute);
        if (debug != null) {
            debug.entry(8192L, className, "addSignedAttribute");
        }
    }

    void removeSignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeSignedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeSignedAttribute_1");
            }
            return;
        }
        this.signedAttrs = this.signedAttrs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(16384L, className, "removeSignedAttribute");
        }
    }

    private void addUnsignedAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnsignedAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnsignedAttribute_1");
            }
            return;
        }
        this.unsignedAttrs = this.unsignedAttrs == null ? (PKCSAttributes)this.unsignedAttrs.clone() : this.unsignedAttrs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(8192L, className, "addUnsignedAttribute");
        }
    }

    private void addUnsignedAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnsignedAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnsignedAttribute_1");
            }
            return;
        }
        if (this.unsignedAttrs == null) {
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
            this.unsignedAttrs = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            this.unsignedAttrs = this.unsignedAttrs.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnsignedAttribute");
        }
    }

    void removeUnsignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeUnsignedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unsignedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeUnsignedAttribute_1");
            }
            return;
        }
        this.unsignedAttrs = this.unsignedAttrs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(16384L, className, "removeUnsignedAttribute");
        }
    }

    public PKCSAttribute getSignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSignedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.signedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.signedAttrs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignedAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public PKCSAttribute getUnsignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnsignedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unsignedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnsignedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.unsignedAttrs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnsignedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnsignedAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public boolean hasSignedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasSignedAttribute", objectIdentifier);
        }
        PKCSAttribute pKCSAttribute = this.getSignedAttribute(objectIdentifier);
        boolean bl = false;
        if (pKCSAttribute != null) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignedAttribute", new Boolean(bl));
        }
        return bl;
    }

    private byte[] getMessageDigest(ContentInfo contentInfo, String string) throws IOException, PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "getMessageDigest", contentInfo, string);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "getMessageDigest", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        if (string == null && this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "getMessageDigest", "Message digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Message digest algorithm was not specified.");
        }
        if (string != null) {
            this.setDigestAlgorithm(string);
        }
        byte[] byArray = this.getMessageDigest(contentInfo);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMessageDigest", byArray);
        }
        return byArray;
    }

    private byte[] getMessageDigest(ContentInfo contentInfo) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "getMessageDigest", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getMessageDigest", "Content info was not specified.");
            }
            throw new IllegalArgumentException("Content info was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        this.signature = null;
        this.setSignedAttributes(contentInfo);
        byte[] byArray = this.getMessageDigest();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getMessageDigest", byArray);
        }
        return byArray;
    }

    private byte[] calculateMessageDigest(ContentInfo contentInfo) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "ContentInfo was not specified.");
            }
            throw new IllegalArgumentException("ContentInfo was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        this.signature = null;
        DerOutputStream derOutputStream = new DerOutputStream();
        contentInfo.getContent().encode(derOutputStream);
        DerValue derValue = new DerValue(derOutputStream.toByteArray());
        byte[] byArray = derValue.getData().toByteArray();
        byte[] byArray2 = this.calculateMessageDigest(byArray);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", byArray2);
        }
        return byArray2;
    }

    private byte[] calculateMessageDigest(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", (Object)byArray);
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        String string = this.digestAlgorithm.getName();
        java.security.MessageDigest messageDigest = null;
        try {
            messageDigest = this.provider != null ? java.security.MessageDigest.getInstance(string, this.provider) : java.security.MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", noSuchAlgorithmException);
                debug.text(8192L, className, "calculateMessageDigest", "Could not obtain the algorithm for " + string);
            }
            throw new IOException("Could not obtain the algorithm for " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", noSuchProviderException);
                debug.text(8192L, className, "calculateMessageDigest", "Could not obtain the provider for " + this.provider);
            }
            throw new IOException("Could not obtain the provider for " + this.provider);
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", byArray2);
        }
        return byArray2;
    }

    public boolean hasCertificate(Certificate certificate) throws IOException {
        BigInteger bigInteger;
        X500Name x500Name;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasCertificate", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_1", new Boolean(false));
            }
            return false;
        }
        if (!this.sid.isIssuer()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_2", new Boolean(false));
            }
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        Principal principal = x509Certificate.getIssuerDN();
        X500Name x500Name2 = new X500Name(principal.getName());
        if (!x500Name2.equals(x500Name = this.sid.getIssuer().getIssuer())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_3", new Boolean(false));
            }
            return false;
        }
        BigInteger bigInteger2 = x509Certificate.getSerialNumber();
        if (!bigInteger2.equals(bigInteger = this.sid.getIssuer().getSerialNumber())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasCertificate_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCertificate", new Boolean(true));
        }
        return true;
    }

    public boolean hasIssuer(IssuerAndSerialNumber issuerAndSerialNumber) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasIssuer", issuerAndSerialNumber);
        }
        if (issuerAndSerialNumber == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasIssuer_1", new Boolean(false));
            }
            return false;
        }
        if (!this.sid.isIssuer()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasIssuer_1", new Boolean(false));
            }
            return false;
        }
        IssuerAndSerialNumber issuerAndSerialNumber2 = this.sid.getIssuer();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasIssuer_2", new Boolean(issuerAndSerialNumber2.equals(issuerAndSerialNumber)));
        }
        return issuerAndSerialNumber2.equals(issuerAndSerialNumber);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        this.encode(outputStream);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "derEncode", outputStream);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        this.sid.encode(derOutputStream);
        this.digestAlgorithm.encode(derOutputStream);
        this.encodeSignedAttributes(derOutputStream);
        AlgorithmId algorithmId = this.getSignatureAlgorithmOnly();
        if (algorithmId == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
            }
            throw new IOException("Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
        }
        algorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(this.signature);
        if (this.unsignedAttrs != null && this.unsignedAttrs.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.unsignedAttrs.encode(derOutputStream3);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    void encodeWithOriginalAttrs(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        this.sid.encode(derOutputStream);
        this.digestAlgorithm.encode(derOutputStream);
        this.encodeOriginalSignedAttributes(derOutputStream);
        AlgorithmId algorithmId = this.getSignatureAlgorithmOnly();
        if (algorithmId == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
            }
            throw new IOException("Cannot retrieve signature algorithm from " + this.signatureAlgorithm + ".");
        }
        algorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(this.signature);
        if (this.unsignedAttrs != null && this.unsignedAttrs.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            byte[] byArray = this.unsignedAttrs.getOriginalEncoded();
            if (byArray != null) {
                derOutputStream3.write(byArray);
            } else {
                this.unsignedAttrs.encode(derOutputStream3);
            }
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    private void encodeSignedAttributes(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeSignedAttributes", derOutputStream);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.signedAttrs.encode(derOutputStream2);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeSignedAttributes");
        }
    }

    private void encodeOriginalSignedAttributes(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeSignedAttributes", derOutputStream);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            byte[] byArray = this.signedAttrs.getOriginalEncoded();
            if (byArray != null) {
                derOutputStream2.write(byArray);
            } else {
                this.signedAttrs.encode(derOutputStream2);
            }
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeSignedAttributes");
        }
    }

    void encodeSignedAttributesExplicit(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encodeSignedAttributesExplicit", derOutputStream);
        }
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            derOutputStream.write(this.signedAttrs.generateDerEncoding());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encodeSignedAttributesExplicit");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerInputStream derInputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SignedData parsing error");
            }
            throw new IOException("SignedData parsing error");
        }
        this.version = derValue.getData().getInteger();
        if (this.version.intValue() != 1 && this.version.intValue() != 3) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid SignerInfo version = " + this.version + " (must be 1 or 3).");
            }
            throw new IOException("Invalid SignerInfo version = " + this.version + " (must be 1 or 3).");
        }
        this.sid = new SignerIdentifier(derValue.getData().getDerValue().toByteArray(), this.provider);
        this.digestAlgorithm = AlgorithmId.parse(derValue.getData().getDerValue());
        boolean bl = false;
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            derInputStream = new DerInputStream(derValue2.toByteArray());
            this.signedAttrs = new PKCSAttributes(derInputStream, this.provider);
            bl = true;
        } else {
            this.signedAttrs = null;
        }
        this.signatureAlgorithm = bl ? AlgorithmId.parse(derValue.getData().getDerValue()) : AlgorithmId.parse(derValue2);
        this.signature = derValue.getData().getOctetString();
        if (derValue.getData().available() != 0) {
            derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                derInputStream = new DerInputStream(derValue2.toByteArray());
                this.unsignedAttrs = new PKCSAttributes(derInputStream, this.provider);
            } else {
                this.unsignedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof SignerInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((SignerInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        Date date;
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 SignerInfo:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n" + this.sid;
        string = string + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm;
        string = string + "\r\n\tsignatureAlgorithm: " + this.signatureAlgorithm + "\r\n";
        if (this.signedAttrs != null) {
            string = string + "\r\n\tsignedAttributes (" + this.signedAttrs.size() + "):\r\n";
            string = string + this.signedAttrs + "\r\n";
        } else {
            string = string + "\tsignedAttributes: null\r\n";
        }
        string = string + "\tdigestEncryptionAlgorithmId: " + this.digestAlgorithm;
        string = this.signature != null ? string + "\r\n\tsignature: \r\n" + hexDumpEncoder.encodeBuffer(this.signature) : string + "\r\n\tsignature: null\r\n";
        if (this.unsignedAttrs != null) {
            string = string + "\r\n\tunsignedAttributes (" + this.unsignedAttrs.size() + "):\r\n";
            string = string + this.unsignedAttrs + "\r\n";
        } else {
            string = string + "\tunsignedAttributes: null\r\n";
        }
        SigningTime signingTime = this.getSigningTime();
        string = signingTime == null ? string + "\tSigning Time = not set\r\n" : ((date = signingTime.getDate()) != null ? string + "\tSigning Time = " + date + "\r\n" : string + "\tSigning Time = not set\r\n");
        return string;
    }

    public boolean hasSignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasSignedAttributes");
        }
        boolean bl = false;
        if (this.signedAttrs != null && this.signedAttrs.size() > 0) {
            bl = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasSignedAttributes", new Boolean(bl));
        }
        return bl;
    }

    public boolean hasUnsignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsignedAttributes");
        }
        boolean bl = false;
        if (this.unsignedAttrs == null && this.unsignedAttrs.size() > 0) {
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsignedAttributes", new Boolean(bl));
        }
        return bl;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public SignerIdentifier getSignerIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignerIdentifier");
        }
        SignerIdentifier signerIdentifier = null;
        if (this.sid != null) {
            signerIdentifier = (SignerIdentifier)this.sid.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignerIdentifier", signerIdentifier);
        }
        return signerIdentifier;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        AlgorithmId algorithmId = null;
        if (this.digestAlgorithm != null) {
            algorithmId = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public PKCSAttributes getSignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignedAttributes");
        }
        PKCSAttributes pKCSAttributes = null;
        if (this.signedAttrs != null) {
            pKCSAttributes = this.signedAttrs;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignedAttributes", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public PKCSAttributes getUnsignedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnsignedAttributes");
        }
        PKCSAttributes pKCSAttributes = null;
        if (this.unsignedAttrs != null) {
            pKCSAttributes = this.unsignedAttrs;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnsignedAttributes", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public AlgorithmId getSignatureAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        AlgorithmId algorithmId = null;
        if (this.signatureAlgorithm != null) {
            algorithmId = new AlgorithmId(this.signatureAlgorithm.getOID(), this.signatureAlgorithm.getParameters(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    private AlgorithmId getSignatureAlgorithmOnly() {
        String string;
        String string2;
        int n;
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureAlgorithmOnly");
        }
        if ((n = (string2 = (string = this.signatureAlgorithm.toString()).toUpperCase()).indexOf("WITH")) != -1) {
            string = string.substring(n += 4);
        }
        try {
            AlgorithmId algorithmId = AlgorithmId.get(string);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSignatureAlgorithmOnly", algorithmId);
            }
            return algorithmId;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureAlgorithmOnly", noSuchAlgorithmException);
                debug.exit(8192L, (Object)className, "getSignatureAlgorithmOnly", null);
            }
            return null;
        }
    }

    private void setSignatureAlgorithm(AlgorithmId algorithmId) throws NoSuchAlgorithmException {
        AlgorithmId algorithmId2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", algorithmId);
        }
        String string = PKCS7.getDigestSignatureAlgorithm(this.digestAlgorithm, algorithmId);
        this.signatureAlgorithm = algorithmId2 = AlgorithmId.get(string);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    private void setSignatureAlgorithm(String string) throws NoSuchAlgorithmException {
        AlgorithmId algorithmId;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureAlgorithm", string);
        }
        String string2 = null;
        if (this.digestAlgorithm != null) {
            string2 = this.digestAlgorithm.getName();
        }
        String string3 = PKCS7.getDigestSignatureAlgorithm(string2, string);
        this.signatureAlgorithm = algorithmId = AlgorithmId.get(string3);
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureAlgorithm");
        }
    }

    private void setDigestAlgorithm(AlgorithmId algorithmId) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", algorithmId);
        }
        this.digestAlgorithm = algorithmId;
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void setDigestAlgorithm(String string) throws IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", string);
        }
        this.digestAlgorithm = AlgorithmId.get(string);
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "setSignature");
        }
        byte[] byArray = null;
        if (this.signature != null) {
            byArray = (byte[])this.signature.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "setSignature", byArray);
        }
        return byArray;
    }

    static DerEncoder[] castToDerEncoder(Object[] objectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "castToDerEncoder", objectArray);
        }
        DerEncoder[] derEncoderArray = new DerEncoder[objectArray.length];
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derEncoderArray[i] = (DerEncoder)objectArray[i];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "castToDerEncoder", derEncoderArray);
        }
        return derEncoderArray;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "castToDerEncoder");
        }
        this.version = BigInteger.ONE;
        if (!this.sid.isIssuer()) {
            this.version = BigInteger.valueOf(3L);
        }
        if (debug != null) {
            debug.exit(16384L, className, "castToDerEncoder");
        }
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.sid == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing sid value.");
            }
            throw new IOException("SignerInfo missing sid value.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing digestAlgorithm value.");
            }
            throw new IOException("SignerInfo missing digestAlgorithm value.");
        }
        if (this.signatureAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing signatureAlgorithm value.");
            }
            throw new IOException("SignerInfo missing signatureAlgorithm value.");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "SignerInfo missing signature value.");
            }
            throw new IOException("SignerInfo missing signature value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }
}

