/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.SubjectKeyIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class SignerIdentifier
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_KEYID = 0;
    private IssuerAndSerialNumber issuer;
    private byte[] keyid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.SignerIdentifier";
    private volatile int cachedHashVal = 0;

    public SignerIdentifier(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", (Object)byArray);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", byArray, string);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this(issuerAndSerialNumber, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", issuerAndSerialNumber);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(IssuerAndSerialNumber issuerAndSerialNumber, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", issuerAndSerialNumber, string);
        }
        if (issuerAndSerialNumber == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "IssuerAndSerialNumber not specified.");
            }
            throw new IllegalArgumentException("IssuerAndSerialNumber not specified.");
        }
        this.issuer = issuerAndSerialNumber;
        this.keyid = null;
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this(subjectKeyIdentifier, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", subjectKeyIdentifier);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(SubjectKeyIdentifier subjectKeyIdentifier, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", subjectKeyIdentifier, string);
        }
        if (subjectKeyIdentifier == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "SubjectKeyIdentifier not specified.");
            }
            throw new IllegalArgumentException("SubjectKeyIdentifier not specified.");
        }
        this.issuer = null;
        this.keyid = subjectKeyIdentifier.getIdentifier();
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifier");
        }
    }

    public SignerIdentifier(Certificate certificate) throws IOException {
        this(certificate, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SignerIdentifier", certificate);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(Certificate certificate, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", certificate, string);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "SignerIdentifier", "Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        this.issuer = new IssuerAndSerialNumber((X509Certificate)certificate, string);
        this.keyid = null;
        if (debug != null) {
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SignerIdentifier", string, new Boolean(bl));
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public SignerIdentifier(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SignerIdentifier", objectArray);
            debug.exit(16384L, className, "SignerIdentifer");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SignerIdentifier signerIdentifier = new SignerIdentifier(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signerIdentifier);
            }
            return signerIdentifier;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof SignerIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((SignerIdentifier)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.issuer == null && this.keyid == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "IssuerAndSerialNumber or SubjectKeyIdentifier not specified.");
            }
            throw new IOException("IssuerAndSerialNumber or SubjectKeyIdentifier not specified.");
        }
        if (this.keyid != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.keyid);
            outputStream.write(derOutputStream.toByteArray());
        } else {
            this.issuer.encode(outputStream);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if ((byte)derValue.getData().peekByte() == 48) {
            this.issuer = new IssuerAndSerialNumber(derValue.toByteArray(), this.provider);
            this.keyid = null;
        } else {
            this.keyid = derValue.getOctetString();
            this.issuer = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public IssuerAndSerialNumber getIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        IssuerAndSerialNumber issuerAndSerialNumber = null;
        if (this.issuer != null) {
            issuerAndSerialNumber = (IssuerAndSerialNumber)this.issuer.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer", issuerAndSerialNumber);
        }
        return issuerAndSerialNumber;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectKeyIdentifier");
        }
        if (this.keyid == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectKeyIdentifier_1", null);
            }
            return null;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = null;
        try {
            subjectKeyIdentifier = new SubjectKeyIdentifier(this.provider);
            subjectKeyIdentifier.setIdentifier(this.keyid);
        }
        catch (PKCSException pKCSException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectKeyIdentifier", pKCSException);
            }
            subjectKeyIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectKeyIdentifier", subjectKeyIdentifier);
        }
        return subjectKeyIdentifier;
    }

    public boolean isIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "isIssuer");
        }
        boolean bl = false;
        if (this.issuer != null) {
            bl = true;
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isIssuer", new Boolean(bl));
        }
        return bl;
    }

    public String toString() {
        String string = "PKCS7 SignerIdentifier:\r\n";
        if (this.issuer != null) {
            string = string + this.issuer.toString();
        } else {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            string = this.keyid != null ? string + "\r\n\tSubjectKeyIdentifier: \r\n" + hexDumpEncoder.encodeBuffer(this.keyid) : string + "\r\n\tSubjectKeyIdentifier: null\r\n";
        }
        return string;
    }
}

