/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AVA;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class RecipientKeyIdentifier
extends PKCSDerObject
implements RecipientIdentifier,
Cloneable {
    private byte[] keyId;
    private Date date;
    private AVA other;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.RecipientKeyIdentifier";
    private volatile int cachedHashVal = 0;

    public RecipientKeyIdentifier(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", (Object)byArray);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientKeyIdentifier", byArray, string);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] byArray, Date date, AVA aVA) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, date, aVA};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", objectArray);
        }
        this.keyId = byArray;
        this.date = date;
        this.other = aVA;
        if (debug != null) {
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(byte[] byArray, Date date, AVA aVA, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, date, aVA, string};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", objectArray);
        }
        this.keyId = byArray;
        this.date = date;
        this.other = aVA;
        if (debug != null) {
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientKeyIdentifier", string, new Boolean(bl));
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public RecipientKeyIdentifier(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "RecipientKeyIdentifier", objectArray);
            debug.exit(16384L, className, "RecipientKeyIdentifier");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOctetString(this.keyId);
        if (this.date != null) {
            derOutputStream.putGeneralizedTime(this.date);
        }
        if (this.other != null) {
            this.other.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientKeyIdentifier parsing error");
            }
            throw new IOException("RecipientKeyIdentifier parsing error");
        }
        this.keyId = derValue.getData().getOctetString();
        while (derValue.getData().available() != 0) {
            int n = derValue.getData().peekByte();
            if (n == 24) {
                this.date = derValue.getData().getGeneralizedTime();
                continue;
            }
            if (n != 48) continue;
            this.other = new AVA(derValue.getData());
            break;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof RecipientKeyIdentifier)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((RecipientKeyIdentifier)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public byte[] getKeyIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyIdentifier");
        }
        if (this.keyId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyIdentifier", null);
            }
            return null;
        }
        byte[] byArray = (byte[])this.keyId.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyIdentifier", byArray);
        }
        return byArray;
    }

    public Date getDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getDate");
        }
        if (this.date == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDate", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDate", this.date.clone());
        }
        return (Date)this.date.clone();
    }

    public AVA getOtherKeyAttribute() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOtherKeyAttribute");
        }
        if (this.other == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOtherKeyAttribute", null);
            }
            return null;
        }
        AVA aVA = new AVA(this.other.getOID(), this.other.getDerValue());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOtherKeyAttribute", aVA);
        }
        return aVA;
    }

    public String toString() {
        String string = null;
        String string2 = null;
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string3 = "";
        if (this.date != null) {
            string = this.date.toString();
        }
        if (this.other != null) {
            string2 = this.other.toString();
        }
        string3 = string3 + "\tkeyId:\r\n" + hexDumpEncoder.encodeBuffer(this.keyId);
        string3 = string3 + "\r\n\tdate: " + string;
        string3 = string3 + "\r\n\tother: " + string2;
        return string3;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            RecipientKeyIdentifier recipientKeyIdentifier = new RecipientKeyIdentifier(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", recipientKeyIdentifier);
            }
            return recipientKeyIdentifier;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

