/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.OriginatorInfo;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class EnvelopedData
extends Content
implements Cloneable {
    private BigInteger version;
    private OriginatorInfo originator;
    private RecipientInfo[] recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private PKCSAttributes unprotectedAttrs;
    private ContentInfo content;
    private byte[] encryptedContent;
    private SmudgedBytes contentEncryptionKey;
    private String contentEncryptionAlgorithm;
    private AlgorithmId contentEncryptionAlgId;
    private static final byte TAG_OINFO = 0;
    private static final byte TAG_UNPROTECTED_ATTRS = 1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EnvelopedData";

    public EnvelopedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EnvelopedData", (Object)byArray);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "EnvelopedData", byArray, string);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(OriginatorInfo originatorInfo, RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo, PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            Object[] objectArray = new Object[]{originatorInfo, recipientInfoArray, encryptedContentInfo, pKCSAttributes};
            debug.entry(16384L, (Object)className, "EnvelopedData", objectArray);
        }
        this.originator = originatorInfo;
        this.recipientInfos = recipientInfoArray;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = pKCSAttributes;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(OriginatorInfo originatorInfo, RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo, PKCSAttributes pKCSAttributes, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{originatorInfo, recipientInfoArray, encryptedContentInfo, pKCSAttributes, string};
            debug.entry(16384L, (Object)className, "EnvelopedData", objectArray);
        }
        this.originator = originatorInfo;
        this.recipientInfos = recipientInfoArray;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = pKCSAttributes;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(Certificate[] certificateArray, ContentInfo contentInfo, String string, int n, PKCSAttributes pKCSAttributes) throws PKCSException, IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{certificateArray, contentInfo, string, pKCSAttributes};
            debug.entry(16384L, (Object)className, "EnvelopedData", objectArray);
        }
        this.encryptContent(contentInfo, string, n);
        this.addRecipient(certificateArray);
        this.addUnprotectedAttribute(pKCSAttributes);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(Certificate[] certificateArray, ContentInfo contentInfo, String string, int n, PKCSAttributes pKCSAttributes, String string2) throws PKCSException, IOException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificateArray, contentInfo, string, new Integer(n), pKCSAttributes, string2};
            debug.entry(16384L, (Object)className, "EnvelopedData", objectArray);
        }
        this.encryptContent(contentInfo, string, n);
        this.addRecipient(certificateArray);
        this.addUnprotectedAttribute(pKCSAttributes);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "EnvelopedData", string, new Boolean(bl));
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public EnvelopedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "EnvelopedData", objectArray);
            debug.exit(16384L, className, "EnvelopedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            EnvelopedData envelopedData = new EnvelopedData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", envelopedData);
            }
            return envelopedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerValue[] derValueArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.checkValues();
        this.calculateVersion();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        if (this.originator != null) {
            derValueArray = new DerOutputStream();
            this.originator.encode((OutputStream)derValueArray);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)derValueArray);
        }
        derValueArray = this.recipientInfos != null ? new DerValue[this.recipientInfos.length] : new DerValue[]{};
        for (int i = 0; i < derValueArray.length; ++i) {
            derOutputStream = new DerOutputStream();
            this.recipientInfos[i].encode(derOutputStream);
            derValueArray[i] = new DerValue(derOutputStream.toByteArray());
        }
        derOutputStream2.putOrderedSetOf((byte)49, derValueArray);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        this.encryptedContentInfo.encode(derOutputStream4);
        derOutputStream2.putDerValue(new DerValue(derOutputStream4.toByteArray()));
        if (this.unprotectedAttrs != null && this.unprotectedAttrs.size() > 0) {
            derOutputStream = new DerOutputStream();
            this.unprotectedAttrs.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EnvelopedData parsing error.");
            }
            throw new IOException("EnvelopedData parsing error.");
        }
        this.version = derValue.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid EnvelopedData version (must be 0 or 2).");
            }
            throw new IOException("Invalid EnvelopedData version (must be 0 or 2).");
        }
        if ((byte)derValue.getData().peekByte() == -96) {
            derValue2 = derValue.getData().getDerValue();
            derValue2.resetTag((byte)48);
            this.originator = new OriginatorInfo(derValue2.toByteArray(), this.provider);
        } else {
            this.originator = null;
        }
        DerValue[] derValueArray = derValue.getData().getSet(1);
        int n = derValueArray.length;
        this.recipientInfos = new RecipientInfo[n];
        for (int i = 0; i < n; ++i) {
            this.recipientInfos[i] = new RecipientInfo(derValueArray[i].toByteArray(), this.provider);
        }
        derValue2 = derValue.getData().getDerValue();
        this.encryptedContentInfo = new EncryptedContentInfo(derValue2.toByteArray(), this.provider);
        if (derValue.getData().available() != 0) {
            derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                DerInputStream derInputStream = new DerInputStream(derValue2.toByteArray());
                this.unprotectedAttrs = new PKCSAttributes(derInputStream, this.provider);
            } else {
                this.unprotectedAttrs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof EnvelopedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((EnvelopedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            int n = Arrays.hashCode(derOutputStream.toByteArray());
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void addRecipient(Certificate certificate) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient_1");
            }
            return;
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Certificate must be of type X509Certificate.  Instead it is of type " + certificate.getClass().getName() + ".");
            }
            throw new IllegalArgumentException("Certificate must be of type X509Certificate.  Instead it is of type " + certificate.getClass().getName() + ".");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Content encryption key is null.");
            }
            throw new PKCSException("Content encryption key is null.");
        }
        RecipientInfo recipientInfo = new RecipientInfo(this.getContentEncryptionKey(), certificate, this.provider);
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            this.recipientInfos = new RecipientInfo[1];
            this.recipientInfos[0] = recipientInfo;
        } else {
            RecipientInfo[] recipientInfoArray = new RecipientInfo[this.recipientInfos.length + 1];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                recipientInfoArray[i] = this.recipientInfos[i];
            }
            recipientInfoArray[i] = recipientInfo;
            this.recipientInfos = recipientInfoArray;
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public void addRecipient(Certificate[] certificateArray) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certificateArray);
        }
        if (certificateArray == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient_1");
            }
            return;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            this.addRecipient(certificateArray[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public OriginatorInfo getOriginator() {
        if (debug != null) {
            debug.entry(16384L, className, "getOriginator");
        }
        if (this.originator == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOriginator", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOriginator", this.originator.clone());
        }
        return (OriginatorInfo)this.originator.clone();
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", this.recipientInfos.clone());
        }
        return (RecipientInfo[])this.recipientInfos.clone();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContentInfo");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedContentInfo", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedContentInfo", this.encryptedContentInfo.clone());
        }
        return (EncryptedContentInfo)this.encryptedContentInfo.clone();
    }

    public RecipientInfo getRecipientInfo(Certificate certificate) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfo");
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo_1", null);
            }
            return null;
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo_2", null);
            }
            return null;
        }
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            if (!this.recipientInfos[i].identifies(certificate)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfo", this.recipientInfos[i].clone());
            }
            return (RecipientInfo)this.recipientInfos[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfo_3", null);
        }
        return null;
    }

    public boolean hasRecipientInfo(Certificate certificate) {
        RecipientInfo recipientInfo;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasRecipientInfo", certificate);
        }
        try {
            recipientInfo = this.getRecipientInfo(certificate);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "hasRecipientInfo", exception);
                debug.exit(16384L, (Object)className, "hasRecipientInfo_1", new Boolean(false));
            }
            return false;
        }
        if (recipientInfo != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasRecipientInfo_2", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasRecipientInfo_3", new Boolean(false));
        }
        return false;
    }

    private void addUnprotectedAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addUnprotectedAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs == null ? (PKCSAttributes)pKCSAttributes.clone() : this.unprotectedAttrs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(16384L, className, "addUnprotectedAttribute");
        }
    }

    private void addUnprotectedAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addUnprotectedAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addUnprotectedAttribute_1");
            }
            return;
        }
        if (this.unprotectedAttrs == null) {
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
            this.unprotectedAttrs = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            this.unprotectedAttrs = this.unprotectedAttrs.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addUnprotectedAttribute");
        }
    }

    private void removeUnprotectedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "removeUnprotectedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, className, "removeUnprotectedAttribute_1");
            }
            return;
        }
        this.unprotectedAttrs = this.unprotectedAttrs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(16384L, className, "removeUnprotectedAttribute");
        }
    }

    public PKCSAttribute getUnprotectedAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnprotectedAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.unprotectedAttrs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public PKCSAttributes getUnprotectedAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnprotectedAttributes");
        }
        if (this.unprotectedAttrs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnprotectedAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnprotectedAttributes", this.unprotectedAttrs);
        }
        return this.unprotectedAttrs;
    }

    private void encryptContent(ContentInfo contentInfo, String string, int n) throws PKCSException, IOException {
        String string2;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, string, new Integer(n)};
            debug.entry(8192L, (Object)className, "encryptContent", objectArray);
        }
        String string3 = string2 = EncryptedContentInfo.getAlgorithm(string);
        if (string2.equalsIgnoreCase("AES")) {
            if (n != 128 && n != 192 && n != 256) {
                throw new IllegalArgumentException("Invalid key size " + n + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (n) {
                case 128: {
                    string3 = "AES128";
                    break;
                }
                case 192: {
                    string3 = "AES192";
                    break;
                }
                case 256: {
                    string3 = "AES256";
                    break;
                }
            }
        }
        try {
            objectArray = AlgorithmId.get(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "encryptContent", noSuchAlgorithmException);
                debug.text(8192L, className, "encryptContent", "Unsupported algorithm " + string2 + ".  Must be one of AES, DES, DESede, or RC2.");
            }
            throw new IllegalArgumentException("Unsupported algorithm " + string2 + ".  Must be one of AES, DES, DESede, or RC2.");
        }
        if (this.contentEncryptionAlgId != null && !this.contentEncryptionAlgId.equals((AlgorithmId)objectArray)) {
            if (debug != null) {
                debug.text(8192L, className, "encryptContent", "Input content encryption algorithm differs from existing algorithm");
            }
            throw new IllegalArgumentException("Input content encryption algorithm differs from existing algorithm");
        }
        this.content = contentInfo;
        this.contentEncryptionAlgorithm = string2;
        this.contentEncryptionAlgId = objectArray;
        this.encryptedContentInfo = new EncryptedContentInfo(contentInfo, string2, n, this.provider);
        this.setContentEncryptionKey(this.encryptedContentInfo.getEncryptionKey());
        if (debug != null) {
            debug.exit(8192L, className, "encryptContent");
        }
    }

    public ContentInfo decrypt(PrivateKey privateKey, Certificate certificate) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", certificate);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "key not specified.");
            }
            throw new IllegalArgumentException("key not specified.");
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "cert not specified.");
            }
            throw new IllegalArgumentException("cert not specified.");
        }
        int n = 0;
        boolean bl = false;
        for (n = 0; n < this.recipientInfos.length; ++n) {
            if (!this.recipientInfos[n].identifies(certificate)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "No RecipientInfo matches certificate.");
            }
            throw new IllegalArgumentException("No RecipientInfo matches certificate.");
        }
        byte[] byArray = this.recipientInfos[n].decryptKey(privateKey);
        String string = this.encryptedContentInfo.getContentEncryptionAlgorithm().getName();
        ObjectIdentifier objectIdentifier = this.encryptedContentInfo.getContentEncryptionAlgorithm().getOID();
        if (!(objectIdentifier.equals(AlgorithmId.DESCBC_oid) || objectIdentifier.equals(AlgorithmId.tripleDESCBC_oid) || objectIdentifier.equals(AlgorithmId.RC2CBC_oid) || objectIdentifier.equals(AlgorithmId.AES128CBC_oid) || objectIdentifier.equals(AlgorithmId.AES192CBC_oid) || objectIdentifier.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + string);
            }
            throw new IllegalArgumentException("Unsupported decryption algorithm: " + string);
        }
        ContentInfo contentInfo = this.encryptedContentInfo.decrypt(byArray);
        Arrays.fill(byArray, (byte)0);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", contentInfo);
        }
        return contentInfo;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.ENVELOPED_DATA_OID);
        }
        return PKCSOID.ENVELOPED_DATA_OID;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 EnvelopedData:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n\toriginator: " + this.originator;
        int n = 0;
        if (this.recipientInfos != null) {
            n = this.recipientInfos.length;
        }
        string = string + "\r\n\trecipientInfos (" + n + "):";
        if (this.recipientInfos == null) {
            string = string + "\r\n\tnull";
        } else {
            string = string + "\r\n";
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                string = string + "\trecipientInfos[" + i + "]:\r\n" + this.recipientInfos[i];
            }
        }
        string = string + "\r\n\tencryptedContent:\r\n" + this.encryptedContentInfo;
        if (this.unprotectedAttrs != null) {
            string = string + "\r\n\tunprotectedAttrs (" + this.unprotectedAttrs.size() + "):\r\n";
            string = string + this.unprotectedAttrs + "\r\n";
        } else {
            string = string + "\r\n\tunprotectedAttrs: null\r\n";
        }
        return string;
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.encryptedContentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "EnvelopedData missing encryptedContentInfo value.");
            }
            throw new IOException("EnvelopedData missing encryptedContentInfo value.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (this.originator != null) {
            this.version = BigInteger.valueOf(2L);
        } else if (this.recipientInfos != null) {
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                if (this.recipientInfos[i].getVersion().intValue() == 0) continue;
                this.version = BigInteger.valueOf(2L);
                break;
            }
        }
        if (this.unprotectedAttrs != null) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setContentEncryptionKey(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)byArray);
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
        this.contentEncryptionKey = new SmudgedBytes(byArray);
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "getContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "setContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "setContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

