/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class Data
extends Content
implements Cloneable {
    private byte[] data;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.Data";
    private volatile int cachedHashVal = 0;

    public Data() {
        if (debug != null) {
            debug.entry(16384L, className, "Data");
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Data", string);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Data", (Object)byArray);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "Data", byArray, string);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "Data", string, new Boolean(bl));
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "Data", objectArray);
            debug.exit(16384L, className, "Data");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            Data data = new Data(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", data);
            }
            return data;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Data)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        byte[] byArray = ((Data)object).getData();
        if (this.data.length != byArray.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.data[i] == byArray[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            this.cachedHashVal = 17;
            for (int i = 0; i < this.data.length; ++i) {
                this.cachedHashVal = 37 * this.cachedHashVal + this.data[i];
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.DATA_OID);
        }
        return PKCSOID.DATA_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.data == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Data not specified.");
            }
            throw new IOException("Data not specified.");
        }
        if (this.data == null || this.data.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding data");
            }
            throw new IOException("error encoding data");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOctetString(this.data);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getData().available() != 0) {
            this.data = derValue.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public synchronized void setData(byte[] byArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setData", (Object)byArray);
        }
        if (this.data != null) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Data byte array already set.");
            }
            throw new PKCSException("Data byte array already set.");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Data byte array not specified.");
            }
            throw new IllegalArgumentException("Data byte array not specified.");
        }
        this.data = (byte[])byArray.clone();
        if (debug != null) {
            debug.exit(16384L, className, "setData");
        }
    }

    public byte[] getData() {
        if (debug != null) {
            debug.entry(16384L, className, "getData");
        }
        if (this.data == null || this.data.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getData", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getData", byArray);
        }
        return byArray;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 Data:\r\n";
        string = this.data != null ? string + hexDumpEncoder.encodeBuffer(this.data) + "\r\n" : string + "null";
        return string;
    }
}

