/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.OriginatorInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.RecipientInfo;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class AuthenticatedData
extends Content
implements Cloneable {
    private static final byte TAG_OINFO = 0;
    private static final byte TAG_DIGESTALG = 1;
    private static final byte TAG_AUTHATTRS = 2;
    private static final byte TAG_UNAUTHATTRS = 3;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.AuthenticatedData";
    private BigInteger version = BigInteger.ZERO;
    private OriginatorInfo originator;
    private RecipientInfo[] recipientInfos;
    private AlgorithmId macAlgorithm;
    private AlgorithmId digestAlgorithm;
    private EncapsulatedContentInfo encapsulatedContent;
    private PKCSAttributes authAttribs;
    private byte[] mac;
    private PKCSAttributes unauthAttribs;
    private SmudgedBytes contentEncryptionKey;

    public AuthenticatedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedData", (Object)byArray);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedData", byArray, string);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originatorInfo, RecipientInfo[] recipientInfoArray, String string, String string2, EncapsulatedContentInfo encapsulatedContentInfo, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2) throws IOException, PKCSException, NoSuchAlgorithmException {
        this(secretKey, originatorInfo, recipientInfoArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{secretKey, originatorInfo, recipientInfoArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2};
            debug.entry(16384L, (Object)className, "AuthenticatedData", objectArray);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originatorInfo, RecipientInfo[] recipientInfoArray, String string, String string2, EncapsulatedContentInfo encapsulatedContentInfo, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, String string3) throws IOException, PKCSException, NoSuchAlgorithmException {
        super(string3);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{secretKey, originatorInfo, recipientInfoArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2, string3};
            debug.entry(16384L, (Object)className, "AuthenticatedData", objectArray);
        }
        this.originator = originatorInfo;
        if (recipientInfoArray == null || recipientInfoArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  recipientInfos must be specified");
            }
            throw new IOException("error:  recipientInfos must be specified");
        }
        this.recipientInfos = recipientInfoArray;
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  macAlgorithm must be specified");
            }
            throw new IOException("error:  macAlgorithm must be specified");
        }
        this.setmacAlgorithm(string);
        if (string2 != null) {
            objectArray = PKCS7.getDigestAlgorithm(string2);
            this.setdigestAlgorithm((String)objectArray);
        } else {
            this.digestAlgorithm = null;
        }
        if (encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "encapsulatedContent must be specified");
            }
            throw new IOException("encapsulatedContent must be specified");
        }
        if (secretKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "secretKey must be specified");
            }
            throw new IOException("secretKey must be specified");
        }
        this.setContentEncryptionKey(secretKey.getEncoded());
        this.authAttribs = pKCSAttributes;
        this.unauthAttribs = pKCSAttributes2;
        this.setEncapsulatedContent(encapsulatedContentInfo);
        this.mac = null;
        this.calculateMac(secretKey);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originatorInfo, Certificate[] certificateArray, String string, String string2, EncapsulatedContentInfo encapsulatedContentInfo, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2) throws IOException, PKCSException, NoSuchAlgorithmException {
        this(secretKey, originatorInfo, certificateArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{secretKey, originatorInfo, certificateArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2};
            debug.entry(16384L, (Object)className, "AuthenticatedData", objectArray);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(SecretKey secretKey, OriginatorInfo originatorInfo, Certificate[] certificateArray, String string, String string2, EncapsulatedContentInfo encapsulatedContentInfo, PKCSAttributes pKCSAttributes, PKCSAttributes pKCSAttributes2, String string3) throws IOException, PKCSException, NoSuchAlgorithmException {
        super(string3);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{secretKey, originatorInfo, certificateArray, string, string2, encapsulatedContentInfo, pKCSAttributes, pKCSAttributes2, string3};
            debug.entry(16384L, (Object)className, "AuthenticatedData", objectArray);
        }
        this.originator = originatorInfo;
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  recipientCerts must be specified");
            }
            throw new IOException("error:  recipientCerts must be specified");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  macAlgorithm must be specified");
            }
            throw new IOException("error:  macAlgorithm must be specified");
        }
        this.setmacAlgorithm(string);
        if (string2 != null) {
            objectArray = PKCS7.getDigestAlgorithm(string2);
            this.setdigestAlgorithm((String)objectArray);
        } else {
            this.digestAlgorithm = null;
        }
        if (encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  encapsulatedContent must be specified");
            }
            throw new IOException("error:  encapsulatedContent must be specified");
        }
        if (secretKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "AuthenticatedData", "error:  secretKey must be specified");
            }
            throw new IOException("error:  secretKey must be specified");
        }
        this.setContentEncryptionKey(secretKey.getEncoded());
        this.authAttribs = pKCSAttributes;
        this.unauthAttribs = pKCSAttributes2;
        this.setEncapsulatedContent(encapsulatedContentInfo);
        this.mac = null;
        this.addRecipient(certificateArray);
        this.calculateMac(secretKey);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedData", string, new Boolean(bl));
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public AuthenticatedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "AuthenticatedData", objectArray);
            debug.exit(16384L, className, "AuthenticatedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            AuthenticatedData authenticatedData = new AuthenticatedData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", authenticatedData);
            }
            return authenticatedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void addRecipient(Certificate certificate) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipient");
            }
            return;
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Certificate must be of type X509Certificate.  Instead it is of type " + certificate.getClass().getName() + ".");
            }
            throw new IllegalArgumentException("Certificate must be of type X509Certificate.  Instead it is of type " + certificate.getClass().getName() + ".");
        }
        if (this.getContentEncryptionKey() == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "Digest encryption key is null.");
            }
            throw new PKCSException("Digest encryption key is null.");
        }
        RecipientInfo recipientInfo = new RecipientInfo(this.getContentEncryptionKey(), certificate, this.provider);
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            this.recipientInfos = new RecipientInfo[1];
            this.recipientInfos[0] = recipientInfo;
        } else {
            RecipientInfo[] recipientInfoArray = new RecipientInfo[this.recipientInfos.length + 1];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                recipientInfoArray[i] = this.recipientInfos[i];
            }
            recipientInfoArray[i] = recipientInfo;
            this.recipientInfos = recipientInfoArray;
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public void addRecipient(Certificate[] certificateArray) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", certificateArray);
        }
        if (certificateArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addRecipient", "certs is null");
            }
            return;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            this.addRecipient(certificateArray[i]);
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    private void calculateMac(SecretKey secretKey) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipient", secretKey);
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "addRecipient", "MAC algorithm not specified.");
            }
            throw new IOException("MAC algorithm not specified.");
        }
        String string = this.macAlgorithm.getName();
        Mac mac = null;
        try {
            mac = Mac.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "addRecipient", noSuchAlgorithmException);
                debug.text(16384L, className, "addRecipient", "Error trying to retrieve the algorithm for " + string + ".");
            }
            throw new PKCSException(noSuchAlgorithmException, "Error trying to retrieve the algorithm for " + string + ".");
        }
        try {
            mac.init(secretKey);
            byte[] byArray = this.calculatePreMac();
            mac.update(byArray);
            this.mac = mac.doFinal();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "addRecipient", exception);
                debug.text(16384L, className, "addRecipient", "Error calculating mac: " + exception.toString());
            }
            throw new PKCSException(exception, "Error calculating mac: " + exception.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipient");
        }
    }

    public boolean verify(SecretKey secretKey) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", secretKey);
        }
        boolean bl = this.verify(secretKey, null);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(bl));
        }
        return bl;
    }

    public boolean verify(SecretKey secretKey, byte[] byArray) throws IOException, PKCSException {
        byte[] byArray2;
        if (debug != null) {
            debug.entry(16384L, className, "verify", secretKey, byArray);
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "MAC algorithm not stored with AuthenticatedData.");
            }
            throw new IOException("MAC algorithm not stored with AuthenticatedData.");
        }
        if (this.mac == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "MAC byte array value not stored with AuthenticatedData.");
            }
            throw new IOException("MAC byte array value not stored with AuthenticatedData.");
        }
        PKCSAttribute pKCSAttribute = this.getAuthAttribute(PKCSOID.MESSAGE_DIGEST_OID);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message Digest authenticated attribute not stored with AuthenticatedData.");
            }
            throw new IOException("Message Digest authenticated attribute not stored with AuthenticatedData.");
        }
        byte[] byArray3 = byArray;
        if (byArray3 == null && (byArray3 = this.getContent()) == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Byte array not specified and content not stored with AuthenticatedData.");
            }
            throw new PKCSException("Byte array not specified and content not stored with AuthenticatedData.");
        }
        MessageDigest messageDigest = (MessageDigest)pKCSAttribute.getPKCS9DerObject();
        byte[] byArray4 = messageDigest.getBytes();
        if (byArray4.length != (byArray2 = this.calculateMessageDigest(byArray3)).length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < byArray4.length; ++i) {
            if (byArray4[i] == byArray2[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        String string = this.macAlgorithm.getName();
        Mac mac = null;
        try {
            mac = Mac.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", noSuchAlgorithmException);
                debug.text(16384L, className, "verify", "Error trying to retrieve the algorithm for " + string + ".");
            }
            throw new PKCSException(noSuchAlgorithmException, "Error trying to retrieve the algorithm for " + string + ".");
        }
        byte[] byArray5 = null;
        try {
            mac.init(secretKey);
            byte[] byArray6 = this.calculatePreMac();
            mac.update(byArray6);
            byArray5 = mac.doFinal();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", exception);
                debug.text(16384L, className, "verify", "Error calculating mac: " + exception.toString());
            }
            throw new PKCSException(exception, "Error calculating mac: " + exception.toString());
        }
        if (this.mac.length != byArray5.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < this.mac.length; ++i) {
            if (this.mac[i] == byArray5[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(true));
        }
        return true;
    }

    public synchronized void removeContent() throws IOException {
        byte[] byArray = null;
        if (debug != null) {
            debug.entry(16384L, className, "removeContent");
        }
        ContentInfo contentInfo = new ContentInfo(this.encapsulatedContent.getContentType(), byArray, this.provider);
        this.encapsulatedContent = new EncapsulatedContentInfo(contentInfo, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "removeContent");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.AUTHENTICATED_DATA_OID);
        }
        return PKCSOID.AUTHENTICATED_DATA_OID;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public OriginatorInfo getOriginator() {
        if (debug != null) {
            debug.entry(16384L, className, "getOriginator");
        }
        if (this.originator == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getOriginator", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOriginator", this.originator.clone());
        }
        return (OriginatorInfo)this.originator.clone();
    }

    public RecipientInfo[] getRecipientInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientInfos");
        }
        if (this.recipientInfos == null || this.recipientInfos.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRecipientInfos", null);
            }
            return null;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.recipientInfos.length];
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            recipientInfoArray[i] = (RecipientInfo)this.recipientInfos[i].clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientInfos", recipientInfoArray);
        }
        return recipientInfoArray;
    }

    public AlgorithmId getMacAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getMacAlgorithm");
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMacAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.macAlgorithm.getOID(), this.macAlgorithm.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMacAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    private void setmacAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "setMacAlgorithm");
        }
        this.macAlgorithm = AlgorithmId.get(string);
        if (debug != null) {
            debug.exit(16384L, className, "setMacAlgorithm");
        }
    }

    private void setdigestAlgorithm(String string) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, className, "setdigestAlgorithm");
        }
        this.digestAlgorithm = AlgorithmId.get(string);
        if (debug != null) {
            debug.exit(8192L, className, "setdigestAlgorithm");
        }
    }

    public EncapsulatedContentInfo getEncapsulatedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContent");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncapsulatedContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncapsulatedContent", this.encapsulatedContent.clone());
        }
        return (EncapsulatedContentInfo)this.encapsulatedContent.clone();
    }

    public byte[] getMac() {
        if (debug != null) {
            debug.entry(16384L, className, "getMac");
        }
        if (this.mac == null || this.mac.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMac", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, byArray, 0, this.mac.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMac", byArray);
        }
        return byArray;
    }

    public PKCSAttributes getAuthAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAuthAttributes");
        }
        if (this.authAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttributes", this.authAttribs);
        }
        return this.authAttribs;
    }

    public PKCSAttributes getUnauthAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnauthAttributes");
        }
        if (this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttributes", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttributes", this.unauthAttribs);
        }
        return this.unauthAttribs;
    }

    private byte[] getContent() {
        if (debug != null) {
            debug.entry(8192L, className, "getContent");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContent", this.encapsulatedContent.getContent());
        }
        return this.encapsulatedContent.getContent();
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.checkValues();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        if (this.originator != null) {
            object = new DerOutputStream();
            this.originator.encode((OutputStream)object);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)object);
        }
        if (this.recipientInfos != null && this.recipientInfos.length > 0) {
            object = new DerOutputStream[this.recipientInfos.length];
            for (int i = 0; i < this.recipientInfos.length; ++i) {
                object[i] = new DerOutputStream();
                this.recipientInfos[i].encode((OutputStream)((Object)object[i]));
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding RecipientInfos");
            }
            throw new IOException("error encoding RecipientInfos");
        }
        derOutputStream.putOrderedSetOf((byte)49, (DerEncoder[])object);
        this.macAlgorithm.encode(derOutputStream);
        if (this.digestAlgorithm != null) {
            object = new DerOutputStream();
            this.digestAlgorithm.encode((DerOutputStream)object);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), (DerOutputStream)object);
        }
        object = new DerOutputStream();
        this.encapsulatedContent.encode((OutputStream)object);
        derOutputStream.putDerValue(new DerValue(((ByteArrayOutputStream)object).toByteArray()));
        this.encodeAuthAttributes(derOutputStream);
        if (this.mac == null || this.mac.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding mac");
            }
            throw new IOException("error encoding mac");
        }
        derOutputStream.putOctetString(this.mac);
        if (this.unauthAttribs != null && this.unauthAttribs.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.unauthAttribs.encode(derOutputStream3);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerInputStream derInputStream;
        int n;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "AuthenticatedData parsing error");
            }
            throw new IOException("AuthenticatedData parsing error");
        }
        this.version = derValue.getData().getInteger();
        if (this.version.intValue() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid AuthenticatedData version = " + this.version + " (must be 0)");
            }
            throw new IOException("Invalid AuthenticatedData version = " + this.version + " (must be 0)");
        }
        if ((byte)derValue.getData().peekByte() == -96) {
            derValue2 = derValue.getData().getDerValue();
            derValue2.resetTag((byte)48);
            this.originator = new OriginatorInfo(derValue2.toByteArray(), this.provider);
        } else {
            this.originator = null;
        }
        DerValue[] derValueArray = derValue.getData().getSet(1);
        int n2 = derValueArray.length;
        this.recipientInfos = new RecipientInfo[n2];
        for (n = 0; n < n2; ++n) {
            this.recipientInfos[n] = new RecipientInfo(derValueArray[n].toByteArray(), this.provider);
        }
        this.macAlgorithm = AlgorithmId.parse(derValue.getData().getDerValue());
        n = 0;
        DerValue derValue3 = derValue.getData().getDerValue();
        if (derValue3.isContextSpecific((byte)1) && derValue3.isConstructed()) {
            DerValue derValue4 = derValue3.getData().getDerValue();
            this.digestAlgorithm = AlgorithmId.parse(derValue4);
            n = 1;
        } else {
            this.digestAlgorithm = null;
        }
        if (n != 0) {
            derValue2 = derValue.getData().getDerValue();
            this.encapsulatedContent = new EncapsulatedContentInfo(derValue2.toByteArray(), this.provider);
        } else {
            this.encapsulatedContent = new EncapsulatedContentInfo(derValue3.toByteArray(), this.provider);
        }
        boolean bl = false;
        derValue3 = derValue.getData().getDerValue();
        if (derValue3.isContextSpecific((byte)2) && derValue3.isConstructed()) {
            derInputStream = new DerInputStream(derValue3.toByteArray());
            this.authAttribs = new PKCSAttributes(derInputStream, this.provider);
            bl = true;
        } else {
            this.authAttribs = null;
        }
        this.mac = bl ? derValue.getData().getOctetString() : derValue3.getOctetString();
        if (derValue.getData().available() != 0) {
            derValue3 = derValue.getData().getDerValue();
            if (derValue3.isContextSpecific((byte)3) && derValue3.isConstructed()) {
                derInputStream = new DerInputStream(derValue3.toByteArray());
                this.unauthAttribs = new PKCSAttributes(derInputStream, this.provider);
            } else {
                this.unauthAttribs = null;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof AuthenticatedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((AuthenticatedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "decode", exception);
                debug.exit(16384L, (Object)className, "decode_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode_5", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            int n = Arrays.hashCode(derOutputStream.toByteArray());
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void addAuthAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addAuthAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addAuthAttribute_1");
            }
            return;
        }
        this.authAttribs = this.authAttribs == null ? (PKCSAttributes)pKCSAttributes.clone() : this.authAttribs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(8192L, className, "addAuthAttribute_2");
        }
    }

    private void addAuthAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addAuthAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addAuthAttribute_1");
            }
            return;
        }
        if (this.authAttribs == null) {
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
            this.authAttribs = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            this.authAttribs = this.authAttribs.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addAuthAttribute_2");
        }
    }

    private void removeAuthAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeAuthAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.authAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeAuthAttribute_1");
            }
            return;
        }
        this.authAttribs = this.authAttribs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(8192L, className, "removeAuthAttribute_2");
        }
    }

    private void addUnauthAttribute(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnauthAttribute", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnauthAttribute_1");
            }
            return;
        }
        this.unauthAttribs = this.unauthAttribs == null ? (PKCSAttributes)pKCSAttributes.clone() : this.unauthAttribs.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(8192L, className, "addUnauthAttribute_2");
        }
    }

    private void addUnauthAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addUnauthAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addUnauthAttribute_1");
            }
            return;
        }
        if (this.unauthAttribs == null) {
            PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
            this.unauthAttribs = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            this.unauthAttribs = this.unauthAttribs.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(8192L, className, "addUnauthAttribute_2");
        }
    }

    private void removeUnauthAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "removeUnauthAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, className, "removeUnauthAttribute_1");
            }
            return;
        }
        this.unauthAttribs = this.unauthAttribs.deleteAttribute(objectIdentifier);
        if (debug != null) {
            debug.exit(8192L, className, "removeUnauthAttribute_2");
        }
    }

    public PKCSAttribute getAuthAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAuthAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.authAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.authAttribs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAuthAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttribute", pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAuthAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public PKCSAttribute getUnauthAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getUnauthAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.unauthAttribs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.unauthAttribs.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getUnauthAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    public boolean hasAuthenticatedAttribute(ObjectIdentifier objectIdentifier) {
        PKCSAttribute pKCSAttribute;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasAuthenticatedAttribute", objectIdentifier);
        }
        if ((pKCSAttribute = this.getAuthAttribute(objectIdentifier)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getUnauthAttribute", new Boolean(true));
        }
        return true;
    }

    public boolean hasUnauthenticatedAttribute(ObjectIdentifier objectIdentifier) {
        PKCSAttribute pKCSAttribute;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasUnauthenticatedAttribute", objectIdentifier);
        }
        if ((pKCSAttribute = this.getUnauthAttribute(objectIdentifier)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAuthenticatedAttribute", new Boolean(true));
        }
        return true;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 AuthenticatedData:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n\toriginator: " + this.originator;
        string = string + "\r\n\trecipientInfos: \r\n";
        for (int i = 0; i < this.recipientInfos.length; ++i) {
            string = string + "recipientInfos[" + i + "] : " + this.recipientInfos[i];
        }
        string = string + "\r\n\tmacAlgorithm: " + this.macAlgorithm;
        string = this.digestAlgorithm != null ? string + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm : string + "\r\n\tdigestAlgorithm: null";
        string = string + "\r\n\tencapsulatedContent: \r\n" + this.encapsulatedContent;
        if (this.authAttribs != null) {
            string = string + "\r\n\tauthenticatedAttributes (" + this.authAttribs.size() + "): \r\n";
            string = string + this.authAttribs + "\r\n";
        } else {
            string = string + "\tauthenticatedAttributes: null\r\n";
        }
        string = string + "\r\n\tmac:";
        string = this.mac != null ? string + "\r\n" + hexDumpEncoder.encodeBuffer(this.mac) + "\r\n" : string + "null";
        if (this.unauthAttribs != null) {
            string = string + "\r\n\tunauthenticatedAttributes (" + this.unauthAttribs.size() + "): \r\n";
            string = string + this.unauthAttribs + "\r\n";
        } else {
            string = string + "\tunauthenticatedAttributes: null\r\n";
        }
        return string;
    }

    private void encodeAuthAttributes(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeAuthAttributes", derOutputStream);
        }
        if (this.authAttribs != null && this.authAttribs.size() > 0) {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.authAttribs.encode(derOutputStream2);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeAuthAttributes");
        }
    }

    private void encodeAuthAttributesExplicit(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "encodeAuthAttributesExplicit", derOutputStream);
        }
        if (this.authAttribs != null && this.authAttribs.size() > 0) {
            derOutputStream.write(this.authAttribs.generateDerEncoding());
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeAuthAttributesExplicit");
        }
    }

    private void checkValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkValues");
        }
        if (this.recipientInfos == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing recipientInfos value.");
            }
            throw new IOException("AuthenticatedData missing recipientInfos value.");
        }
        if (this.recipientInfos != null && this.recipientInfos.length == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData must have at least one element in the recipientInfos collection.");
            }
            throw new IOException("AuthenticatedData must have at least one element in the recipientInfos collection.");
        }
        if (this.macAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing macAlgorithm value.");
            }
            throw new IOException("AuthenticatedData missing macAlgorithm value.");
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing encapsulatedContentInfo value.");
            }
            throw new IOException("AuthenticatedData missing encapsulatedContentInfo value.");
        }
        if (this.mac == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "AuthenticatedData missing mac value.");
            }
            throw new IOException("AuthenticatedData missing mac value.");
        }
        if (!this.encapsulatedContent.getContentType().equals(PKCSOID.DATA_OID) && this.authAttribs == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If encapsulatedContentInfo is not of the Data type, authenticatedAttributes must also be specified.");
            }
            throw new IOException("If encapsulatedContentInfo is not of the Data type, authenticatedAttributes must also be specified.");
        }
        if (this.digestAlgorithm != null && this.authAttribs == null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If digestAlgorithm is specified for AuthenticatedData, authenticatedAttributes must also be specified.");
            }
            throw new IOException("If digestAlgorithm is specified for AuthenticatedData, authenticatedAttributes must also be specified.");
        }
        if (this.digestAlgorithm == null && this.authAttribs != null) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If authenticatedAttributes are specified for AuthenticatedData, digestAlgorithm must also be specified.");
            }
            throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, digestAlgorithm must also be specified.");
        }
        if (this.unauthAttribs != null && this.unauthAttribs.size() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkValues", "If unauthenticatedAttributes are specified for AuthenticatedData, at least one unauthenticated attribute must be specified.");
            }
            throw new IOException("If unauthenticatedAttributes are specified for AuthenticatedData, at least one unauthenticated attribute must be specified.");
        }
        this.checkAuthAttributeValues();
        if (debug != null) {
            debug.exit(8192L, className, "checkValues");
        }
    }

    private void checkAuthAttributeValues() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "checkAuthAttributeValues");
        }
        if (this.authAttribs != null && this.authAttribs.size() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, at least one authenticated attribute must be specified.");
            }
            throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, at least one authenticated attribute must be specified.");
        }
        if (this.authAttribs != null) {
            PKCSAttribute pKCSAttribute = this.getAuthAttribute(PKCSOID.CONTENT_TYPE_OID);
            if (pKCSAttribute == null) {
                if (debug != null) {
                    debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, the collection must include the ContentType attribute.");
                }
                throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, the collection must include the ContentType attribute.");
            }
            pKCSAttribute = this.getAuthAttribute(PKCSOID.MESSAGE_DIGEST_OID);
            if (pKCSAttribute == null) {
                if (debug != null) {
                    debug.text(8192L, className, "checkAuthAttributeValues", "If authenticatedAttributes are specified for AuthenticatedData, the collection must include the MessageDigest attribute.");
                }
                throw new IOException("If authenticatedAttributes are specified for AuthenticatedData, the collection must include the MessageDigest attribute.");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkAuthAttributeValues");
        }
    }

    private byte[] calculatePreMac() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculatePreMac");
        }
        byte[] byArray = null;
        if (this.encapsulatedContent != null) {
            byArray = this.encapsulatedContent.getContent();
        }
        if (this.authAttribs == null && byArray == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculatePreMac", "Cannot calculate the Mac without authenticated attributes  or encapsulated contents.");
            }
            throw new IOException("Cannot calculate the Mac without authenticated attributes  or encapsulated contents.");
        }
        if (this.authAttribs == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "calculatePreMac", byArray);
            }
            return byArray;
        }
        this.checkAuthAttributeValues();
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeAuthAttributesExplicit(derOutputStream);
        byte[] byArray2 = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculatePreMac", byArray2);
        }
        return byArray2;
    }

    private void setEncapsulatedContent(EncapsulatedContentInfo encapsulatedContentInfo) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncapsulatedContent", encapsulatedContentInfo);
        }
        this.encapsulatedContent = encapsulatedContentInfo;
        this.setAuthenticatedAttributes();
        if (debug != null) {
            debug.exit(8192L, className, "setEncapsulatedContent");
        }
    }

    private void setAuthenticatedAttributes() throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(8192L, className, "setAuthenticatedAttributes");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(8192L, className, "setAuthenticatedAttributes_1");
            }
            return;
        }
        if (this.encapsulatedContent == null) {
            if (debug != null) {
                debug.text(8192L, className, "setAuthenticatedAttributes", "encapsulatedContent was not specified.");
            }
            throw new IllegalArgumentException("encapsulatedContent was not specified.");
        }
        ContentType contentType = new ContentType(this.encapsulatedContent.getContentType(), this.provider);
        byte[] byArray = this.calculateMessageDigest(this.encapsulatedContent);
        MessageDigest messageDigest = new MessageDigest(this.provider);
        messageDigest.setData(byArray);
        this.addAuthAttribute(contentType.getPKCSAttribute());
        this.addAuthAttribute(messageDigest.getPKCSAttribute());
        if (debug != null) {
            debug.exit(8192L, className, "setAuthenticatedAttributes");
        }
    }

    private byte[] calculateMessageDigest(EncapsulatedContentInfo encapsulatedContentInfo) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", encapsulatedContentInfo);
        }
        if (encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not set.");
            }
            throw new IllegalArgumentException("Digest algorithm was not set.");
        }
        byte[] byArray = encapsulatedContentInfo.getContent();
        byte[] byArray2 = this.calculateMessageDigest(byArray);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", byArray2);
        }
        return byArray2;
    }

    private byte[] calculateMessageDigest(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "calculateMessageDigest", (Object)byArray);
        }
        String string = this.digestAlgorithm.getName();
        java.security.MessageDigest messageDigest = null;
        try {
            messageDigest = this.provider != null ? java.security.MessageDigest.getInstance(string, this.provider) : java.security.MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", noSuchAlgorithmException.toString());
            }
            throw new IOException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "provider " + this.provider + " not found:" + noSuchProviderException.toString());
            }
            throw new IOException("provider " + this.provider + " not found:" + noSuchProviderException.toString());
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "calculateMessageDigest", byArray);
        }
        return byArray2;
    }

    private void setContentEncryptionKey(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentEncryptionKey", (Object)byArray);
        }
        this.contentEncryptionKey = new SmudgedBytes(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setContentEncryptionKey");
        }
    }

    private byte[] getContentEncryptionKey() {
        if (debug != null) {
            debug.entry(8192L, className, "getContentEncryptionKey");
        }
        if (this.contentEncryptionKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getContentEncryptionKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getContentEncryptionKey", this.contentEncryptionKey.getClearText());
        }
        return this.contentEncryptionKey.getClearText();
    }

    protected void finalize() {
        this.contentEncryptionKey = null;
    }
}

