/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class SecretBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private byte[] value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SecretBag";
    private volatile int cachedHashVal = 0;

    public SecretBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SecretBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(ObjectIdentifier objectIdentifier, byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", objectIdentifier, byArray);
            debug.exit(16384L, className, "SecretBag");
        }
        this.oid = objectIdentifier;
        this.value = byArray;
    }

    public SecretBag(ObjectIdentifier objectIdentifier, byte[] byArray, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, byArray, string};
            debug.entry(16384L, (Object)className, "SecretBag", objectArray);
            debug.exit(16384L, className, "SecretBag");
        }
        this.oid = objectIdentifier;
        this.value = byArray;
    }

    public SecretBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SecretBag", string, new Boolean(bl));
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public SecretBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SecretBag", objectArray);
            debug.exit(16384L, className, "SecretBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(this.value);
        DerValue derValue = new DerValue(this.value);
        if (derValue.isConstructed()) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        } else {
            derOutputStream.write(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", objectIdentifier);
        }
        return objectIdentifier;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
            debug.exit(16384L, (Object)className, "getEncodedValue", (byte[])this.value.clone());
        }
        return (byte[])this.value.clone();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "SecretBag");
        }
        return "SecretBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof SecretBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SecretBag)object));
            }
            return this.equals((SecretBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SecretBag secretBag = new SecretBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", secretBag);
            }
            return secretBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "SecretBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\nvalue:\r\n" + hexDumpEncoder.encodeBuffer(this.value);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SecretBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("SecretBag parsing error, not a SEQUENCE.");
        }
        this.oid = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            DerValue derValue3 = derValue2.getData().getDerValue();
            this.value = derValue3.toByteArray();
        } else {
            this.value = derValue2.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SecretBag secretBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", secretBag);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            secretBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

