/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

public final class SafeContents
extends PKCSDerObject
implements Cloneable {
    private SafeBag[] bags;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeContents";
    private volatile int cachedHashVal = 0;

    public SafeContents(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContents", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(SafeBag[] safeBagArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContents", safeBagArray);
            debug.exit(16384L, className, "SafeContents");
        }
        this.bags = safeBagArray;
    }

    public SafeContents(SafeBag[] safeBagArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", safeBagArray, string);
            debug.exit(16384L, className, "SafeContents");
        }
        this.bags = safeBagArray;
    }

    public SafeContents(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", string, new Boolean(bl));
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SafeContents", objectArray);
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.bags != null && this.bags.length != 0) {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].encode(derOutputStream);
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SafeContents addBags(SafeBag[] safeBagArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addBags", safeBagArray);
        }
        SafeContents safeContents = (SafeContents)this.clone();
        if (safeBagArray == null || safeBagArray.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addBags_1", safeContents);
            }
            return safeContents;
        }
        if (safeContents.bags == null) {
            safeContents.bags = safeBagArray;
        } else {
            int n;
            int n2 = safeContents.bags.length + safeBagArray.length;
            SafeBag[] safeBagArray2 = new SafeBag[n2];
            for (n = 0; n < safeContents.bags.length; ++n) {
                safeBagArray2[n] = safeContents.bags[n];
            }
            int n3 = n;
            int n4 = 0;
            while (n3 < n2) {
                safeBagArray2[n3] = safeBagArray[n4];
                ++n3;
                ++n4;
            }
            safeContents.bags = safeBagArray2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addBags_2", safeContents);
        }
        return safeContents;
    }

    public SafeBag[] getSafeBags() {
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBags");
            debug.exit(16384L, (Object)className, "getSafeBags", (SafeBag[])this.bags.clone());
        }
        return (SafeBag[])this.bags.clone();
    }

    public ContentInfo protect(int n) throws IOException, PKCSException {
        ContentInfo contentInfo = null;
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "protect", new Integer(n));
        }
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        switch (n) {
            case 1: {
                contentInfo = new ContentInfo(PKCSOID.DATA_OID, byArray, this.provider);
                break;
            }
            case 2: {
                ContentInfo contentInfo2 = new ContentInfo(PKCSOID.DATA_OID, byArray, this.provider);
                EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(contentInfo2, "DES", 56, this.provider);
                EncryptedData encryptedData = new EncryptedData(encryptedContentInfo, null, this.provider);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                encryptedData.encode(derOutputStream2);
                contentInfo = new ContentInfo(PKCSOID.ENCRYPTED_DATA_OID, derOutputStream2.toByteArray(), this.provider);
                break;
            }
            case 3: {
                if (debug != null) {
                    debug.text(16384L, className, "protect", "Public-key encryption is not supported.");
                }
                throw new IllegalArgumentException("Public-key encryption is not supported.");
            }
            default: {
                if (debug != null) {
                    debug.text(16384L, className, "protect", "Invalid data protection mode.");
                }
                throw new IllegalArgumentException("Invalid data protection mode.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protect", contentInfo);
        }
        return contentInfo;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SafeContents safeContents = new SafeContents(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", safeContents);
            }
            return safeContents;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof SafeContents) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeContents)object));
            }
            return this.equals((SafeContents)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String string = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + "SafeContents:\r\n";
        if (this.bags == null || this.bags.length == 0) {
            string = string + "No safe bags";
        } else {
            for (int i = 0; i < this.bags.length; ++i) {
                string = string + "SafeBag[" + i + "]\r\n";
                string = string + this.bags[i].toString();
                string = string + "\r\n";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        Vector<SafeBag> vector = new Vector<SafeBag>();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeContents parsing error, not a SEQUENCE OF");
            }
            throw new IOException("SafeContents parsing error, not a SEQUENCE OF");
        }
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            SafeBag safeBag = new SafeBag(derValue2.toByteArray(), this.provider);
            vector.add(safeBag);
        }
        if (vector.size() > 0) {
            this.bags = new SafeBag[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.bags[i] = (SafeBag)vector.elementAt(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeContents safeContents) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", safeContents);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            safeContents.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

