/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.DigestInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public final class MacData
extends PKCSDerObject
implements Cloneable {
    private DigestInfo mac;
    private byte[] salt;
    private BigInteger iCount = BigInteger.ONE;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.MacData";
    private volatile int cachedHashVal = 0;

    public MacData(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MacData", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "MacData", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n) {
        if (debug != null) {
            Object[] objectArray = new Object[]{digestInfo, byArray, new Integer(n)};
            debug.entry(16384L, (Object)className, "MacData", objectArray);
        }
        this.mac = digestInfo;
        this.salt = byArray;
        this.iCount = BigInteger.valueOf(n);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{digestInfo, byArray, new Integer(n), string};
            debug.entry(16384L, (Object)className, "MacData", objectArray);
        }
        this.mac = digestInfo;
        this.salt = byArray;
        this.iCount = BigInteger.valueOf(n);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "MacData", objectArray);
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "MacData", objectArray);
            debug.exit(16384L, className, "MacData");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.mac.encode(derOutputStream);
        derOutputStream.putOctetString(this.salt);
        derOutputStream.putInteger(this.iCount);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof MacData) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((MacData)object));
            }
            return this.equals((MacData)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            MacData macData = new MacData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", macData);
            }
            return macData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        String string = "";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + "MAC Data:\r\n";
        string = string + "MAC Digest info:\r\n";
        string = string + this.mac.toString();
        string = string + "\r\n";
        string = string + "MAC salt:";
        string = string + "\r\n";
        string = string + hexDumpEncoder.encodeBuffer(this.salt);
        string = string + "\r\n";
        string = string + "MAC iteration count: " + this.iCount.intValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public DigestInfo getMac() {
        if (debug != null) {
            debug.entry(16384L, className, "getMac");
            debug.exit(16384L, (Object)className, "getMac", (DigestInfo)this.mac.clone());
        }
        return (DigestInfo)this.mac.clone();
    }

    public byte[] getSalt() {
        if (debug != null) {
            debug.entry(16384L, className, "getSalt");
            debug.exit(16384L, (Object)className, "getSalt", (byte[])this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public int getIterations() {
        if (debug != null) {
            debug.entry(16384L, className, "getIterations");
            debug.exit(16384L, (Object)className, "getIterations", this.iCount.intValue());
        }
        return this.iCount.intValue();
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "MacData parsing error, not a SEQUENCE");
            }
            throw new IOException("MacData parsing error, not a SEQUENCE");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.mac = new DigestInfo(derValue2.toByteArray(), this.provider);
        this.salt = derValue.getData().getOctetString();
        if (derValue.getData().available() != 0) {
            this.iCount = derValue.getData().getInteger();
        }
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "MacData parsing error - data overrun, bytes = " + derValue.getData().available());
            }
            throw new IOException("MacData parsing error - data overrun, bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(MacData macData) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", macData);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            macData.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

