/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

public final class AuthenticatedSafe
extends PKCSDerObject
implements Cloneable {
    private ContentInfo[] cinfos;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.AuthenticatedSafe";
    private volatile int cachedHashVal = 0;

    public AuthenticatedSafe(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(ContentInfo[] contentInfoArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", contentInfoArray);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
        this.cinfos = contentInfoArray;
    }

    public AuthenticatedSafe(ContentInfo[] contentInfoArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", contentInfoArray, string);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
        this.cinfos = contentInfoArray;
    }

    public AuthenticatedSafe(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "AuthenticatedSafe", string, new Boolean(bl));
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public AuthenticatedSafe(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "AuthenticatedSafe", objectArray);
            debug.exit(16384L, className, "AuthenticatedSafe");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.cinfos != null && this.cinfos.length != 0) {
            for (int i = 0; i < this.cinfos.length; ++i) {
                this.cinfos[i].encode(derOutputStream);
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public AuthenticatedSafe addContentInfo(ContentInfo[] contentInfoArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addContentInfo", contentInfoArray);
        }
        AuthenticatedSafe authenticatedSafe = (AuthenticatedSafe)this.clone();
        if (contentInfoArray == null || contentInfoArray.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addContentInfo_1", authenticatedSafe);
            }
            return authenticatedSafe;
        }
        if (authenticatedSafe.cinfos == null) {
            authenticatedSafe.cinfos = contentInfoArray;
        } else {
            int n;
            int n2 = authenticatedSafe.cinfos.length + contentInfoArray.length;
            ContentInfo[] contentInfoArray2 = new ContentInfo[n2];
            for (n = 0; n < authenticatedSafe.cinfos.length; ++n) {
                contentInfoArray2[n] = authenticatedSafe.cinfos[n];
            }
            int n3 = n;
            int n4 = 0;
            while (n3 < n2) {
                contentInfoArray2[n3] = contentInfoArray[n4];
                ++n3;
                ++n4;
            }
            authenticatedSafe.cinfos = contentInfoArray2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addContentInfo_2", authenticatedSafe);
        }
        return authenticatedSafe;
    }

    public ContentInfo[] getContentInfos() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfos");
            debug.exit(16384L, (Object)className, "getContentInfos", (ContentInfo[])this.cinfos.clone());
        }
        return (ContentInfo[])this.cinfos.clone();
    }

    public ContentInfo toContentInfo() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "toContentInfo");
        }
        this.encode(derOutputStream);
        ContentInfo contentInfo = new ContentInfo(PKCSOID.DATA_OID, derOutputStream.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toContentInfo", contentInfo);
        }
        return contentInfo;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", authenticatedSafe);
            }
            return authenticatedSafe;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof AuthenticatedSafe) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((AuthenticatedSafe)object));
            }
            return this.equals((AuthenticatedSafe)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String string = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + "AuthenticatedSafe:\r\n";
        if (this.cinfos == null || this.cinfos.length == 0) {
            string = string + "No contents";
        } else {
            for (int i = 0; i < this.cinfos.length; ++i) {
                string = string + "ContentInfo[" + i + "]\r\n";
                string = string + this.cinfos[i].toString();
                string = string + "\r\n";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        Vector<ContentInfo> vector = new Vector<ContentInfo>();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "AuthenticatedSafe parsing error, not a SEQUENCE OF");
            }
            throw new IOException("AuthenticatedSafe parsing error, not a SEQUENCE OF");
        }
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            ContentInfo contentInfo = new ContentInfo(derValue2.toByteArray(), this.provider);
            vector.add(contentInfo);
        }
        if (vector.size() > 0) {
            this.cinfos = new ContentInfo[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.cinfos[i] = (ContentInfo)vector.elementAt(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(AuthenticatedSafe authenticatedSafe) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", authenticatedSafe);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            authenticatedSafe.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", true);
        }
        return true;
    }
}

