/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Info;
import com.ibm.pkcs11.PKCS11Slot;

public abstract class PKCS11 {
    protected PKCS11() {
    }

    public void libInitialize() throws PKCS11Exception {
    }

    public void libFinalize() throws PKCS11Exception {
    }

    public abstract PKCS11Info getInfo() throws PKCS11Exception;

    public abstract PKCS11Slot[] getSlotList(boolean var1) throws PKCS11Exception;

    public PKCS11Slot getFirstTokenSlot() throws PKCS11Exception {
        PKCS11Slot[] pKCS11SlotArray = this.getSlotList(true);
        return pKCS11SlotArray.length > 0 ? pKCS11SlotArray[0] : null;
    }

    public abstract PKCS11Slot waitForSlotEvent(boolean var1) throws PKCS11Exception;

    public String toString() {
        try {
            return this.getInfo().toString();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new RuntimeException(pKCS11Exception.toString());
        }
    }

    protected void finalize() {
        try {
            this.libFinalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String flagsToString(int n, int[] nArray, String[] stringArray, String string) {
        if (n == 0) {
            return "0x0";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        String string2 = "";
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) == 0) continue;
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[i]);
            n &= ~nArray[i];
            string2 = string;
        }
        if (n != 0) {
            stringBuilder.append(string2);
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toString(n, 16));
        }
        return stringBuilder.toString();
    }

    static String versionString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        stringBuilder.append(n2);
        stringBuilder.append(".");
        stringBuilder.append(n3 / 10);
        if (n3 % 10 != 0) {
            stringBuilder.append(n3 % 10);
        }
        return stringBuilder.toString();
    }
}

