/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public abstract class SOAPFactory {
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPFactory";
    private static final String DEFAULT_SF = "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory";
    private static Class factoryClass = null;

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract Detail createDetail() throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public static synchronized SOAPFactory newInstance() throws SOAPException {
        try {
            Object var0 = null;
            if (factoryClass == null) {
                String string = SF_PROPERTY;
                String string2 = DEFAULT_SF;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = System.getProperty(string);
                if (string3 == null) {
                    String string4 = "META-INF/services/" + string;
                    InputStream inputStream = null;
                    inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string4) : classLoader.getResourceAsStream(string4);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        string3 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                }
                if (string3 == null) {
                    string3 = string2;
                }
                if (string3 == null) {
                    throw new SOAPException("Provider for " + string + " cannot be found", null);
                }
                factoryClass = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            }
            var0 = factoryClass.newInstance();
            return var0;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.SOAPFactory.newInstance", (String)"251");
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }
}

