/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XQueryTree {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private boolean __executed = false;
    private boolean __disposed = false;
    long _w;
    long root_ptr = unsafe.allocateMemory(Native.getLongSize());
    long parent_ptr = unsafe.allocateMemory(Native.getLongSize());
    long children_ptr = unsafe.allocateMemory(Native.getLongSize());
    long nchildren_ptr = unsafe.allocateMemory(Native.getIntSize());

    public XQueryTree(long l) {
        this.set_w(l);
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XToolkit.XErrorHandler xErrorHandler) {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        try {
            XToolkit.awtLock();
            if (this.__executed) {
                throw new IllegalStateException("Already executed");
            }
            this.__executed = true;
            if (xErrorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(xErrorHandler);
            }
            Native.putLong(this.children_ptr, 0L);
            int n = XlibWrapper.XQueryTree(XToolkit.getDisplay(), this.get_w(), this.root_ptr, this.parent_ptr, this.children_ptr, this.nchildren_ptr);
            if (xErrorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n2 = n;
            return n2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.__executed;
    }

    public boolean isDisposed() {
        return this.__disposed;
    }

    public void finalize() {
        if (XlibWrapper.isBuildInternal && !this.__disposed) {
            System.err.println("WARNING: sun.awt.X11.XQueryTree not disposed till finalization!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            if (this.__disposed) {
                return;
            }
            unsafe.freeMemory(this.root_ptr);
            unsafe.freeMemory(this.parent_ptr);
            if (this.__executed && this.get_children() != 0L) {
                XlibWrapper.XFree(this.get_children());
            }
            unsafe.freeMemory(this.children_ptr);
            unsafe.freeMemory(this.nchildren_ptr);
            this.__disposed = true;
        }
    }

    public long get_w() {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._w;
    }

    public void set_w(long l) {
        this._w = l;
    }

    public long get_root() {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.root_ptr);
    }

    public void set_root(long l) {
        Native.putLong(this.root_ptr, l);
    }

    public long get_parent() {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.parent_ptr);
    }

    public void set_parent(long l) {
        Native.putLong(this.parent_ptr, l);
    }

    public long get_children() {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.children_ptr);
    }

    public void set_children(long l) {
        Native.putLong(this.children_ptr, l);
    }

    public int get_nchildren() {
        if (this.__disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.nchildren_ptr);
    }

    public void set_nchildren(int n) {
        Native.putInt(this.nchildren_ptr, n);
    }
}

