/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuPeer;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuComponentPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;

public class XMenuPeer
extends XMenuItemPeer
implements MenuPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.menu.XMenuPeer");
    private static final int shortCutSpacing = 15;
    private int xIndent = 20;
    private int shortcutOffset = 0;
    private XMenuPeer menu;
    private XMenuComponentPeer parentMenu;
    private int selected;
    private boolean created = false;
    private Point pt;
    private int titleOffset = 0;
    private boolean titleShowing = false;
    private boolean posted = false;
    private int popup_i = -1;
    private Timer popupTimer = null;
    private Vector items = new Vector();
    private static Field f_items = XToolkit.getField(Menu.class, "items");
    private boolean viewable = false;
    static final int checkBorder = 6;

    XMenuItemPeer[] copyItems() {
        return this.getItems().toArray(new XMenuItemPeer[0]);
    }

    public XMenuPeer(Menu menu) {
        super(menu);
        this.pt = new Point(0, 0);
    }

    public XMenuPeer(Menu menu, boolean bl) {
        this(menu);
        this.titleShowing = bl;
    }

    public void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        MenuContainer menuContainer = this.getParent();
        if (menuContainer instanceof MenuComponent) {
            this.parentMenu = (XMenuComponentPeer)this.getPeer((MenuComponent)((Object)menuContainer));
        }
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        MenuContainer menuContainer;
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.add((Object)"overrideRedirect", Boolean.TRUE);
        if (this.parentMenu == null && (menuContainer = this.getParent()) instanceof MenuComponent) {
            this.parentMenu = (XMenuComponentPeer)this.getPeer((MenuComponent)((Object)menuContainer));
        }
    }

    void create() {
        this.setSelected(-1);
        if (!this.isCreated()) {
            XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
            xCreateWindowParams.remove("delayed");
            this.init(xCreateWindowParams);
            this.initItems();
        }
        this.setCreated(true);
    }

    boolean isTitleShowing() {
        String string = this.getLabel();
        if (string == null || string.equals("")) {
            this.setTitleShowing(false);
        }
        return this.titleShowing;
    }

    void setTitleShowing(boolean bl) {
        this.titleShowing = bl;
    }

    int getWidestItemWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n = xMenuItemPeerArray.length;
        int n2 = this.isTitleShowing() ? fontMetrics.stringWidth(this.getLabel()) : 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, xMenuItemPeerArray[i].getWidth(graphics));
        }
        graphics.dispose();
        return n2;
    }

    int getWidestShortcutWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n = xMenuItemPeerArray.length;
        int n2 = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, xMenuItemPeerArray[i].getShortcutWidth(graphics));
        }
        graphics.dispose();
        return n2;
    }

    Point getTopBot(int n) {
        int n2 = 0;
        int n3 = 2 + this.getTitleOffset();
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return new Point(0, 0);
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n4 = xMenuItemPeerArray.length;
        if (n >= n4) {
            n = n4 - 1;
        }
        for (int i = 0; i < n + 1; ++i) {
            XMenuItemPeer xMenuItemPeer = xMenuItemPeerArray[i];
            String string = xMenuItemPeer.getLabel();
            if (string.equals("-")) {
                n2 = n3 + 1;
                n3 = n2 + 2;
                continue;
            }
            n2 = n3 + 1;
            n3 = n2 + xMenuItemPeer.getHeight(graphics) - 1;
        }
        graphics.dispose();
        return new Point(n2, n3);
    }

    int getTop(int n) {
        return this.getTopBot((int)n).x;
    }

    int getBot(int n) {
        return this.getTopBot((int)n).y;
    }

    MenuItem[] copyTargetItems() {
        return this.getTargetItems().toArray(new MenuItem[0]);
    }

    void initItems() {
        Vector<XMenuItemPeer> vector = new Vector<XMenuItemPeer>();
        for (MenuItem menuItem : this.copyTargetItems()) {
            XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getPeer(menuItem);
            if (xMenuItemPeer == null) continue;
            xMenuItemPeer.setMenuPeer(this);
            vector.add(xMenuItemPeer);
        }
        this.setItems(vector);
    }

    int computeXIndent() {
        int n = 0;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n2 = xMenuItemPeerArray.length;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            XMenuItemPeer xMenuItemPeer = xMenuItemPeerArray[i];
            if (!(xMenuItemPeer instanceof XCheckboxMenuItemPeer)) continue;
            int n4 = ((XCheckboxMenuItemPeer)xMenuItemPeer).getHeight(graphics);
            n3 = Math.max(n3, n4);
        }
        n = n3 != 0 ? n3 + 12 + 4 : 4;
        graphics.dispose();
        return n;
    }

    void updateMenu(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setTitleOffset(this.isTitleShowing() ? fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2 : 0);
        int n3 = this.getBot(this.getItems().size() - 1) + 2;
        this.setXIndent(this.computeXIndent());
        int n4 = this.getWidestShortcutWidth();
        int n5 = this.getWidestItemWidth();
        this.setShortcutOffset(n5 + 15);
        int n6 = n5 + this.getXIndent() * 2 + (n4 == 0 ? 0 : 15 + n4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n7 = dimension.width;
        int n8 = dimension.height;
        if (n + n6 >= n7) {
            n = n7 - n6;
        }
        if (n2 + n3 >= n8) {
            n2 = n8 - n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.reshape(n, n2, n6, n3);
    }

    void popup(int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Popping up " + this + " at " + n + ", " + n2);
        }
        if (this.isDisposed()) {
            return;
        }
        this.create();
        this.updateMenu(n, n2);
        this.setVisible(true);
        this.toFront();
        this.repaint();
    }

    void popdown(MouseEvent mouseEvent, boolean bl) {
        XMenuItemPeer xMenuItemPeer;
        XMenuPeer xMenuPeer = this.getMenu();
        int n = this.getSelected();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Popping down " + this + " because " + mouseEvent + (bl ? " with action" : ""));
        }
        this.setVisible(false);
        this.setPosted(false);
        if (xMenuPeer != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Popping down child menu " + xMenuPeer);
            }
            xMenuPeer.popdown(mouseEvent, bl);
            this.setMenu(null);
        } else if (bl && n >= 0 && (xMenuItemPeer = this.getItem(n)) != null && !(xMenuItemPeer instanceof XMenuPeer)) {
            try {
                if (xMenuItemPeer instanceof XCheckboxMenuItemPeer) {
                    XCheckboxMenuItemPeer xCheckboxMenuItemPeer = (XCheckboxMenuItemPeer)xMenuItemPeer;
                    xCheckboxMenuItemPeer.action(mouseEvent.getWhen(), mouseEvent.getModifiers(), !xCheckboxMenuItemPeer.getState());
                } else {
                    xMenuItemPeer.action(mouseEvent.getWhen(), mouseEvent.getModifiers());
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.setSelected(-1);
    }

    void paint(Graphics graphics) {
        int n;
        String string = this.getLabel();
        int n2 = this.getTitleOffset();
        this.draw3DRect(graphics, 0, 0, this.width - 1, this.height - 1, true);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.isTitleShowing()) {
            int n3 = fontMetrics.stringWidth(string);
            n = this.width - n3 >> 1;
            graphics.setColor(this.getBackground());
            graphics.fillRect(1, 2, this.width - 4, n2);
            this.draw3DRect(graphics, 1, n2, this.width - 3, 1, false);
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n, 2 + fontMetrics.getMaxAscent());
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        n = xMenuItemPeerArray.length;
        for (int i = 0; i < n; ++i) {
            xMenuItemPeerArray[i].paint(graphics, this.getTop(i), this.getBot(i), this.width, this.getShortcutOffset(), i == this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintMenuItem(XMenuItemPeer xMenuItemPeer) {
        if (xMenuItemPeer == null) {
            return;
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n = -1;
        for (int i = 0; i < xMenuItemPeerArray.length; ++i) {
            if (!xMenuItemPeerArray[i].equals(xMenuItemPeer)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            Graphics graphics = this.getGraphics();
            try {
                xMenuItemPeerArray[n].paint(graphics, this.getTop(n), this.getBot(n), this.width, this.getShortcutOffset(), n == this.selected);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void select(int n) {
        int n2;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Selecting item " + n);
        }
        if (n == (n2 = this.getSelected())) {
            return;
        }
        Graphics graphics = this.getGraphics();
        try {
            XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
            int n3 = this.getShortcutOffset();
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (n2 >= 0) {
                int n4 = n2;
                this.setSelected(-1);
                if (n4 < xMenuItemPeerArray.length) {
                    xMenuItemPeerArray[n4].paint(graphics, this.getTop(n4), this.getBot(n4), this.width, n3, false);
                }
            }
            if (n < 0) {
                return;
            }
            XMenuItemPeer xMenuItemPeer = this.getItem(n);
            if (xMenuItemPeer != null && xMenuItemPeer.isEnabled() && xMenuItemPeer.getLabel() != null && !xMenuItemPeer.getLabel().equals("-")) {
                if (n < xMenuItemPeerArray.length) {
                    xMenuItemPeerArray[n].paint(graphics, this.getTop(n), this.getBot(n), this.width, n3, true);
                }
                this.setSelected(n);
            } else {
                this.setSelected(-1);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    boolean contains(int n, int n2, int n3) {
        return n >= n3 && n < this.getWidth() - n3 && n2 >= n3 && n2 < this.getHeight() - n3;
    }

    boolean cascadeContains(XMenuWindow xMenuWindow, Point point, int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        point2 = this.toLocal(xMenuWindow.toGlobal(point2));
        if (xMenuPeer == null) {
            return this.contains(point2.x, point2.y, n);
        }
        return this.contains(point2.x, point2.y, n) || xMenuPeer.cascadeContains(this, point2, n);
    }

    boolean cascadeContains(Point point, int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null) {
            return this.contains(point.x, point.y, n);
        }
        Point point2 = new Point(point.x, point.y);
        point2 = xMenuPeer.toLocal(this.toGlobal(point2));
        return this.contains(point.x, point.y, n) || xMenuPeer.cascadeContains(point2, n);
    }

    boolean lastMenuContains(XMenuWindow xMenuWindow, Point point, int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        point2 = this.toLocal(xMenuWindow.toGlobal(point2));
        if (xMenuPeer == null) {
            return this.contains(point2.x, point2.y, n);
        }
        return xMenuPeer.lastMenuContains(this, point2, n);
    }

    public boolean hasMenu() {
        return this.menu != null;
    }

    XMenuPeer doPosting(XMenuWindow xMenuWindow, Point point, int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        if (this.contains(point2.x, point2.y, n)) {
            XMenuPeer xMenuPeer2 = xMenuPeer;
            if (xMenuPeer != null) {
                if (xMenuPeer.isPosted()) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(null, false);
                    this.setMenu(null);
                } else {
                    xMenuPeer.setPosted(true);
                }
            }
            return xMenuPeer2;
        }
        if (xMenuPeer == null) {
            return null;
        }
        point2 = xMenuPeer.toLocal(xMenuWindow.toGlobal(point2));
        return xMenuPeer.doPosting(this, point2, n);
    }

    int getItemIndex(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (n < this.getTop(i) || n > this.getBot(i)) continue;
            return i;
        }
        return -1;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        if (this.isDisposed()) {
            return;
        }
        XMenuPeer xMenuPeer = this.getMenu();
        final int n = this.getWidth();
        int n2 = this.getHeight();
        switch (mouseEvent.getID()) {
            case 501: 
            case 506: {
                XMenuItemPeer xMenuItemPeer;
                int n3;
                int n4 = this.getItemIndex(mouseEvent);
                if (xMenuPeer != null) {
                    this.pt = mouseEvent.getPoint();
                    n3 = this.pt.x;
                    int n5 = this.pt.y;
                    this.pt = xMenuPeer.toLocal(this.toGlobal(this.pt));
                    if (this.contains(n3, n5, 5) && n4 != this.popup_i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Popping down child menu " + this.menu);
                        }
                        xMenuPeer.popdown(mouseEvent, false);
                        this.setMenu(null);
                    } else {
                        MouseEvent mouseEvent2 = this.makeMouseEvent(mouseEvent, this.pt.x, this.pt.y);
                        xMenuPeer.handleJavaMouseEvent(mouseEvent2);
                        return;
                    }
                }
                if (n4 == -1 || mouseEvent.getX() < 0 || mouseEvent.getX() > n || mouseEvent.getY() < 0 || mouseEvent.getY() > n2) {
                    this.select(-1);
                    return;
                }
                this.select(n4);
                n3 = this.getSelected();
                if (n3 < 0 || (xMenuItemPeer = this.getItem(n3)) == null || !(xMenuItemPeer instanceof XMenuPeer) || !xMenuItemPeer.isEnabled() || xMenuPeer != null) break;
                if (mouseEvent.getID() == 506 && mouseEvent.getX() > n - 20 || mouseEvent.getID() == 501) {
                    this.setMenu((XMenuPeer)xMenuItemPeer);
                    this.pt.x = n - 2;
                    this.pt.y = this.getTop(n3);
                    this.pt = this.toGlobal(this.pt);
                    this.popup_i = n4;
                    this.getMenu().popup(this.pt.x, this.pt.y);
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine("Popping up child menu " + this.getMenu());
                    break;
                }
                if (mouseEvent.getID() != 506 || n3 < 0 || this.popupTimer != null) break;
                AbstractAction abstractAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        XMenuItemPeer xMenuItemPeer;
                        XMenuPeer.this.popupTimer.stop();
                        XMenuPeer.this.popupTimer = null;
                        if (n3 == XMenuPeer.this.getSelected() && (xMenuItemPeer = XMenuPeer.this.getItem(n3)) != null && xMenuItemPeer instanceof XMenuPeer && xMenuItemPeer.isEnabled() && XMenuPeer.this.getMenu() == null) {
                            XMenuPeer.this.setMenu((XMenuPeer)xMenuItemPeer);
                            ((XMenuPeer)XMenuPeer.this).pt.x = n - 2;
                            ((XMenuPeer)XMenuPeer.this).pt.y = XMenuPeer.this.getTop(n3);
                            XMenuPeer.this.pt = XMenuPeer.this.toGlobal(XMenuPeer.this.pt);
                            XMenuPeer.this.popup_i = n3;
                            XMenuPeer.this.getMenu().popup(((XMenuPeer)XMenuPeer.this).pt.x, ((XMenuPeer)XMenuPeer.this).pt.y);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Popping up(from drag) child menu " + XMenuPeer.this.getMenu());
                            }
                        }
                    }
                };
                this.popupTimer = new Timer(200, abstractAction);
                this.popupTimer.setRepeats(false);
                this.popupTimer.start();
            }
        }
    }

    public void addSeparator() {
    }

    public void addItem(MenuItem menuItem) {
        XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getPeer(menuItem);
        xMenuItemPeer.setMenuPeer(this);
        this.getItems().add(xMenuItemPeer);
        this.updateMenuWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delItem(int n) {
        Vector vector = this.getItems();
        synchronized (vector) {
            if (n < this.getItems().size()) {
                XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getItems().elementAt(n);
                xMenuItemPeer.setVisible(false);
                this.getItems().removeElementAt(n);
                this.setSelected(-1);
            }
        }
        this.updateMenuWindow();
    }

    private void updateMenuWindow() {
        if (!this.isVisible() || !this.isCreated()) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        this.updateMenu(rectangle.x, rectangle.y);
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl && this.parentMenu != null && this.parentMenu.isVisible()) {
            XMenuItemPeer xMenuItemPeer;
            XMenuPeer xMenuPeer;
            int n;
            if (this.parentMenu instanceof XMenuBarPeer) {
                XMenuPeer xMenuPeer2;
                XMenuBarPeer xMenuBarPeer;
                int n2;
                if (!bl && (n2 = (xMenuBarPeer = (XMenuBarPeer)this.parentMenu).getMenuSelected()) >= 0 && (xMenuPeer2 = xMenuBarPeer.getMenu(n2)) == this) {
                    xMenuBarPeer.setMenuSelected(-1);
                }
                this.parentMenu.repaint();
            } else if (this.parentMenu instanceof XMenuPeer && !bl && (n = (xMenuPeer = (XMenuPeer)this.parentMenu).getSelected()) >= 0 && (xMenuItemPeer = xMenuPeer.getItem(n)) == this) {
                xMenuPeer.setSelected(-1);
                xMenuPeer.repaintMenuItem(this);
            }
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setLabel(String string) {
        super.setLabel(string);
        if (this.parentMenu != null && this.parentMenu.isVisible() && this.parentMenu instanceof XMenuBarPeer) {
            XMenuBarPeer xMenuBarPeer = (XMenuBarPeer)this.parentMenu;
            this.parentMenu.repaint();
        }
    }

    public void dispose() {
        this.setDisposed(true);
        this.setCreated(false);
        super.dispose();
    }

    void setPosted(boolean bl) {
        this.posted = bl;
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer != null) {
            xMenuPeer.setPosted(bl);
        }
    }

    boolean isPosted() {
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null) {
            return this.posted;
        }
        return xMenuPeer.isPosted();
    }

    int getUpSelected() {
        XMenuItemPeer xMenuItemPeer;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n = xMenuItemPeerArray.length;
        if (n == 0) {
            return -1;
        }
        int n2 = this.getSelected();
        if (n2 < 0) {
            return -1;
        }
        while (!(xMenuItemPeer = xMenuItemPeerArray[n2 = n2 == 0 ? n - 1 : (n2 - 1) % n]).isEnabled() || xMenuItemPeer.getLabel() != null && xMenuItemPeer.getLabel().equals("-")) {
        }
        return n2;
    }

    int getDownSelected() {
        XMenuItemPeer xMenuItemPeer;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n = xMenuItemPeerArray.length;
        if (n == 0) {
            return -1;
        }
        int n2 = this.getSelected();
        while (!(xMenuItemPeer = xMenuItemPeerArray[n2 = (n2 + 1) % n]).isEnabled() || xMenuItemPeer.getLabel() != null && xMenuItemPeer.getLabel().equals("-")) {
        }
        return n2;
    }

    boolean handleKeyPress1(int n, XMenuPeer xMenuPeer) {
        XMenuPeer xMenuPeer2 = this.getMenu();
        if (xMenuPeer2 != null) {
            return xMenuPeer2.handleKeyPress1(n, this);
        }
        switch (n) {
            case 38: {
                this.select(this.getUpSelected());
                break;
            }
            case 40: {
                this.select(this.getDownSelected());
                return true;
            }
            case 37: {
                if (xMenuPeer == null) break;
                this.setPosted(false);
                this.popdown(null, false);
                xMenuPeer.setMenu(null);
                return true;
            }
            case 10: 
            case 32: 
            case 39: {
                XMenuItemPeer xMenuItemPeer;
                int n2 = this.getSelected();
                if (n2 < 0 || (xMenuItemPeer = this.getItem(n2)) == null || !(xMenuItemPeer instanceof XMenuPeer) || !xMenuItemPeer.isEnabled() || xMenuPeer2 != null) break;
                this.setMenu((XMenuPeer)xMenuItemPeer);
                xMenuPeer2 = this.getMenu();
                this.pt.x = this.getWidth() - 2;
                this.pt.y = this.getTop(n2);
                this.pt = this.toGlobal(this.pt);
                xMenuPeer2.popup(this.pt.x, this.pt.y);
                xMenuPeer2.select(0);
                xMenuPeer2.setPosted(true);
                return true;
            }
        }
        return false;
    }

    int getXIndent() {
        return this.xIndent;
    }

    void setXIndent(int n) {
        this.xIndent = n;
    }

    int getItemCount() {
        return this.getItems().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getItem(int n) {
        Vector vector = this.getItems();
        synchronized (vector) {
            if (n < this.getItems().size()) {
                return (XMenuItemPeer)this.getItems().elementAt(n);
            }
            return null;
        }
    }

    Vector getTargetItems() {
        try {
            return (Vector)f_items.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    void setCreated(boolean bl) {
        this.created = bl;
    }

    boolean isCreated() {
        return this.created;
    }

    XMenuPeer getMenu() {
        return this.menu;
    }

    void setMenu(XMenuPeer xMenuPeer) {
        this.menu = xMenuPeer;
    }

    int getSelected() {
        return this.selected;
    }

    void setSelected(int n) {
        this.selected = n;
    }

    int getTitleOffset() {
        return this.titleOffset;
    }

    void setTitleOffset(int n) {
        this.titleOffset = n;
    }

    int getShortcutOffset() {
        return this.shortcutOffset;
    }

    void setShortcutOffset(int n) {
        this.shortcutOffset = n;
    }

    Vector getItems() {
        return this.items;
    }

    void setItems(Vector vector) {
        this.items = vector;
    }

    void setVisible(boolean bl) {
        this.xSetVisible(bl);
    }

    boolean isViewable() {
        return this.viewable;
    }

    void setViewable(boolean bl) {
        this.viewable = bl;
    }
}

