/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.awt.peer.FramePeer;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XIconWindow;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibWrapper;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;

class XFramePeer
extends XDecoratedPeer
implements FramePeer,
XConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XFramePeer");
    private static Logger stateLog = Logger.getLogger("sun.awt.X11.states");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XFramePeer");
    XIconWindow iconWindow;
    XMenuBarPeer menubarPeer;
    MenuBar menubar;
    int state;
    private Boolean undecorated;
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    XFramePeer(Frame frame) {
        super(frame);
    }

    XFramePeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Frame frame = (Frame)this.target;
        this.winAttr.initialState = frame.getState();
        this.state = 0;
        this.winAttr.icon = frame.getIconImage();
        this.undecorated = frame.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !frame.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.isResizable = true;
        this.winAttr.title = frame.getTitle();
        this.winAttr.initialResizability = frame.isResizable();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Frame''s initial attributes: decor {0}, resizable {1}, undecorated {2}, initial state {3}", new Object[]{new Integer(this.winAttr.decorations), this.winAttr.initialResizability, !this.winAttr.nativeDecor, new Integer(this.winAttr.initialState)});
        }
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        if (this.winAttr.icon != null) {
            this.setIconImage(this.winAttr.icon);
        }
        this.setupState(true);
        this.setIconName();
    }

    protected Insets guessInsets() {
        if (this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.guessInsets();
    }

    private boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Frame)this.target).isUndecorated();
    }

    String getIconName() {
        return this.getWMName();
    }

    void setIconName() {
        XAtom xAtom = XAtom.get(37L);
        String string = this.getIconName();
        if (string == null || string.trim().equals("")) {
            string = "Java";
        }
        xAtom.setProperty(this.getWindow(), string);
    }

    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    void setupState(boolean bl) {
        if (bl) {
            this.state = this.winAttr.initialState;
        }
        if ((this.state & 1) != 0) {
            this.setInitialState(3);
        } else {
            this.setInitialState(1);
        }
        this.setExtendedState(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setMenuBar(MenuBar menuBar) {
        block11: {
            XToolkit.awtLock();
            Object object = this.getStateLock();
            // MONITORENTER : object
            if (menuBar != this.menubar) break block11;
            // MONITOREXIT : object
            XToolkit.awtUnlock();
            return;
        }
        if (menuBar == null) {
            if (this.menubar != null) {
                this.menubarPeer.xSetVisible(false);
                this.menubar = null;
                this.menubarPeer.dispose();
                this.menubarPeer = null;
            }
            // MONITOREXIT : object
            XToolkit.awtUnlock();
            return;
        }
        try {
            this.menubar = menuBar;
            this.menubarPeer = (XMenuBarPeer)menuBar.getPeer();
            if (this.menubarPeer != null) {
                this.menubarPeer.init((Frame)this.target);
            }
            Rectangle rectangle = this.target.getBounds();
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.updateChildrenSizes();
            // MONITOREXIT : object
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (!this.target.isVisible()) return;
        this.target.validate();
    }

    XMenuBarPeer getMenubarPeer() {
        return this.menubarPeer;
    }

    int getMenuBarHeight() {
        if (this.menubarPeer != null) {
            return this.menubarPeer.getHeight();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildrenSizes() {
        super.updateChildrenSizes();
        Object object = XFramePeer.getAWTLock();
        synchronized (object) {
            Object object2 = this.getStateLock();
            synchronized (object2) {
                int n = this.dimensions.getClientSize().width;
                if (this.menubarPeer != null) {
                    this.menubarPeer.reshape(0, 0, n, this.getMenuBarHeight());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconImage(Image image) {
        if (this.iconWindow == null) {
            this.iconWindow = new XIconWindow(this);
        }
        if (image != null) {
            int n;
            int n2;
            Object object;
            if (image instanceof ToolkitImage) {
                object = ((ToolkitImage)image).getImageRep();
                ((ImageRepresentation)object).reconstruct(32);
                n2 = ((ImageRepresentation)object).getWidth();
                n = ((ImageRepresentation)object).getHeight();
            } else {
                n2 = image.getWidth(null);
                n = image.getHeight(null);
            }
            object = this.iconWindow.getIconSize(n2, n);
            log.log(Level.FINER, "Icon size is {0}", new Object[]{object});
            if (object != null) {
                int n3 = ((Dimension)object).width;
                int n4 = ((Dimension)object).height;
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration().getDevice().getDefaultConfiguration();
                ColorModel colorModel = graphicsConfiguration.getColorModel();
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n3, n4);
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
                ColorModel colorModel2 = bufferedImage2.getColorModel();
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                Graphics graphics2 = bufferedImage2.getGraphics();
                try {
                    graphics.drawImage(image, 0, 0, n3, n4, null);
                    graphics2.drawImage(image, 0, 0, n3, n4, null);
                }
                finally {
                    graphics.dispose();
                    graphics2.dispose();
                }
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
                Object var17_18 = null;
                Object var18_19 = null;
                int n5 = dataBuffer2.getSize();
                int n6 = this.getNativeColor(SystemColor.window, graphicsConfiguration);
                for (int i = 0; i < n5; ++i) {
                    if (colorModel2.getAlpha(dataBuffer2.getElem(i)) != 0) continue;
                    dataBuffer.setElem(i, n6);
                }
                this.iconWindow.setIconImage(n3, n4, dataBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximizedBounds(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting maximized bounds to " + rectangle);
        }
        if (rectangle == null) {
            return;
        }
        XToolkit.awtLock();
        this.maxBounds = new Rectangle(rectangle);
        try {
            XSizeHints xSizeHints = this.getHints();
            xSizeHints.set_flags(xSizeHints.get_flags() | 0x20L);
            if (rectangle.width != Integer.MAX_VALUE) {
                xSizeHints.set_max_width(rectangle.width);
            } else {
                xSizeHints.set_max_width((int)XlibWrapper.DisplayWidth(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (rectangle.height != Integer.MAX_VALUE) {
                xSizeHints.set_max_height(rectangle.height);
            } else {
                xSizeHints.set_max_height((int)XlibWrapper.DisplayHeight(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(xSizeHints.get_flags()));
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.window, xSizeHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        if (!this.isShowing()) {
            stateLog.finer("Frame is not showing");
            this.state = n;
            return;
        }
        this.changeState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int n) {
        int n2 = this.state ^ n;
        int n3 = n2 & 1;
        boolean bl = (n & 1) != 0;
        stateLog.log(Level.FINER, "Changing state, old state {0}, new state {1}(iconic {2})", new Object[]{new Integer(this.state), new Integer(n), new Boolean(bl)});
        if (n3 != 0 && bl) {
            if (stateLog.isLoggable(Level.FINER)) {
                stateLog.finer("Iconifying shell " + this.getShell() + ", this " + this + ", screen " + this.getScreenNumber());
            }
            try {
                XToolkit.awtLock();
                int n4 = XlibWrapper.XIconifyWindow(XToolkit.getDisplay(), this.getShell(), this.getScreenNumber());
                if (stateLog.isLoggable(Level.FINER)) {
                    stateLog.finer("XIconifyWindow returned " + n4);
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if ((n2 & 0xFFFFFFFE) != 0) {
            this.setExtendedState(n);
        }
        if (n3 != 0 && !bl) {
            if (stateLog.isLoggable(Level.FINER)) {
                stateLog.finer("DeIconifying " + this);
            }
            this.xSetVisible(true);
        }
    }

    void setExtendedState(int n) {
        XWM.getWM().setExtendedState(this, n);
    }

    public void handlePropertyNotify(long l) {
        super.handlePropertyNotify(l);
        XPropertyEvent xPropertyEvent = new XPropertyEvent(l);
        log.log(Level.FINER, "Property change {0}", new Object[]{xPropertyEvent});
        Integer n = XWM.getWM().isStateChange(this, xPropertyEvent);
        if (n == null) {
            return;
        }
        int n2 = this.state ^ n;
        if (n2 == 0) {
            stateLog.finer("State is the same: " + this.state);
            return;
        }
        int n3 = this.state;
        this.state = n;
        if ((n2 & 1) != 0) {
            if ((this.state & 1) != 0) {
                stateLog.finer("Iconified");
                this.handleIconify();
            } else {
                stateLog.finer("DeIconified");
                this.handleDeiconify();
            }
        }
        this.handleStateChange(n3, this.state);
    }

    public void handleStateChange(int n, int n2) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean bl) {
        if (bl) {
            this.setupState(false);
        } else if ((this.state & 6) != 0) {
            XWM.getWM().setExtendedState(this, this.state & 0xFFFFFFF9);
        }
        super.setVisible(bl);
        if (!bl && (this.state & 1) != 0) {
            try {
                XToolkit.awtLock();
                XUnmapEvent xUnmapEvent = new XUnmapEvent();
                xUnmapEvent.set_window(this.getShell());
                xUnmapEvent.set_event(XToolkit.getDefaultRootWindow());
                xUnmapEvent.set_type(18);
                xUnmapEvent.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xUnmapEvent.pData);
                xUnmapEvent.dispose();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (bl && this.maxBounds != null) {
            this.setMaximizedBounds(this.maxBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitialState(int n) {
        try {
            XToolkit.awtLock();
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(2L | xWMHints.get_flags());
            xWMHints.set_initial_state(n);
            if (stateLog.isLoggable(Level.FINE)) {
                stateLog.fine("Setting initial WM state on " + this + " to " + n);
            }
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void dispose() {
        if (this.menubarPeer != null) {
            this.menubarPeer.dispose();
        }
        super.dispose();
    }

    boolean isMaximized() {
        return (this.state & 6) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Object object;
        Serializable serializable;
        Object object2;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        Insets insets = frame.getInsets();
        Dimension dimension = frame.getSize();
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
            if (color3.equals(Color.white)) {
                graphics.setColor(new Color(230, 230, 230));
            } else {
                graphics.setColor(color3);
            }
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.drawLine(0, 1, dimension.width - 1, 1);
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(1, 0, 1, dimension.height - 1);
            graphics.setColor(color3);
            graphics.drawLine(6, dimension.height - 5, dimension.width - 5, dimension.height - 5);
            graphics.drawLine(dimension.width - 5, 6, dimension.width - 5, dimension.height - 5);
            graphics.setColor(color4);
            graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(2, dimension.height - 1, dimension.width, dimension.height - 1);
            graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
            graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height);
            graphics.drawLine(5, 5, dimension.width - 5, 5);
            graphics.drawLine(5, 5, 5, dimension.height - 5);
        }
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MENU)) {
                graphics.setColor(color);
                graphics.fill3DRect(6, 6, 17, 17, true);
                graphics.fill3DRect(11, 13, 8, 3, true);
            }
            graphics.fill3DRect(23, 6, dimension.width - 60, 17, true);
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MINIMIZE)) {
                graphics.fill3DRect(dimension.width - 39, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 32, 13, 3, 3, true);
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MAXIMIZE)) {
                graphics.fill3DRect(dimension.width - 22, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 17, 11, 8, 8, true);
            }
            graphics.setColor(color2);
            object2 = new Font("SansSerif", 0, 10);
            graphics.setFont((Font)object2);
            serializable = graphics.getFontMetrics();
            object = frame.getTitle();
            graphics.drawString((String)object, (46 + dimension.width - 60) / 2 - ((FontMetrics)serializable).stringWidth((String)object) / 2, 14 + ((FontMetrics)serializable).getMaxDescent());
        }
        if (frame.isResizable() && this.hasDecorations(XWindowAttributesData.AWT_DECOR_RESIZEH)) {
            graphics.setColor(color4);
            graphics.drawLine(1, 22, 5, 22);
            graphics.drawLine(22, 1, 22, 5);
            graphics.drawLine(dimension.width - 5 + 1, 22, dimension.width, 22);
            graphics.drawLine(dimension.width - 22 - 1, 2, dimension.width - 22 - 1, 6);
            graphics.drawLine(1, dimension.height - 22 - 1, 5, dimension.height - 22 - 1);
            graphics.drawLine(22, dimension.height - 5 + 1, 22, dimension.height);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22 - 1, dimension.width, dimension.height - 22 - 1);
            graphics.drawLine(dimension.width - 22 - 1, dimension.height - 5 + 1, dimension.width - 22 - 1, dimension.height);
            graphics.setColor(color3);
            graphics.drawLine(2, 23, 5, 23);
            graphics.drawLine(23, 2, 23, 5);
            graphics.drawLine(dimension.width - 5 + 1, 23, dimension.width - 1, 23);
            graphics.drawLine(dimension.width - 22, 2, dimension.width - 22, 5);
            graphics.drawLine(2, dimension.height - 22, 5, dimension.height - 22);
            graphics.drawLine(23, dimension.height - 5 + 1, 23, dimension.height - 1);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22, dimension.width - 1, dimension.height - 22);
            graphics.drawLine(dimension.width - 22, dimension.height - 5 + 1, dimension.width - 22, dimension.height - 1);
        }
        if ((object2 = this.menubarPeer) != null) {
            serializable = this.getInsets();
            object = graphics.create();
            int n = 0;
            int n2 = 0;
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
                n += 6;
                n2 += 6;
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
                n2 += 17;
            }
            try {
                ((Graphics)object).translate(n, n2);
                ((XMenuBarPeer)object2).print((Graphics)object);
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }
}

