/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Iterator;
import java.util.Map;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XException;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;

public final class XDragSourceContextPeer
extends SunDragSourceContextPeer
implements XDragSourceProtocolListener {
    private static final int ROOT_EVENT_MASK = 8195;
    private static final int GRAB_EVENT_MASK = 8204;
    private long rootEventMask = 0L;
    private boolean dndInProgress = false;
    private boolean dragInProgress = false;
    private long dragRootWindow = 0L;
    private XDragSourceProtocol dragProtocol = null;
    private int targetAction = 0;
    private int sourceActions = 0;
    private int sourceAction = 0;
    private long[] sourceFormats = null;
    private long targetRootSubwindow = 0L;
    private int xRoot = 0;
    private int yRoot = 0;
    private int eventState = 0;
    private static final XDragSourceContextPeer theInstance = new XDragSourceContextPeer(null);

    private XDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    static XDragSourceProtocolListener getXDragSourceProtocolListener() {
        return theInstance;
    }

    static XDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        theInstance.setTrigger(dragGestureEvent);
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDrag(Transferable transferable, long[] lArray, Map map) {
        Component component = this.getTrigger().getComponent();
        Component component2 = null;
        XWindowPeer xWindowPeer = null;
        component2 = component;
        while (component2 != null && !(component2 instanceof Window)) {
            component2 = ComponentAccessor.getParent_NoClientCode(component2);
        }
        if (component2 instanceof Window) {
            xWindowPeer = (XWindowPeer)component2.getPeer();
        }
        if (xWindowPeer == null) {
            throw new InvalidDnDOperationException("Cannot find top-level for the drag source component");
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        Object object = this.getCursor();
        if (object != null) {
            l = XGlobalCursorManager.getCursor((Cursor)object);
        }
        object = XToolkit.getAWTLock();
        synchronized (object) {
            int n;
            long l5 = XlibWrapper.XScreenNumberOfScreen(xWindowPeer.getScreen());
            l2 = XlibWrapper.RootWindow(XToolkit.getDisplay(), l5);
            l3 = XWindow.getXAWTRootWindow().getWindow();
            l4 = XToolkit.getCurrentServerTime();
            int n2 = this.getDragSourceContext().getSourceActions();
            Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
            while (iterator.hasNext()) {
                XDragSourceProtocol xDragSourceProtocol = (XDragSourceProtocol)iterator.next();
                try {
                    xDragSourceProtocol.initializeDrag(n2, transferable, map, lArray);
                }
                catch (XException xException) {
                    throw (InvalidDnDOperationException)new InvalidDnDOperationException().initCause(xException);
                }
            }
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes.pData);
                if (n == 0) {
                    throw new InvalidDnDOperationException("XGetWindowAttributes failed");
                }
                this.rootEventMask = xWindowAttributes.get_your_event_mask();
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l2, this.rootEventMask | 0x2003L);
            }
            finally {
                xWindowAttributes.dispose();
            }
            XBaseWindow.ungrabInput();
            n = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), l2, 0, 8204, 1, 1, l2, l, l4);
            if (n != 0) {
                this.cleanup(l4);
                this.throwGrabFailureException("Cannot grab pointer", n);
                return;
            }
            n = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), l2, 0, 1, 1, l4);
            if (n != 0) {
                this.cleanup(l4);
                this.throwGrabFailureException("Cannot grab keyboard", n);
                return;
            }
            this.dndInProgress = true;
            this.dragInProgress = true;
            this.dragRootWindow = l2;
            this.sourceActions = n2;
            this.sourceFormats = lArray;
        }
        this.setNativeContext(0L);
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            super.setCursor(cursor);
        }
    }

    protected void setNativeCursor(long l, Cursor cursor, int n) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        if (cursor == null) {
            return;
        }
        long l2 = XGlobalCursorManager.getCursor(cursor);
        if (l2 == 0L) {
            return;
        }
        XlibWrapper.XChangeActivePointerGrab(XToolkit.getDisplay(), 8204, l2, 0L);
    }

    protected boolean needsBogusExitBeforeDrop() {
        return false;
    }

    private void throwGrabFailureException(String string, int n) throws InvalidDnDOperationException {
        String string2 = "";
        switch (n) {
            case 3: {
                string2 = "not viewable";
                break;
            }
            case 1: {
                string2 = "already grabbed";
                break;
            }
            case 2: {
                string2 = "invalid time";
                break;
            }
            case 4: {
                string2 = "grab frozen";
                break;
            }
            default: {
                string2 = "unknown failure";
            }
        }
        throw new InvalidDnDOperationException(string + ": " + string2);
    }

    public void cleanup(long l) {
        if (this.dndInProgress) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(l);
            }
            if (this.targetAction != 0) {
                this.dragExit(this.xRoot, this.yRoot);
            }
            this.dragDropFinished(false, 0, this.xRoot, this.yRoot);
        }
        Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
        while (iterator.hasNext()) {
            XDragSourceProtocol xDragSourceProtocol = (XDragSourceProtocol)iterator.next();
            try {
                xDragSourceProtocol.cleanup();
            }
            catch (XException xException) {}
        }
        this.dndInProgress = false;
        this.dragInProgress = false;
        this.dragRootWindow = 0L;
        this.sourceFormats = null;
        this.sourceActions = 0;
        this.sourceAction = 0;
        this.eventState = 0;
        this.xRoot = 0;
        this.yRoot = 0;
        this.cleanupTargetInfo();
        this.removeDnDGrab(l);
    }

    private void cleanupTargetInfo() {
        this.targetAction = 0;
        this.dragProtocol = null;
        this.targetRootSubwindow = 0L;
    }

    private void removeDnDGrab(long l) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), l);
        XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), l);
        if ((this.rootEventMask | 0x2003L) != this.rootEventMask && this.dragRootWindow != 0L) {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.dragRootWindow, this.rootEventMask);
        }
        this.rootEventMask = 0L;
        this.dragRootWindow = 0L;
    }

    private boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (this.dragProtocol != null) {
            return this.dragProtocol.processClientMessage(xClientMessageEvent);
        }
        return false;
    }

    private boolean updateSourceAction(int n) {
        int n2 = SunDragSourceContextPeer.convertModifiersToDropAction(XWindow.getModifiers(n, 0, 0), this.sourceActions);
        if (this.sourceAction == n2) {
            return false;
        }
        this.sourceAction = n2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findClientWindow(long l) {
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
        try {
            windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                long l2 = l;
                return l2;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
        XQueryTree xQueryTree = new XQueryTree(l);
        try {
            int n = xQueryTree.execute(null);
            if (n == 0) {
                long l3 = 0L;
                return l3;
            }
            long l4 = xQueryTree.get_children();
            if (l4 == 0L) {
                long l5 = 0L;
                return l5;
            }
            int n2 = xQueryTree.get_nchildren();
            for (int i = 0; i < n2; ++i) {
                long l6 = XDragSourceContextPeer.findClientWindow(Native.getLong(l4, i));
                if (l6 == 0L) continue;
                long l7 = l6;
                return l7;
            }
            long l8 = 0L;
            return l8;
        }
        finally {
            xQueryTree.dispose();
        }
    }

    private void doUpdateTargetWindow(long l, long l2) {
        long l3 = 0L;
        long l4 = 0L;
        XDragSourceProtocol xDragSourceProtocol = null;
        boolean bl = false;
        if (l != 0L) {
            l3 = XDragSourceContextPeer.findClientWindow(l);
        }
        if (l3 != 0L) {
            Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
            while (iterator.hasNext()) {
                XDragSourceProtocol xDragSourceProtocol2 = (XDragSourceProtocol)iterator.next();
                if (!xDragSourceProtocol2.attachTargetWindow(l3, l2)) continue;
                xDragSourceProtocol = xDragSourceProtocol2;
                break;
            }
        }
        this.dragProtocol = xDragSourceProtocol;
        this.targetAction = 0;
        this.targetRootSubwindow = l;
    }

    private void updateTargetWindow(XMotionEvent xMotionEvent) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        int n = xMotionEvent.get_x_root();
        int n2 = xMotionEvent.get_y_root();
        long l = xMotionEvent.get_time();
        long l2 = xMotionEvent.get_subwindow();
        if (xMotionEvent.get_window() != xMotionEvent.get_root()) {
            XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xMotionEvent.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            l2 = Native.getLong(XlibWrapper.larg2);
        }
        if (this.targetRootSubwindow != l2) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(l);
                if (this.targetAction != 0) {
                    this.dragExit(n, n2);
                }
            }
            this.doUpdateTargetWindow(l2, l);
            if (this.dragProtocol != null) {
                this.dragProtocol.sendEnterMessage(this.sourceFormats, this.sourceAction, this.sourceActions, l);
            }
        }
    }

    private void processMouseMove(XMotionEvent xMotionEvent) {
        if (!this.dragInProgress) {
            return;
        }
        if (this.xRoot != xMotionEvent.get_x_root() || this.yRoot != xMotionEvent.get_y_root()) {
            this.xRoot = xMotionEvent.get_x_root();
            this.yRoot = xMotionEvent.get_y_root();
            this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xMotionEvent.get_state(), 0, 0), this.xRoot, this.yRoot, 6);
        }
        if (this.eventState != xMotionEvent.get_state()) {
            if (this.updateSourceAction(xMotionEvent.get_state()) && this.dragProtocol != null) {
                this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xMotionEvent.get_state(), 0, 0), this.xRoot, this.yRoot, 3);
            }
            this.eventState = xMotionEvent.get_state();
        }
        this.updateTargetWindow(xMotionEvent);
        if (this.dragProtocol != null) {
            this.dragProtocol.sendMoveMessage(xMotionEvent.get_x_root(), xMotionEvent.get_y_root(), this.sourceAction, this.sourceActions, xMotionEvent.get_time());
        }
    }

    private void processDrop(XButtonEvent xButtonEvent) {
        try {
            this.dragProtocol.initiateDrop(xButtonEvent.get_x_root(), xButtonEvent.get_y_root(), this.sourceAction, this.sourceActions, xButtonEvent.get_time());
        }
        catch (XException xException) {
            this.cleanup(xButtonEvent.get_time());
        }
    }

    private boolean doProcessEvent(XAnyEvent xAnyEvent) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        if (!this.dndInProgress) {
            return false;
        }
        switch (xAnyEvent.get_type()) {
            case 33: {
                XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(xAnyEvent.pData);
                return this.processClientMessage(xClientMessageEvent);
            }
            case 17: {
                XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent(xAnyEvent.pData);
                if (!this.dragInProgress && this.dragProtocol != null && xDestroyWindowEvent.get_window() == this.dragProtocol.getTargetWindow()) {
                    this.cleanup(0L);
                    return true;
                }
                return false;
            }
        }
        if (!this.dragInProgress) {
            return false;
        }
        switch (xAnyEvent.get_type()) {
            case 2: 
            case 3: {
                XKeyEvent xKeyEvent = new XKeyEvent(xAnyEvent.pData);
                long l = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 0);
                switch ((int)l) {
                    case 65307: {
                        if (xAnyEvent.get_type() != 3) break;
                        this.cleanup(xKeyEvent.get_time());
                        break;
                    }
                    case 65505: 
                    case 65506: 
                    case 65507: 
                    case 65508: {
                        XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xKeyEvent.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                        int n = (int)Native.getLong(XlibWrapper.larg7);
                        xKeyEvent.set_state(n);
                        this.processMouseMove(new XMotionEvent(xKeyEvent.pData));
                        break;
                    }
                }
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                this.processMouseMove(new XMotionEvent(xAnyEvent.pData));
                return true;
            }
            case 5: {
                XButtonEvent xButtonEvent = new XButtonEvent(xAnyEvent.pData);
                this.processMouseMove(new XMotionEvent(xAnyEvent.pData));
                if (xButtonEvent.get_button() == 1) {
                    this.removeDnDGrab(xButtonEvent.get_time());
                    this.dragInProgress = false;
                    if (this.dragProtocol != null && this.targetAction != 0) {
                        this.processDrop(xButtonEvent);
                    } else {
                        this.cleanup(xButtonEvent.get_time());
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean processEvent(XAnyEvent xAnyEvent) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                return theInstance.doProcessEvent(xAnyEvent);
            }
            catch (XException xException) {
                xException.printStackTrace();
                return false;
            }
        }
    }

    public void handleDragReply(int n) {
        this.handleDragReply(n, this.xRoot, this.yRoot);
    }

    public void handleDragReply(int n, int n2, int n3) {
        this.handleDragReply(n, this.xRoot, this.yRoot, XWindow.getModifiers(this.eventState, 0, 0));
    }

    public void handleDragReply(int n, int n2, int n3, int n4) {
        if (n == 0 && this.targetAction != 0) {
            this.dragExit(n2, n3);
        } else if (n != 0) {
            int n5 = 0;
            n5 = this.targetAction == 0 ? 1 : 2;
            this.postDragSourceDragEvent(n, n4, n2, n3, n5);
        }
        this.targetAction = n;
    }

    public void handleDragFinished() {
        this.handleDragFinished(true);
    }

    public void handleDragFinished(boolean bl) {
        this.handleDragFinished(true, this.targetAction);
    }

    public void handleDragFinished(boolean bl, int n) {
        this.handleDragFinished(bl, n, this.xRoot, this.yRoot);
    }

    public void handleDragFinished(boolean bl, int n, int n2, int n3) {
        this.dragDropFinished(bl, n, n2, n3);
        this.dndInProgress = false;
        this.cleanup(0L);
    }
}

