/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private boolean trackSourceActions = false;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;

    protected XDnDDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        super(xDropTargetProtocolListener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener xDropTargetProtocolListener) {
        return new XDnDDropTargetProtocol(xDropTargetProtocolListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDropTarget(long l) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        long l2 = Native.allocateLongArray(1);
        try {
            Native.putLong(l2, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l2, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
        }
        finally {
            unsafe.freeMemory(l2);
            l2 = 0L;
        }
    }

    public void unregisterDropTarget(long l) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        XDnDConstants.XA_XdndAware.DeleteProperty(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEmbedderDropSite(long l) {
        long l2;
        long l3;
        int n;
        boolean bl;
        block29: {
            assert (Thread.holdsLock(XToolkit.getAWTLock()));
            bl = false;
            n = 0;
            l3 = 0L;
            l2 = XDropTargetRegistry.getDnDProxyWindow();
            int n2 = 0;
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
            try {
                n2 = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (n2 == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 4L) {
                    bl = true;
                    n = (int)Native.getLong(windowPropertyGetter.getData());
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
            if (bl && n >= 4) {
                WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                try {
                    n2 = windowPropertyGetter2.execute(XToolkit.IgnoreBadWindowHandler);
                    if (n2 == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == 33L) {
                        l3 = Native.getLong(windowPropertyGetter2.getData());
                    }
                }
                finally {
                    windowPropertyGetter2.dispose();
                }
                if (l3 != 0L) {
                    WindowPropertyGetter windowPropertyGetter3 = new WindowPropertyGetter(l3, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        n2 = windowPropertyGetter3.execute(XToolkit.IgnoreBadWindowHandler);
                        if (n2 != 0 || windowPropertyGetter3.getData() == 0L || windowPropertyGetter3.getActualType() != 33L || Native.getLong(windowPropertyGetter3.getData()) != l3) {
                            l3 = 0L;
                            break block29;
                        }
                        WindowPropertyGetter windowPropertyGetter4 = new WindowPropertyGetter(l3, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                        try {
                            n2 = windowPropertyGetter4.execute(XToolkit.IgnoreBadWindowHandler);
                            if (n2 != 0 || windowPropertyGetter4.getData() == 0L || windowPropertyGetter4.getActualType() != 4L) {
                                l3 = 0L;
                            }
                        }
                        finally {
                            windowPropertyGetter4.dispose();
                        }
                    }
                    finally {
                        windowPropertyGetter3.dispose();
                    }
                }
            }
        }
        if (l3 == l2) {
            return;
        }
        long l4 = Native.allocateLongArray(1);
        try {
            Native.putLong(l4, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndAware.setAtomData(l2, 4L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(l4, 0, l2);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndProxy.setAtomData(l2, 33L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
            Native.putLong(l4, 0, 5L);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(l4, 0, l2);
            XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
            XDnDConstants.XA_XdndProxy.setAtomData(l, 33L, l4, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
        }
        finally {
            unsafe.freeMemory(l4);
            l4 = 0L;
        }
        this.putEmbedderRegistryEntry(l, bl, n, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEmbedderDropSite(long l) {
        block9: {
            assert (Thread.holdsLock(XToolkit.getAWTLock()));
            XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l);
            assert (embedderRegistryEntry != null);
            if (embedderRegistryEntry == null) {
                return;
            }
            if (embedderRegistryEntry.isOverriden()) {
                long l2 = Native.allocateLongArray(1);
                try {
                    Native.putLong(l2, 0, embedderRegistryEntry.getVersion());
                    XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
                    XDnDConstants.XA_XdndAware.setAtomData(l, 4L, l2, 1);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                        throw new XException("Cannot write XdndAware property");
                    }
                    Native.putLong(l2, 0, (int)embedderRegistryEntry.getProxy());
                    XToolkit.WITH_XERROR_HANDLER(XWM.VerifyChangePropertyHandler);
                    XDnDConstants.XA_XdndProxy.setAtomData(l, 33L, l2, 1);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                        throw new XException("Cannot write XdndProxy property");
                    }
                    break block9;
                }
                finally {
                    unsafe.freeMemory(l2);
                    l2 = 0L;
                }
            }
            XDnDConstants.XA_XdndAware.DeleteProperty(l);
            XDnDConstants.XA_XdndProxy.DeleteProperty(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtocolSupported(long l) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        try {
            int n = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 4L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processXdndEnter(XClientMessageEvent xClientMessageEvent) {
        WindowPropertyGetter windowPropertyGetter;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        long[] lArray = null;
        if (this.getSourceWindow() != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xClientMessageEvent.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xClientMessageEvent.get_window()) == null) {
            return false;
        }
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndEnter.getAtom()) {
            return false;
        }
        n = (int)((xClientMessageEvent.get_data(1) & 0xFFFFFFFFFF000000L) >> 24);
        if (n < 3) {
            return false;
        }
        if (n > 5) {
            return false;
        }
        l = xClientMessageEvent.get_data(0);
        if (n < 2) {
            n2 = 1;
        } else {
            windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndActionList, 0L, 65535L, false, 4L);
            try {
                windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32) {
                    long l3 = windowPropertyGetter.getData();
                    for (int i = 0; i < windowPropertyGetter.getNumberOfItems(); ++i) {
                        n2 |= XDnDConstants.getJavaActionForXDnDAction(Native.getLong(l3, i));
                    }
                } else {
                    n2 = 1;
                    bl = true;
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        if ((xClientMessageEvent.get_data(1) & 1L) != 0L) {
            windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndTypeList, 0L, 65535L, false, 4L);
            try {
                windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
                if (windowPropertyGetter.getActualType() == 4L && windowPropertyGetter.getActualFormat() == 32) {
                    lArray = Native.toLongs(windowPropertyGetter.getData(), windowPropertyGetter.getNumberOfItems());
                }
                lArray = new long[]{};
            }
            finally {
                windowPropertyGetter.dispose();
            }
        } else {
            int n3 = 0;
            long[] lArray2 = new long[3];
            for (int i = 0; i < 3; ++i) {
                long l4 = xClientMessageEvent.get_data(2 + i);
                if (l4 == 0L) continue;
                lArray2[n3++] = l4;
            }
            lArray = new long[n3];
            System.arraycopy(lArray2, 0, lArray, 0, n3);
        }
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
            int n4 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (n4 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            l2 = xWindowAttributes.get_your_event_mask();
        }
        finally {
            xWindowAttributes.dispose();
        }
        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, l2 | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = l;
        this.sourceWindowMask = l2;
        this.sourceProtocolVersion = n;
        this.sourceActions = n2;
        this.sourceFormats = lArray;
        this.trackSourceActions = bl;
        return true;
    }

    private boolean processXdndPosition(XClientMessageEvent xClientMessageEvent) {
        XBaseWindow xBaseWindow;
        long l;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        XWindow xWindow = null;
        Object object = XToolkit.windowToXWindow(xClientMessageEvent.get_window());
        if (object instanceof XWindow) {
            xWindow = (XWindow)object;
        }
        n2 = (int)(xClientMessageEvent.get_data(2) >> 16);
        n3 = (int)(xClientMessageEvent.get_data(2) & 0xFFFFL);
        if (xWindow == null && (l = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xClientMessageEvent.get_window(), n2, n3)) != 0L && (xBaseWindow = XToolkit.windowToXWindow(l)) instanceof XWindow) {
            xWindow = (XWindow)xBaseWindow;
        }
        if (xWindow != null) {
            object = xWindow.toLocal(n2, n3);
            n2 = ((Point)object).x;
            n3 = ((Point)object).y;
        }
        if (this.sourceProtocolVersion > 0) {
            l2 = xClientMessageEvent.get_data(3);
        }
        l3 = this.sourceProtocolVersion > 1 ? xClientMessageEvent.get_data(4) : XDnDConstants.XA_XdndActionCopy.getAtom();
        n = XDnDConstants.getJavaActionForXDnDAction(l3);
        if (this.trackSourceActions) {
            this.sourceActions |= n;
        }
        if (xWindow == null) {
            if (this.targetXWindow != null) {
                this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, n2, n3, 0, this.sourceActions, this.sourceFormats, xClientMessageEvent.pData, 505);
            }
        } else {
            int n4 = 0;
            n4 = this.targetXWindow == null ? 504 : 506;
            this.getProtocolListener().handleDropTargetNotification(xWindow, n2, n3, n, this.sourceActions, this.sourceFormats, xClientMessageEvent.pData, n4);
        }
        this.userAction = n;
        this.sourceX = n2;
        this.sourceY = n3;
        this.targetXWindow = xWindow;
        return true;
    }

    private boolean processXdndLeave(XClientMessageEvent xClientMessageEvent) {
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        this.cleanup();
        return true;
    }

    private boolean processXdndDrop(XClientMessageEvent xClientMessageEvent) {
        if (this.sourceWindow != xClientMessageEvent.get_data(0)) {
            return false;
        }
        if (this.targetXWindow != null) {
            this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, this.sourceX, this.sourceY, this.userAction, this.sourceActions, this.sourceFormats, xClientMessageEvent.pData, 502);
        }
        return true;
    }

    public int getMessageType(XClientMessageEvent xClientMessageEvent) {
        long l = xClientMessageEvent.get_message_type();
        if (l == XDnDConstants.XA_XdndEnter.getAtom()) {
            return 1;
        }
        if (l == XDnDConstants.XA_XdndPosition.getAtom()) {
            return 2;
        }
        if (l == XDnDConstants.XA_XdndLeave.getAtom()) {
            return 3;
        }
        if (l == XDnDConstants.XA_XdndDrop.getAtom()) {
            return 4;
        }
        return 0;
    }

    protected boolean processClientMessageImpl(XClientMessageEvent xClientMessageEvent) {
        long l = xClientMessageEvent.get_message_type();
        if (l == XDnDConstants.XA_XdndEnter.getAtom()) {
            return this.processXdndEnter(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndPosition.getAtom()) {
            return this.processXdndPosition(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndLeave.getAtom()) {
            return this.processXdndLeave(xClientMessageEvent);
        }
        if (l == XDnDConstants.XA_XdndDrop.getAtom()) {
            return this.processXdndDrop(xClientMessageEvent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEnterMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(l);
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_data(0));
            long l2 = this.sourceProtocolVersion << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                l2 |= 1L;
            }
            xClientMessageEvent2.set_data(1, l2);
            xClientMessageEvent2.set_data(2, this.sourceFormats.length > 0 ? this.sourceFormats[0] : 0L);
            xClientMessageEvent2.set_data(3, this.sourceFormats.length > 1 ? this.sourceFormats[1] : 0L);
            xClientMessageEvent2.set_data(4, this.sourceFormats.length > 2 ? this.sourceFormats[2] : 0L);
            this.forwardClientMessageToToplevel(l, xClientMessageEvent2);
        }
        finally {
            xClientMessageEvent2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendLeaveMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(l);
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_data(0));
            xClientMessageEvent2.set_data(1, 0L);
            this.forwardClientMessageToToplevel(l, xClientMessageEvent2);
        }
        finally {
            xClientMessageEvent2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendResponse(long l, int n, int n2) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndPosition.getAtom()) {
            return false;
        }
        if (n == 505) {
            n2 = 0;
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_data(0));
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndStatus.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_window());
            long l2 = 0L;
            if (n2 != 0) {
                l2 |= 1L;
            }
            xClientMessageEvent2.set_data(1, l2);
            xClientMessageEvent2.set_data(2, 0L);
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, XDnDConstants.getXDnDActionForJavaAction(n2));
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent.get_data(0), false, 0L, xClientMessageEvent2.pData);
            }
        }
        finally {
            xClientMessageEvent2.dispose();
        }
        return true;
    }

    public Object getData(long l, long l2) throws IllegalArgumentException, IOException {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        long l3 = xClientMessageEvent.get_message_type();
        long l4 = 0L;
        if (l3 == XDnDConstants.XA_XdndPosition.getAtom()) {
            l4 = xClientMessageEvent.get_data(3);
        } else if (l3 == XDnDConstants.XA_XdndDrop.getAtom()) {
            l4 = xClientMessageEvent.get_data(2);
        } else {
            throw new IllegalArgumentException();
        }
        return XDnDConstants.XDnDSelection.getData(l2, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendDropDone(long l, boolean bl, int n) {
        Object object;
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(l);
        if (xClientMessageEvent.get_message_type() != XDnDConstants.XA_XdndDrop.getAtom()) {
            return false;
        }
        if (n == 2 && bl) {
            long l2 = xClientMessageEvent.get_data(2);
            long l3 = XDnDConstants.XDnDSelection.getSelectionAtom().getAtom();
            Object object2 = XToolkit.getAWTLock();
            synchronized (object2) {
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), l3, XAtom.get("DELETE").getAtom(), XAtom.get("XAWT_SELECTION").getAtom(), XWindow.getXAWTRootWindow().getWindow(), l2);
            }
        }
        XClientMessageEvent xClientMessageEvent2 = new XClientMessageEvent();
        try {
            xClientMessageEvent2.set_type(33);
            xClientMessageEvent2.set_window(xClientMessageEvent.get_data(0));
            xClientMessageEvent2.set_format(32);
            xClientMessageEvent2.set_message_type(XDnDConstants.XA_XdndFinished.getAtom());
            xClientMessageEvent2.set_data(0, xClientMessageEvent.get_window());
            xClientMessageEvent2.set_data(1, 0L);
            xClientMessageEvent2.set_data(2, 0L);
            if (this.sourceProtocolVersion >= 5) {
                if (bl) {
                    xClientMessageEvent2.set_data(1, 1L);
                }
                xClientMessageEvent2.set_data(2, XDnDConstants.getXDnDActionForJavaAction(n));
            }
            xClientMessageEvent2.set_data(3, 0L);
            xClientMessageEvent2.set_data(4, 0L);
            object = XToolkit.getAWTLock();
            synchronized (object) {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xClientMessageEvent.get_data(0), false, 0L, xClientMessageEvent2.pData);
            }
        }
        finally {
            xClientMessageEvent2.dispose();
        }
        object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.getProtocolListener().handleDropTargetNotification(this.targetXWindow, 0, 0, 0, this.sourceActions, this.sourceFormats, 0L, 505);
        }
        if (this.sourceWindow != 0L) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XToolkit.RESTORE_XERROR_HANDLER();
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.trackSourceActions = false;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
    }

    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }

    public void adjustEventForForwarding(XClientMessageEvent xClientMessageEvent, XDropTargetProtocol.EmbedderRegistryEntry embedderRegistryEntry) {
        int n = embedderRegistryEntry.getVersion();
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndEnter.getAtom()) {
            int n2 = this.sourceProtocolVersion < n ? this.sourceProtocolVersion : n;
            long l = n2 << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                l |= 1L;
            }
            xClientMessageEvent.set_data(1, l);
        }
    }
}

