/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import sun.awt.X11.XAtom;
import sun.awt.X11.XSelection;
import sun.awt.X11.XToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.security.action.GetIntegerAction;

public class XClipboard
extends SunClipboard
implements Runnable {
    private final XSelection selection;
    private static final Object classLock = new Object();
    private static final int defaultPollInterval = 200;
    private static int pollInterval;
    private static Set listenedClipboards;

    public XClipboard(String string, String string2) {
        super(string);
        this.selection = new XSelection(XAtom.get(string2), this);
    }

    public void run() {
        this.lostOwnershipImpl();
    }

    protected synchronized void setContentsNative(Transferable transferable) {
        SortedMap sortedMap = DataTransferer.getInstance().getFormatsForTransferable(transferable, DataTransferer.adaptFlavorMap(flavorMap));
        DataTransferer.getInstance();
        long[] lArray = DataTransferer.keysToLongArray(sortedMap);
        if (!this.selection.setOwner(transferable, sortedMap, lArray, 0L)) {
            this.owner = null;
            this.contents = null;
        }
    }

    public long getID() {
        return this.selection.getSelectionAtom().getAtom();
    }

    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    protected void clearNativeContext() {
        this.selection.reset();
    }

    protected long[] getClipboardFormats() {
        return this.selection.getTargets(0L);
    }

    protected byte[] getClipboardData(long l) throws IOException {
        return this.selection.getData(l, 0L);
    }

    public void checkChange(long[] lArray) {
        if (!this.selection.isOwner()) {
            super.checkChange(lArray);
        }
    }

    void checkChangeHere(Transferable transferable) {
        if (this.areFlavorListenersRegistered()) {
            super.checkChange(DataTransferer.getInstance().getFormatsForTransferableAsArray(transferable, flavorMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClipboardViewerChecked() {
        if (pollInterval <= 0 && (pollInterval = AccessController.doPrivileged(new GetIntegerAction("awt.datatransfer.clipboard.poll.interval", 200)).intValue()) <= 0) {
            pollInterval = 200;
        }
        this.selection.initializeSelectionForTrackingChanges();
        boolean bl = false;
        Object object = classLock;
        synchronized (object) {
            if (listenedClipboards == null) {
                listenedClipboards = new HashSet(2);
            }
            bl = listenedClipboards.isEmpty();
            listenedClipboards.add(this);
        }
        if (bl) {
            XToolkit.schedule(new CheckChangeTimerTask(), pollInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClipboardViewerChecked() {
        this.selection.deinitializeSelectionForTrackingChanges();
        Object object = classLock;
        synchronized (object) {
            listenedClipboards.remove(this);
        }
    }

    private static class CheckChangeTimerTask
    implements Runnable {
        private CheckChangeTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (XClipboard xClipboard : listenedClipboards) {
                xClipboard.selection.getTargetsDelayed();
            }
            Object object = classLock;
            synchronized (object) {
                if (listenedClipboards != null && !listenedClipboards.isEmpty()) {
                    XToolkit.schedule(this, pollInterval);
                }
            }
        }
    }
}

