/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;
import sun.awt.SunToolkit;

public abstract class UNIXToolkit
extends SunToolkit {
    private String[] gtkIcons = new String[]{"gtk-cancel.4", "gtk-dialog-error.6", "gtk-dialog-info.6", "gtk-dialog-question.6", "gtk-dialog-warning.6", "gtk-no.4", "gtk-ok.4", "gtk-yes.4"};
    private GTKLoadStatus loadedGTKIcons = GTKLoadStatus.NOT_LOADED;
    private static String GTK_HELPER_NAME = "gtkhelper";
    private static String gtkHelperPath = null;
    private static final int[] gtkBandOffsets = new int[]{0, 1, 2, 3};
    private static ColorModel colorModel = null;
    private static Pattern iconNameRegex = Pattern.compile("[a-z\\-]+\\.[0-9]+\\.(ltr|rtl)");

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith("gtk.icon.")) {
            return this.lazilyLoadGTKIcon(string);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object lazilyLoadGTKIcon(String string) {
        boolean bl;
        if (this.loadedGTKIcons == GTKLoadStatus.FAILURE) {
            return null;
        }
        String string2 = string.substring(9);
        if (this.loadedGTKIcons != GTKLoadStatus.NOT_LOADED) {
            this.gtkIcons[0] = string2;
            this.loadGTKIcons(this.gtkIcons);
            return this.desktopProperties.get(string);
        }
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.arch");
                if (string != null && string.equals("x86")) {
                    string = "i386";
                }
                return System.getProperty("java.home") + "/lib/" + string;
            }
        });
        gtkHelperPath = string3 + "/" + GTK_HELPER_NAME;
        String string4 = string2.endsWith("rtl") ? ".rtl" : ".ltr";
        int n = 0;
        while (n < this.gtkIcons.length) {
            int n2 = n++;
            this.gtkIcons[n2] = this.gtkIcons[n2] + string4;
        }
        n = this.loadGTKIcons(this.gtkIcons);
        boolean bl2 = bl = n > 0;
        if (bl) {
            this.loadedGTKIcons = GTKLoadStatus.SUCCESS;
            this.gtkIcons = new String[1];
            this.gtkIcons[0] = string2;
            this.loadGTKIcons(this.gtkIcons);
            return this.desktopProperties.get(string);
        }
        this.loadedGTKIcons = GTKLoadStatus.FAILURE;
        this.gtkIcons = null;
        return null;
    }

    private int loadGTKIcons(String[] stringArray) {
        if (!this.checkGTKIconNames(stringArray)) {
            return 0;
        }
        byte[] byArray = this.readGTKIconData(gtkHelperPath, stringArray);
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = byArray[n++];
            StringBuilder stringBuilder = new StringBuilder(n3);
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append((char)byArray[n++]);
            }
            String string = stringBuilder.toString();
            byte by = byArray[n++];
            int n4 = 0xFF & byArray[n++];
            int n5 = 0xFF & byArray[n++];
            int n6 = 0xFF & byArray[n++];
            int n7 = n5 * n6;
            byte[] byArray2 = new byte[n7];
            System.arraycopy(byArray, n, byArray2, 0, n7);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, n7);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n4, n5, n6, 4, gtkBandOffsets, null);
            if (colorModel == null) {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
            }
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            String string2 = "gtk.icon." + string + "." + by;
            this.setDesktopProperty(string2 + ".ltr", bufferedImage);
            this.setDesktopProperty(string2 + ".rtl", bufferedImage);
            n += n7;
            ++n2;
        }
        return n2;
    }

    private boolean checkGTKIconNames(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (iconNameRegex.matcher(stringArray[i]).matches()) continue;
            return false;
        }
        return true;
    }

    private native byte[] readGTKIconData(String var1, String[] var2);

    public native void sync();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GTKLoadStatus {
        NOT_LOADED,
        FAILURE,
        SUCCESS;

    }
}

