/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.plaf.synth.SynthIcon;

public class SynthGraphicsUtils {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintInsets = new Insets(0, 0, 0, 0);
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private Insets viewSizingInsets = new Insets(0, 0, 0, 0);

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
    }

    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (icon instanceof SynthIcon) {
            SynthIconWrapper synthIconWrapper = SynthIconWrapper.get((SynthIcon)icon, synthContext);
            String string2 = SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, synthIconWrapper, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
            SynthIconWrapper.release(synthIconWrapper);
            return string2;
        }
        return SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, icon, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
    }

    public int computeStringWidth(SynthContext synthContext, Font font, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.stringWidth(synthContext.getComponent(), fontMetrics, string);
    }

    public Dimension getMinimumSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n, n2, n3, n4, n5, n6);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getMaximumSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n, n2, n3, n4, n5, n6);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public int getMaximumCharHeight(SynthContext synthContext) {
        FontMetrics fontMetrics = synthContext.getComponent().getFontMetrics(synthContext.getStyle().getFont(synthContext));
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    public Dimension getPreferredSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Insets insets = jComponent.getInsets(this.viewSizingInsets);
        int n7 = insets.left + insets.right;
        int n8 = insets.top + insets.bottom;
        if (icon == null && (string == null || font == null)) {
            return new Dimension(n7, n8);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(SynthIcon.getIconWidth((Icon)icon, (SynthContext)synthContext) + n7, SynthIcon.getIconHeight((Icon)icon, (SynthContext)synthContext) + n8);
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        this.iconR.height = 0;
        this.iconR.width = 0;
        this.iconR.y = 0;
        this.iconR.x = 0;
        this.textR.height = 0;
        this.textR.width = 0;
        this.textR.y = 0;
        this.textR.x = 0;
        this.viewR.x = n7;
        this.viewR.y = n8;
        this.viewR.height = Short.MAX_VALUE;
        this.viewR.width = Short.MAX_VALUE;
        this.layoutText(synthContext, fontMetrics, string, icon, n, n2, n3, n4, this.viewR, this.iconR, this.textR, n5);
        int n9 = Math.min(this.iconR.x, this.textR.x);
        int n10 = Math.max(this.iconR.x + this.iconR.width, this.textR.x + this.textR.width);
        int n11 = Math.min(this.iconR.y, this.textR.y);
        int n12 = Math.max(this.iconR.y + this.iconR.height, this.textR.y + this.textR.height);
        Dimension dimension = new Dimension(n10 - n9, n12 - n11);
        dimension.width += n7;
        dimension.height += n8;
        return dimension;
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Rectangle rectangle, int n) {
        this.paintText(synthContext, graphics, string, rectangle.x, rectangle.y, n);
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n, int n2, int n3) {
        if (string != null) {
            JComponent jComponent = synthContext.getComponent();
            SynthStyle synthStyle = synthContext.getStyle();
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
            SwingUtilities2.drawString(jComponent, graphics, string, n, n2 += fontMetrics.getAscent());
            if (n3 >= 0 && n3 < string.length()) {
                int n4 = n + SwingUtilities2.stringWidth(jComponent, fontMetrics, string.substring(0, n3));
                int n5 = n2;
                int n6 = fontMetrics.charWidth(string.charAt(n3));
                int n7 = 1;
                graphics.fillRect(n4, n5 + fontMetrics.getDescent() - 1, n6, n7);
            }
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        if (icon == null && string == null) {
            return;
        }
        JComponent jComponent = synthContext.getComponent();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        Insets insets = SynthLookAndFeel.getPaintingInsets(synthContext, this.paintInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String string2 = this.layoutText(synthContext, fontMetrics, string, icon, n, n2, n3, n4, this.paintViewR, this.paintIconR, this.paintTextR, n5);
        if (icon != null) {
            object = graphics.getColor();
            this.paintIconR.x += n7;
            this.paintIconR.y += n7;
            SynthIcon.paintIcon((Icon)icon, (SynthContext)synthContext, (Graphics)graphics, (int)this.paintIconR.x, (int)this.paintIconR.y, (int)this.paintIconR.width, (int)this.paintIconR.height);
            graphics.setColor((Color)object);
        }
        if (string != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, this.paintTextR);
            } else {
                this.paintTextR.x += n7;
                this.paintTextR.y += n7;
                this.paintText(synthContext, graphics, string2, this.paintTextR, n6);
            }
        }
    }

    private static class SynthIconWrapper
    implements Icon {
        private static final List CACHE = new ArrayList(1);
        private SynthIcon synthIcon;
        private SynthContext context;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SynthIconWrapper get(SynthIcon synthIcon, SynthContext synthContext) {
            List list = CACHE;
            synchronized (list) {
                int n = CACHE.size();
                if (n > 0) {
                    SynthIconWrapper synthIconWrapper = (SynthIconWrapper)CACHE.remove(n - 1);
                    synthIconWrapper.reset(synthIcon, synthContext);
                    return synthIconWrapper;
                }
            }
            return new SynthIconWrapper(synthIcon, synthContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void release(SynthIconWrapper synthIconWrapper) {
            synthIconWrapper.reset(null, null);
            List list = CACHE;
            synchronized (list) {
                CACHE.add(synthIconWrapper);
            }
        }

        SynthIconWrapper(SynthIcon synthIcon, SynthContext synthContext) {
            this.reset(synthIcon, synthContext);
        }

        void reset(SynthIcon synthIcon, SynthContext synthContext) {
            this.synthIcon = synthIcon;
            this.context = synthContext;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return this.synthIcon.getIconWidth(this.context);
        }

        public int getIconHeight() {
            return this.synthIcon.getIconHeight(this.context);
        }
    }
}

