/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class CachedPainter {
    private static final Map<Object, Cache> cacheMap = new HashMap<Object, Cache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache getCache(Object object) {
        Map<Object, Cache> map = cacheMap;
        synchronized (map) {
            Cache cache = cacheMap.get(object);
            if (cache == null) {
                cache = new Cache(1);
                cacheMap.put(object, cache);
            }
            return cache;
        }
    }

    public CachedPainter(int n) {
        CachedPainter.getCache(this.getClass()).setMaxCount(n);
    }

    protected void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Object ... objectArray) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Class<?> clazz = this.getClass();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Cache cache = CachedPainter.getCache(clazz);
        Image image = cache.getImage(clazz, graphicsConfiguration, n3, n4, objectArray);
        int n5 = 0;
        do {
            boolean bl = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(graphicsConfiguration)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        bl = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(component, n3, n4, graphicsConfiguration);
                cache.setImage(clazz, graphicsConfiguration, n3, n4, objectArray, image);
                bl = true;
            }
            if (bl) {
                Graphics graphics2 = image.getGraphics();
                this.paintToImage(component, graphics2, n3, n4, objectArray);
                graphics2.dispose();
            }
            this.paintImage(component, graphics, n, n2, n3, n4, image, objectArray);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++n5 < 3);
    }

    protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object[] var5);

    protected void paintImage(Component component, Graphics graphics, int n, int n2, int n3, int n4, Image image, Object[] objectArray) {
        graphics.drawImage(image, n, n2, null);
    }

    protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            return new BufferedImage(n, n2, 1);
        }
        return graphicsConfiguration.createCompatibleVolatileImage(n, n2);
    }

    private static class Cache {
        private int maxCount;
        private List<SoftReference<Entry>> entries;

        Cache(int n) {
            this.maxCount = n;
            this.entries = new ArrayList<SoftReference<Entry>>(n);
        }

        void setMaxCount(int n) {
            this.maxCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry getEntry(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
            Cache cache = this;
            synchronized (cache) {
                Entry entry;
                for (int i = this.entries.size() - 1; i >= 0; --i) {
                    entry = this.entries.get(i).get();
                    if (entry == null) {
                        this.entries.remove(i);
                        continue;
                    }
                    if (!entry.equals(graphicsConfiguration, n, n2, objectArray)) continue;
                    return entry;
                }
                entry = new Entry(graphicsConfiguration, n, n2, objectArray);
                if (this.entries.size() == this.maxCount) {
                    this.entries.remove(0);
                }
                this.entries.add(new SoftReference<Entry>(entry));
                return entry;
            }
        }

        public Image getImage(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
            Entry entry = this.getEntry(object, graphicsConfiguration, n, n2, objectArray);
            return entry.getImage();
        }

        public void setImage(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray, Image image) {
            Entry entry = this.getEntry(object, graphicsConfiguration, n, n2, objectArray);
            entry.setImage(image);
        }

        private static class Entry {
            private GraphicsConfiguration config;
            private Object[] args;
            private Image image;
            private int w;
            private int h;

            Entry(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
                this.config = graphicsConfiguration;
                this.args = objectArray;
                this.w = n;
                this.h = n2;
            }

            public void setImage(Image image) {
                this.image = image;
            }

            public Image getImage() {
                return this.image;
            }

            public String toString() {
                String string = super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h;
                if (this.args != null) {
                    for (int i = 0; i < this.args.length; ++i) {
                        string = string + ", " + this.args[i];
                    }
                }
                string = string + "]";
                return string;
            }

            public boolean equals(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
                if (this.w == n && this.h == n2 && (this.config != null && this.config.equals(graphicsConfiguration) || this.config == null && graphicsConfiguration == null)) {
                    if (this.args == null && objectArray == null) {
                        return true;
                    }
                    if (this.args != null && objectArray != null && this.args.length == objectArray.length) {
                        for (int i = objectArray.length - 1; i >= 0; --i) {
                            if (this.args[i].equals(objectArray[i])) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

