/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.colorchooser.RecentSwatchPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;
    private int selrow;
    private int selcol;
    private boolean showcursor = false;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SwatchPanel.this.showcursor = true;
                SwatchPanel.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                SwatchPanel.this.showcursor = false;
                SwatchPanel.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 38: {
                        if (SwatchPanel.this.selrow > 0) {
                            SwatchPanel.this.selrow--;
                        }
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 40: {
                        if (SwatchPanel.this.selrow < SwatchPanel.this.numSwatches.height - 1) {
                            SwatchPanel.this.selrow++;
                        }
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 37: {
                        if (SwatchPanel.this.selcol > 0) {
                            SwatchPanel.this.selcol--;
                        }
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 39: {
                        if (SwatchPanel.this.selcol < SwatchPanel.this.numSwatches.width - 1) {
                            SwatchPanel.this.selcol++;
                        }
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 36: {
                        SwatchPanel.this.selcol = 0;
                        SwatchPanel.this.selrow = 0;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 35: {
                        SwatchPanel.this.selcol = SwatchPanel.this.numSwatches.width - 1;
                        SwatchPanel.this.selrow = SwatchPanel.this.numSwatches.height - 1;
                        SwatchPanel.this.repaint();
                        break;
                    }
                }
            }
        });
    }

    Color getSelectedColor() {
        return this.getColorForCell(this.selcol, this.selrow);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void initValues() {
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.numSwatches.height; ++i) {
            for (int j = 0; j < this.numSwatches.width; ++j) {
                Color color = this.getColorForCell(j, i);
                graphics.setColor(color);
                int n = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? (this.numSwatches.width - j - 1) * (this.swatchSize.width + this.gap.width) : j * (this.swatchSize.width + this.gap.width);
                int n2 = i * (this.swatchSize.height + this.gap.height);
                graphics.fillRect(n, n2, this.swatchSize.width, this.swatchSize.height);
                graphics.setColor(Color.black);
                graphics.drawLine(n + this.swatchSize.width - 1, n2, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
                graphics.drawLine(n, n2 + this.swatchSize.height - 1, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
                if (this.selrow != i || this.selcol != j || !this.showcursor) continue;
                Color color2 = new Color(color.getRed() < 125 ? 255 : 0, color.getGreen() < 125 ? 255 : 0, color.getBlue() < 125 ? 255 : 0);
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n + this.swatchSize.width, n2);
                graphics.drawLine(n, n2, n, n2 + this.swatchSize.height);
                graphics.drawLine(n + this.swatchSize.width, n2, n + this.swatchSize.width, n2 + this.swatchSize.height);
                graphics.drawLine(n, n2 + this.swatchSize.height, n + this.swatchSize.width, n2 + this.swatchSize.height);
                graphics.drawLine(n, n2, n + this.swatchSize.width, n2 + this.swatchSize.height);
                graphics.drawLine(n, n2 + this.swatchSize.height, n + this.swatchSize.width, n2);
            }
        }
    }

    public Dimension getPreferredSize() {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(n, n2);
    }

    protected void initColors() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    void setSelectedColorFromLocation(int n, int n2) {
        this.selcol = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - n / (this.swatchSize.width + this.gap.width) - 1 : n / (this.swatchSize.width + this.gap.width);
        this.selrow = n2 / (this.swatchSize.height + this.gap.height);
        this.repaint();
    }

    public Color getColorForLocation(int n, int n2) {
        int n3 = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - n / (this.swatchSize.width + this.gap.width) - 1 : n / (this.swatchSize.width + this.gap.width);
        int n4 = n2 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n3, n4);
    }

    private Color getColorForCell(int n, int n2) {
        return this.colors[n2 * this.numSwatches.width + n];
    }
}

