/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.MidiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;

public class Track {
    private ArrayList eventsList = new ArrayList();
    private HashSet set = new HashSet();
    private MidiEvent eotEvent;

    Track() {
        ImmutableEndOfTrack immutableEndOfTrack = new ImmutableEndOfTrack();
        this.eotEvent = new MidiEvent(immutableEndOfTrack, 0L);
        this.eventsList.add(this.eotEvent);
        this.set.add(this.eotEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MidiEvent midiEvent) {
        if (midiEvent == null) {
            return false;
        }
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            if (!this.set.contains(midiEvent)) {
                int n;
                int n2 = this.eventsList.size();
                MidiEvent midiEvent2 = null;
                if (n2 > 0) {
                    midiEvent2 = (MidiEvent)this.eventsList.get(n2 - 1);
                }
                if (midiEvent2 != this.eotEvent) {
                    if (midiEvent2 != null) {
                        this.eotEvent.setTick(midiEvent2.getTick());
                    } else {
                        this.eotEvent.setTick(0L);
                    }
                    this.eventsList.add(this.eotEvent);
                    this.set.add(this.eotEvent);
                }
                if (MidiUtils.isMetaEndOfTrack(midiEvent.getMessage())) {
                    if (midiEvent.getTick() > this.eotEvent.getTick()) {
                        this.eotEvent.setTick(midiEvent.getTick());
                    }
                    return true;
                }
                this.set.add(midiEvent);
                for (n = n2; n > 0 && midiEvent.getTick() < ((MidiEvent)this.eventsList.get(n - 1)).getTick(); --n) {
                }
                if (n == n2) {
                    this.eventsList.set(n2 - 1, midiEvent);
                    if (this.eotEvent.getTick() < midiEvent.getTick()) {
                        this.eotEvent.setTick(midiEvent.getTick());
                    }
                    this.eventsList.add(this.eotEvent);
                } else {
                    this.eventsList.add(n, midiEvent);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MidiEvent midiEvent) {
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            int n;
            if (this.set.remove(midiEvent) && (n = this.eventsList.indexOf(midiEvent)) >= 0) {
                this.eventsList.remove(n);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiEvent get(int n) throws ArrayIndexOutOfBoundsException {
        try {
            ArrayList arrayList = this.eventsList;
            synchronized (arrayList) {
                return (MidiEvent)this.eventsList.get(n);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            return this.eventsList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ticks() {
        long l = 0L;
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            if (this.eventsList.size() > 0) {
                l = ((MidiEvent)this.eventsList.get(this.eventsList.size() - 1)).getTick();
            }
        }
        return l;
    }

    private static class ImmutableEndOfTrack
    extends MetaMessage {
        private ImmutableEndOfTrack() {
            super(new byte[3]);
            this.data[0] = -1;
            this.data[1] = 47;
            this.data[2] = 0;
        }

        public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
            throw new InvalidMidiDataException("cannot modify end of track message");
        }
    }
}

