/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class WindowsToggleButtonUI
extends BasicToggleButtonUI {
    protected static int dashedRectGapX;
    protected static int dashedRectGapY;
    protected static int dashedRectGapWidth;
    protected static int dashedRectGapHeight;
    protected Color focusColor;
    private static final WindowsToggleButtonUI windowsToggleButtonUI;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsToggleButtonUI;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor((String)object + "focus");
            this.defaults_initialized = true;
        }
        if ((object = XPStyle.getXP()) != null) {
            abstractButton.setBorder(((XPStyle)object).getBorder("button.pushbutton"));
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (XPStyle.getXP() == null && abstractButton.isContentAreaFilled() && !(abstractButton.getBorder() instanceof UIResource)) {
            Color color = graphics.getColor();
            int n = abstractButton.getWidth();
            int n2 = abstractButton.getHeight();
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            Color color2 = uIDefaults.getColor("ToggleButton.shadow");
            Container container = abstractButton.getParent();
            if (container != null && container.getBackground().equals(color2)) {
                color2 = uIDefaults.getColor("ToggleButton.darkShadow");
            }
            graphics.setColor(color2);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(uIDefaults.getColor("ToggleButton.highlight"));
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(color);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            if (abstractButton.getParent().getParent() instanceof JFileChooser) {
                Color color = UIManager.getColor("controlShadow");
                Color color2 = UIManager.getColor("controlLtHighlight");
                int n = abstractButton.getWidth();
                int n2 = abstractButton.getHeight();
                Container container = abstractButton.getParent();
                if (container.getBackground().equals(color)) {
                    color = UIManager.getColor("controlDkShadow");
                }
                Color color3 = graphics.getColor();
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(color);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(color3);
            }
            return;
        }
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, dashedRectGapX, dashedRectGapY, abstractButton.getWidth() - dashedRectGapWidth, abstractButton.getHeight() - dashedRectGapHeight);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    static {
        windowsToggleButtonUI = new WindowsToggleButtonUI();
    }
}

