/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class MotifInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    SystemButton systemButton;
    MinimizeButton minimizeButton;
    MaximizeButton maximizeButton;
    JPopupMenu systemMenu;
    Title title;
    Color color;
    Color highlight;
    Color shadow;
    public static final int BUTTON_SIZE = 19;
    static Dimension buttonDimension = new Dimension(19, 19);

    public MotifInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.setPreferredSize(new Dimension(100, 19));
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this;
    }

    protected LayoutManager createLayout() {
        return this;
    }

    JPopupMenu getSystemMenu() {
        return this.systemMenu;
    }

    protected void assembleSystemMenu() {
        this.systemMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.systemMenu.add(new JMenuItem(this.restoreAction));
        jMenuItem.setMnemonic('R');
        jMenuItem = this.systemMenu.add(new JMenuItem(this.moveAction));
        jMenuItem.setMnemonic('M');
        jMenuItem = this.systemMenu.add(new JMenuItem(this.sizeAction));
        jMenuItem.setMnemonic('S');
        jMenuItem = this.systemMenu.add(new JMenuItem(this.iconifyAction));
        jMenuItem.setMnemonic('n');
        jMenuItem = this.systemMenu.add(new JMenuItem(this.maximizeAction));
        jMenuItem.setMnemonic('x');
        this.systemMenu.add(new JSeparator());
        jMenuItem = this.systemMenu.add(new JMenuItem(this.closeAction));
        jMenuItem.setMnemonic('C');
        this.systemButton = new SystemButton();
        this.systemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MotifInternalFrameTitlePane.this.systemMenu.show(MotifInternalFrameTitlePane.this.systemButton, 0, 19);
            }
        });
        this.systemButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MotifInternalFrameTitlePane.this.closeAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, null, mouseEvent.getWhen(), 0));
                    MotifInternalFrameTitlePane.this.systemMenu.setVisible(false);
                }
            }
        });
    }

    protected void createButtons() {
        this.minimizeButton = new MinimizeButton();
        this.minimizeButton.addActionListener(this.iconifyAction);
        this.maximizeButton = new MaximizeButton();
        this.maximizeButton.addActionListener(this.maximizeAction);
    }

    protected void addSubComponents() {
        this.title = new Title(this.frame.getTitle());
        this.title.setFont(this.getFont());
        this.add(this.systemButton);
        this.add(this.title);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
    }

    public void paintComponent(Graphics graphics) {
    }

    void setColors(Color color, Color color2, Color color3) {
        this.color = color;
        this.highlight = color2;
        this.shadow = color3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if ("selected".equals(string)) {
            this.repaint();
        } else if (string.equals("maximizable")) {
            if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.add(this.maximizeButton);
            } else {
                this.remove(this.maximizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (string.equals("iconable")) {
            if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.add(this.minimizeButton);
            } else {
                this.remove(this.minimizeButton);
            }
            this.revalidate();
            this.repaint();
        } else if (string.equals("title")) {
            this.repaint();
        }
        this.enableActions();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(100, 19);
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth();
        this.systemButton.setBounds(0, 0, 19, 19);
        int n2 = n - 19;
        if (this.frame.isMaximizable()) {
            this.maximizeButton.setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (this.maximizeButton.getParent() != null) {
            this.maximizeButton.getParent().remove(this.maximizeButton);
        }
        if (this.frame.isIconifiable()) {
            this.minimizeButton.setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (this.minimizeButton.getParent() != null) {
            this.minimizeButton.getParent().remove(this.minimizeButton);
        }
        this.title.setBounds(19, 0, n2, 19);
    }

    protected void showSystemMenu() {
        this.systemMenu.show(this.systemButton, 0, 19);
    }

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    private class Title
    extends FrameButton {
        Title(String string) {
            this.setText(string);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(0, UIManager.getColor("activeCaptionBorder"), UIManager.getColor("inactiveCaptionBorder")));
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Title.this.forwardEventToParent(mouseEvent);
                }
            });
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (MotifInternalFrameTitlePane.this.frame.isSelected()) {
                graphics.setColor(UIManager.getColor("activeCaptionText"));
            } else {
                graphics.setColor(UIManager.getColor("inactiveCaptionText"));
            }
            Dimension dimension = this.getSize();
            String string = MotifInternalFrameTitlePane.this.frame.getTitle();
            if (string != null) {
                MotifGraphicsUtils.drawStringInRect(MotifInternalFrameTitlePane.this.frame, graphics, string, 0, 0, dimension.width, dimension.height, 0);
            }
        }
    }

    private class SystemButton
    extends FrameButton {
        private SystemButton() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 8, 4, 11);
            graphics.drawLine(4, 8, 14, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, 11, 14, 11);
            graphics.drawLine(14, 9, 14, 11);
        }
    }

    private class MaximizeButton
    extends FrameButton {
        private MaximizeButton() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 14;
            boolean bl = MotifInternalFrameTitlePane.this.frame.isMaximum();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 4, 4, n);
            graphics.drawLine(4, 4, n, 4);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, n, n, n);
            graphics.drawLine(n, 5, n, n);
        }
    }

    private class MinimizeButton
    extends FrameButton {
        private MinimizeButton() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(7, 8, 7, 11);
            graphics.drawLine(7, 8, 10, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(8, 11, 10, 11);
            graphics.drawLine(11, 9, 11, 11);
        }
    }

    private abstract class FrameButton
    extends JButton {
        FrameButton() {
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width - 1;
            int n2 = dimension.height - 1;
            graphics.setColor(MotifInternalFrameTitlePane.this.color);
            graphics.fillRect(1, 1, dimension.width, dimension.height);
            boolean bl = this.getModel().isPressed();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(1, n2, n, n2);
            graphics.drawLine(n, 1, n, n2);
        }
    }
}

