/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swing;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class ArrowKeyAction
extends AbstractAction {
    private int direction;

    public ArrowKeyAction(int n) {
        this.direction = n;
    }

    private boolean isCommandOf(Point point, Point point2) {
        switch (this.direction) {
            case 7: {
                return point.x < point2.x;
            }
            case 3: {
                return point.x > point2.x;
            }
            case 1: {
                return point.y < point2.y;
            }
            case 5: {
                return point.y > point2.y;
            }
        }
        return false;
    }

    private boolean isInLine(Point point, Point point2) {
        switch (this.direction) {
            case 3: 
            case 7: {
                return point.x == point2.x;
            }
            case 1: 
            case 5: {
                return point.y == point2.y;
            }
        }
        return false;
    }

    private boolean closestAlignment(Point point, Point point2, Point point3) {
        switch (this.direction) {
            case 3: 
            case 7: {
                return Math.abs(point3.y - point.y) < Math.abs(point3.y - point2.y);
            }
            case 1: 
            case 5: {
                return Math.abs(point3.x - point.x) < Math.abs(point3.x - point2.x);
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DefaultButtonModel defaultButtonModel;
        ButtonGroup buttonGroup;
        AbstractButton abstractButton;
        ButtonModel buttonModel;
        Object object = actionEvent.getSource();
        if (object instanceof AbstractButton && (buttonModel = (abstractButton = (AbstractButton)object).getModel()) instanceof DefaultButtonModel && (buttonGroup = (defaultButtonModel = (DefaultButtonModel)buttonModel).getGroup()) != null) {
            Point point = abstractButton.getLocationOnScreen();
            JComponent jComponent = null;
            Point point2 = null;
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                Point point3;
                AbstractButton abstractButton2;
                AbstractButton abstractButton3 = enumeration.nextElement();
                if (!(abstractButton3 instanceof JToggleButton) || (abstractButton2 = abstractButton3) == abstractButton || !abstractButton2.isVisible() || !abstractButton2.isDisplayable() || !abstractButton2.isEnabled() || !this.isCommandOf(point3 = abstractButton2.getLocationOnScreen(), point)) continue;
                if (jComponent == null || this.isCommandOf(point2, point3)) {
                    jComponent = abstractButton2;
                    point2 = point3;
                    continue;
                }
                if (!this.isInLine(point2, point3) || !this.closestAlignment(point3, point2, point)) continue;
                jComponent = abstractButton2;
                point2 = point3;
            }
            if (jComponent != null) {
                jComponent.requestFocusInWindow();
                if (jComponent instanceof JRadioButton) {
                    ((AbstractButton)jComponent).doClick(0);
                }
            }
        }
    }
}

