/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.J9Class;

public class J9Method {
    private J9Class myClass;
    String methodName;
    long id;
    String signature;
    long bcStart;
    long bcEnd;
    long jitStart;
    long jitEnd;
    long jitId;
    String idAsString;
    int modifiers;

    public J9Method(J9Class j9Class, String string, String string2, String string3, String string4) {
        this.myClass = j9Class;
        this.methodName = string2;
        this.signature = string3;
        this.idAsString = string;
        this.id = DumpUtils.parseLongHex(string);
        this.modifiers = (int)DumpUtils.parseLongHex(string4);
        J9JVMConsole.addCodeId(this);
        j9Class.addMethod(this);
    }

    public static String getMethodForAddress(long l) {
        String string = null;
        return string;
    }

    public void addBytecode(String string, String string2) {
        String string3 = DumpUtils.stripOff0x(string);
        this.bcStart = DumpUtils.parseLongHex(string3);
        string3 = DumpUtils.stripOff0x(string2);
        this.bcEnd = DumpUtils.parseLongHex(string3);
    }

    public void addJitcode(String string, String string2, String string3) {
        String string4 = DumpUtils.stripOff0x(string);
        this.jitStart = DumpUtils.parseLongHex(string4);
        string4 = DumpUtils.stripOff0x(string2);
        this.jitEnd = DumpUtils.parseLongHex(string4);
        string4 = DumpUtils.stripOff0x(string3);
        this.jitId = DumpUtils.parseLongHex(string4);
        J9JVMConsole.addJitCodeId(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tname: " + this.methodName);
        stringBuffer.append("  \tsig: " + this.signature);
        stringBuffer.append("  \tid: 0x" + Long.toHexString(this.id));
        stringBuffer.append("  \tmodifiers: " + ClassField.convertModifier(this.modifiers));
        if (this.bcStart != 0L && this.bcEnd != 0L) {
            stringBuffer.append("\n\t\t\tBytecode start=0x" + Long.toHexString(this.bcStart) + "   end=0x" + Long.toHexString(this.bcEnd));
        }
        if (this.jitStart != 0L && this.jitEnd != 0L) {
            stringBuffer.append("\n\t\t\tJit code start=0x" + Long.toHexString(this.jitStart) + "   end=0x" + Long.toHexString(this.jitEnd) + "    id=" + Long.toHexString(this.jitId));
        }
        return stringBuffer.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public String getSignature() {
        return this.signature;
    }

    public long getBcEnd() {
        return this.bcEnd;
    }

    public long getBcStart() {
        return this.bcStart;
    }

    public long getJitEnd() {
        return this.jitEnd;
    }

    public long getJitStart() {
        return this.jitStart;
    }

    public long getJitId() {
        return this.jitId;
    }

    public J9Class getMyClass() {
        return this.myClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

