/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoaderLibrary;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class J9ClassLoader {
    String id;
    long obj;
    Vector libraries = new Vector();
    Vector definedLoadedClasses = new Vector();
    Vector cachedLoadedClasses = new Vector();

    public J9ClassLoader(String string, String string2) {
        this.id = string;
        this.obj = DumpUtils.parseLongHex(DumpUtils.stripOff0x(string2));
        J9JVMConsole.addClassLoader(this);
    }

    public void addLibrary(J9ClassLoaderLibrary j9ClassLoaderLibrary) {
        this.libraries.add(j9ClassLoaderLibrary);
    }

    public void addLoadedClass(J9Class j9Class) {
        this.definedLoadedClasses.add(j9Class);
    }

    public void addLoadedClass(String string) {
        this.cachedLoadedClasses.add(string);
    }

    public J9ClassLoaderLibrary[] getLibraries() {
        J9ClassLoaderLibrary[] j9ClassLoaderLibraryArray = null;
        int n = this.libraries.size();
        if (n > 0) {
            j9ClassLoaderLibraryArray = new J9ClassLoaderLibrary[n];
            for (int i = 0; i < n; ++i) {
                j9ClassLoaderLibraryArray[i] = (J9ClassLoaderLibrary)this.libraries.get(i);
            }
        }
        return j9ClassLoaderLibraryArray;
    }

    public String getId() {
        return this.id;
    }

    public long getObj() {
        return this.obj;
    }

    public static void recordLoadedClasses() {
        Set set = J9JVMConsole.getKnownClassesByName().keySet();
        Iterator iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            J9Class j9Class = J9JVMConsole.getClass(string);
            String string2 = j9Class.getLoader();
            if (string2 == null) continue;
            J9ClassLoader j9ClassLoader = J9JVMConsole.getClassLoader(string2);
            j9ClassLoader.addLoadedClass(j9Class);
        }
    }

    public Vector getDefinedLoadedClasses() {
        return this.definedLoadedClasses;
    }

    public Vector getCachedLoadedClasses() {
        return this.cachedLoadedClasses;
    }
}

