/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MediumObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 64;
    private byte gapSize;
    private short gapPreceding;
    private long addressofClass;
    private short hashcode;

    public MediumObjectRecord(J9Object j9Object, J9Object j9Object2) {
        this.tag = (byte)64;
        this.setReferences(j9Object);
        this.addressofClass = j9Object.getClassForObject().getClassAddress();
        this.gapPreceding = (short)MediumObjectRecord.getAddressDifference(j9Object, j9Object2);
        if (this.gapPreceding > Short.MAX_VALUE) {
            throw new IllegalArgumentException("address differences is too big - need long record");
        }
        this.gapSize = MediumObjectRecord.sizeofReference(this.gapPreceding);
    }

    public void writeHeapDump(DataOutput dataOutput) throws IOException {
        byte by = this.tag;
        by = (byte)(by | this.References.length << 3);
        by = (byte)(by | this.gapSize << 2);
        by = (byte)(by | this.referenceSize);
        dataOutput.writeByte(by);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println(" tag = " + by + " gapsize = " + this.gapSize + " references size =" + this.referenceSize);
        }
        this.writeReference(dataOutput, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.is32bit()) {
            dataOutput.writeInt((int)this.addressofClass);
        } else {
            dataOutput.writeLong(this.addressofClass);
        }
        if (PortableHeapDump.isJ9()) {
            dataOutput.writeShort(this.hashcode);
        }
        this.writeReferences(dataOutput);
    }

    public short getHashcode() {
        return this.hashcode;
    }

    public void setHashcode(short s) {
        this.hashcode = s;
    }

    public static void readHeapDump(DataInput dataInput, byte by, PortableHeapDumpHandler portableHeapDumpHandler, PortableHeapDumpClassCache portableHeapDumpClassCache) {
    }
}

