/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Observable;

public class HeapDumpSetCommands
extends HeapDumpAbstractCommand {
    public static final String VERB = "SET";
    public static final String DESC = "Sets control for heapdump command";
    private static final String[] NOUNS = new String[]{"HEAPDUMP", "HEAPDUMPFORMAT", "HEAPDUMPDEBUG", "HEAPDUMPDEBUGOUTPUT", "HD_PORT", "HD_HOST"};
    public static final HeapDumpSetCommandActions[] ACTIONS = new HeapDumpSetCommandActions[]{new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string = commandDetails.getRest();
            if (string.equals("")) {
                return "Heapdump file is currently set to " + HeapDumpConsole.getProperty("HEAPDUMPFILE");
            }
            HeapDumpConsole.setProperty("HEAPDUMPFILE", string);
            return "Heapdump file is set to " + string;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string;
            String string2 = commandDetails.getRest();
            if (string2.equals("")) {
                return "The current format for HeapDump is " + HeapDumpConsole.getProperty("HEAPDUMPFORMAT");
            }
            if (string2.equalsIgnoreCase("Classic")) {
                HeapDumpConsole.setProperty("HEAPDUMPFORMAT", "Classic");
                HeapDumpConsole.setProperty("HEAPDUMPFILE", HeapDumpUtil.getDefaultFileName());
                string = "The HeapDump output is set to Classic";
            } else if (string2.equalsIgnoreCase("Portable")) {
                HeapDumpConsole.setProperty("HEAPDUMPFORMAT", "Portable");
                HeapDumpConsole.setProperty("HEAPDUMPFILE", HeapDumpUtil.getDefaultFileName());
                string = "The HeapDump output is set to Portable";
            } else {
                string = "Unknown Heapdump output type";
            }
            return string;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string = commandDetails.getRest();
            if (string.equals("")) {
                return "Heapdump Tracing is currently " + (PortableHeapDump.isDEBUG() ? "on" : "off");
            }
            if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true")) {
                PortableHeapDump.setDEBUG(true);
            } else if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
                PortableHeapDump.setDEBUG(false);
            }
            return "Heapdump Tracing is now " + (PortableHeapDump.isDEBUG() ? "on" : "off");
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string = commandDetails.getRest();
            if (string.equals("")) {
                return "Heapdump Tracing is currently goes to" + (PortableHeapDump.DEBUG_STREAM == System.err ? "Standard error" : PortableHeapDump.DEBUG_FILENAME);
            }
            if (string.equalsIgnoreCase("*stderr*")) {
                PortableHeapDump.DEBUG_STREAM = System.err;
                return "Heapdump Tracing now goes to Standard error";
            }
            try {
                PortableHeapDump.DEBUG_STREAM = new PrintStream(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return "Heapdump Tracing: cannot create file" + string;
            }
            return "Heapdump Tracing now goes to " + string;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string = commandDetails.getRest();
            if (string.equals("")) {
                return "Heapdump Network output port is currently set to " + HeapDumpConsole.getProperty("HD_PORT");
            }
            try {
                int n = Integer.parseInt(string);
                HeapDumpConsole.setProperty("HD_PORT", string);
                return "Heapump Network output port is now set to: " + string;
            }
            catch (NumberFormatException numberFormatException) {
                return "HD_PORT: Parameter is not a valid number";
            }
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails commandDetails, Observable observable) {
            String string = commandDetails.getRest();
            if (string.equals("")) {
                return "Heapdump Network Host is currently set to " + HeapDumpConsole.getProperty("HD_HOST");
            }
            HeapDumpConsole.setProperty("HD_HOST", string);
            return "Heapdump Network Host is set to " + string;
        }
    }};

    protected HeapDumpSetCommands(String string, HeapDumpBaseCmds heapDumpBaseCmds, Observable observable) {
        super(VERB, string, heapDumpBaseCmds, observable, DESC);
    }

    public static HeapDumpSetCommands[] getHeapDumpSetCommands(HeapDumpBaseCmds heapDumpBaseCmds, Observable observable) {
        HeapDumpSetCommands[] heapDumpSetCommandsArray = new HeapDumpSetCommands[NOUNS.length];
        for (int i = 0; i < NOUNS.length; ++i) {
            heapDumpSetCommandsArray[i] = new HeapDumpSetCommands(NOUNS[i], heapDumpBaseCmds, observable);
        }
        return heapDumpSetCommandsArray;
    }

    public boolean checkUserInput(CommandDetails commandDetails) {
        if (commandDetails.getVerb().equals(VERB)) {
            for (int i = 0; i < NOUNS.length; ++i) {
                if (!commandDetails.getNoun().equals(NOUNS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String action(CommandDetails commandDetails, Observable observable) {
        StringBuffer stringBuffer = new StringBuffer("Unknown settings: available settings are: ");
        for (int i = 0; i < NOUNS.length; ++i) {
            stringBuffer.append(NOUNS[i]);
            stringBuffer.append(" ");
            if (!commandDetails.getNoun().equalsIgnoreCase(NOUNS[i])) continue;
            return ACTIONS[i].commandAction(commandDetails, observable);
        }
        return stringBuffer.toString();
    }

    static interface HeapDumpSetCommandActions {
        public String commandAction(CommandDetails var1, Observable var2);
    }
}

