/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.TransportListenerSpi;
import java.util.List;

public class TransportListener
implements Runnable {
    private TransportListenerSpi listenerSpi;

    private TransportListener(TransportListenerSpi listenerSpi) {
        this.listenerSpi = listenerSpi;
    }

    public static TransportListener getInstance(String providerClass) throws KeyManagerException {
        Class<?> classObj = null;
        try {
            classObj = Class.forName(providerClass);
        }
        catch (ClassNotFoundException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        Object obj = null;
        try {
            obj = classObj.newInstance();
        }
        catch (InstantiationException ex) {
            throw (KeyManagerException)new KeyManagerException("Unable to get an instance of TransportListener").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (KeyManagerException)new KeyManagerException("Unable to get an instance of TransportListener").initCause(ex);
        }
        if (!(obj instanceof TransportListenerSpi)) {
            throw new KeyManagerException("The specified provider class is not an instance of TransportListenerSpi");
        }
        return new TransportListener(obj);
    }

    public static TransportListener getInstance(String providerClass, String type) throws KeyManagerException {
        Class<?> classObj = null;
        try {
            classObj = Class.forName(providerClass);
        }
        catch (ClassNotFoundException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        Object obj = null;
        try {
            obj = classObj.newInstance();
        }
        catch (InstantiationException ex) {
            throw (KeyManagerException)new KeyManagerException("Unable to get an instance of TransportListener").initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (KeyManagerException)new KeyManagerException("Unable to get an instance of TransportListener").initCause(ex);
        }
        if (!(obj instanceof TransportListenerSpi)) {
            throw new KeyManagerException("The specified provider class is not an instance of TransportListenerSpi");
        }
        if (type != null && !type.equalsIgnoreCase(((TransportListenerSpi)obj).getType())) {
            throw new KeyManagerException("The specified type does not match type of the provider class");
        }
        return new TransportListener(obj);
    }

    public void init(Config config) throws KeyManagerException {
        this.listenerSpi.init(config);
    }

    public void setAttribute(String name, Object value) {
        this.listenerSpi.setAttribute(name, value);
    }

    public List getAttributeNames() {
        return this.listenerSpi.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this.listenerSpi.getAttribute(name);
    }

    public int getPort() {
        return this.listenerSpi.getPort();
    }

    public void setPort(int port) {
        this.listenerSpi.setPort(port);
    }

    public ThreadManager getThreadManager() {
        return this.listenerSpi.getThreadManager();
    }

    public void shutdown() throws KeyManagerException {
        this.listenerSpi.shutdown();
    }

    public void register(ThreadManager manager) {
        this.listenerSpi.register(manager);
    }

    public void run() {
        this.listenerSpi.run();
    }

    public String getType() {
        return this.listenerSpi.getType();
    }

    public int getStatus() {
        return this.listenerSpi.getStatus();
    }
}

