/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;

public class SEDK {
    public static final int NO_SIG = 0;
    public static final int RSA_SIG = 1;
    public static final int RSASHA1_SIG = 2;
    public static final int CLEAR_DK = 0;
    public static final int RSA_ALGO = 1;
    public static final int RSAOAEP_ALGO = 2;
    public static final int DESEDE_KEY = 1;
    public static final int AES_KEY = 2;
    public static int SEDKLength;
    private static final byte SEQ_TAG = 48;
    private static final byte OID_TAG = 6;
    private static final byte INT_TAG = 2;
    private static final byte OCTSTRING_TAG = 4;
    private static final byte IA5STRING_TAG = 22;
    private static final byte NULLTYPE_TAG = 5;
    private static final byte EMPTY_TAG = 0;
    private static final int[] RSA_SIGNATURE_data;
    private static final int[] TRIPLE_DES_data;
    private static final int[] AES_data;
    private static final int[] SHA1_data;
    private static final int[] SHA1_WITH_RSA_SIGNATURE_data;
    private static final int[] RSA_ENCRYPTION_OID_data;
    private static final int[] RSAOAEP_ENCRYPTION_OID_data;
    private static ObjectIdentifier SHA1_WITH_RSA_SIGNATURE_OID;
    private static ObjectIdentifier RSA_SIGNATURE_OID;
    private static ObjectIdentifier SHA1_OID;
    private static ObjectIdentifier RSA_ENCRYPTION_OID;
    private static ObjectIdentifier RSAOAEP_ENCRYPTION_OID;
    private static ObjectIdentifier AES_ENCRYPTION_OID;
    private static ObjectIdentifier DES3_ENCRYPTION_OID;
    private static final String className = "com.ibm.keymanager.logic.SEDK";
    private static KMSDebug debug;
    private int kedkInfoVersion = 0;
    private byte kedkInfo = (byte)-93;
    private byte cdkInfo = (byte)-94;
    private int TBSMESInfoVersion = 0;
    private byte[] kekAlgID;
    private byte[] KEKDk;
    private byte KEKIDPublicDigest = (byte)-96;
    private byte[] digestData;
    private byte KEKIDLabel = (byte)-94;
    private String KEKLabel;
    private byte[] mesSig;
    private byte[] dkUID;
    private int encAlgo;
    private int sigAlgo;
    private boolean isDigest;
    private boolean Clear;
    private boolean raw;
    private boolean noSig = false;
    private byte[] ClearDK;
    private int MESDataVersion = 0;
    private PrivateKey SignatureKey;

    public SEDK(byte[] msg, int offset) throws KeyManagerException {
        byte[] header;
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK Constructor");
        }
        if ((header = new byte[]{msg[offset], msg[offset + 1], msg[offset + 2], msg[offset + 3]})[0] == 17 && header[1] == 0) {
            SEDKLength = ((header[2] & 0xFF) << 8) + ((header[3] & 0xFF) << 0);
            this.ClearDK = new byte[SEDKLength];
            System.arraycopy(msg, offset + 4, this.KEKDk, 0, SEDKLength);
            this.raw = true;
        } else if (header[0] == 17 && header[1] == 1) {
            SEDKLength = ((header[2] & 0xFF) << 8) + ((header[3] & 0xFF) << 0);
            this.decode(msg, offset + 4, SEDKLength);
        } else {
            throw new KeyManagerException(2, 15, "Bad SEDK Encoding");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " SEDK Constructor");
        }
    }

    public SEDK(byte[] DK, int encryptionAlgorithm, int signatureAlgorithm, PrivateKey sigKey, byte[] kekDigest, byte[] dkUUID) throws KeyManagerException {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK Constructor");
        }
        if (DK == null || kekDigest == null) {
            throw new KeyManagerException(2, 7, "NULL Input values not accepted");
        }
        if (signatureAlgorithm == 0) {
            this.noSig = true;
        } else if (sigKey == null) {
            throw new KeyManagerException(2, 7, "NULL signature Key");
        }
        this.SignatureKey = sigKey;
        try {
            this.KEKDk = new byte[DK.length];
            System.arraycopy(DK, 0, this.KEKDk, 0, DK.length);
            if (dkUUID != null) {
                this.dkUID = new byte[dkUUID.length];
                System.arraycopy(dkUUID, 0, this.dkUID, 0, dkUUID.length);
            }
            this.digestData = new byte[kekDigest.length];
            System.arraycopy(kekDigest, 0, this.digestData, 0, kekDigest.length);
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 99, exc.getMessage());
        }
        if (encryptionAlgorithm != 1 && encryptionAlgorithm != 2) {
            throw new KeyManagerException(2, 5, "Encryption Algorithm not supported");
        }
        this.encAlgo = encryptionAlgorithm;
        if (signatureAlgorithm > 2) {
            throw new KeyManagerException(2, 5, "Signature Algorithm not supported");
        }
        this.sigAlgo = encryptionAlgorithm;
        this.isDigest = true;
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " SEDK Constructor");
        }
    }

    public SEDK(byte[] DK, int encAlgo, int sigAlgo, byte[] mesSig, String kekLabel, byte[] dkUUID) throws KeyManagerException {
    }

    public SEDK(byte[] rawDK, int encryptionAlgorithm, int signatureAlgorithm, PrivateKey sigKey, byte[] dkUUID) throws KeyManagerException {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK Constructor");
        }
        if (rawDK == null) {
            throw new KeyManagerException(2, 7, "NULL input Clear DK");
        }
        if (signatureAlgorithm == 0) {
            this.noSig = true;
        } else if (sigKey == null) {
            throw new KeyManagerException(2, 7, "NULL signature Key");
        }
        this.SignatureKey = sigKey;
        if (signatureAlgorithm > 2) {
            throw new KeyManagerException(2, 16, "Signature Algorithm not supported");
        }
        this.sigAlgo = encryptionAlgorithm;
        if (encryptionAlgorithm != 1 && encryptionAlgorithm != 2) {
            throw new KeyManagerException(2, 17, "Unsupported Clear DK Encryption Algorithm");
        }
        this.encAlgo = encryptionAlgorithm;
        this.ClearDK = new byte[rawDK.length];
        System.arraycopy(rawDK, 0, this.ClearDK, 0, rawDK.length);
        this.Clear = true;
        if (dkUUID != null) {
            this.dkUID = new byte[dkUUID.length];
            System.arraycopy(dkUUID, 0, this.dkUID, 0, dkUUID.length);
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " SEDK Constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode(byte[] msg, int offset, int len) throws KeyManagerException {
        byte algoParams1;
        DerInputStream buff;
        byte algoParams2;
        ObjectIdentifier tempOID;
        DerInputStream buff2;
        byte tmpKedkInfoVer;
        byte tag;
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK decode()");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(msg, offset, len);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding MES Data");
        }
        if ((tag = (byte)bis.read()) != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        byte bLen = (byte)bis.read();
        int tmpLen = SEDK.getSeqLength(bLen, bis);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding MES Data version");
        }
        if ((tag = (byte)bis.read()) != 2) {
            throw new KeyManagerException(2, 8, "Bad MES Data Version type");
        }
        byte trash = (byte)bis.read();
        byte tmpMESDVer = (byte)bis.read();
        if ((tmpMESDVer & 0xFF) != this.MESDataVersion) {
            throw new KeyManagerException(2, 8, "Bad MES Data Version number");
        }
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding TBS Info Data");
        }
        if ((tag = (byte)bis.read()) != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        bLen = (byte)bis.read();
        tmpLen = SEDK.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 2) {
            throw new KeyManagerException(2, 8, "Bad TBS MES Info Version tag");
        }
        trash = (byte)bis.read();
        byte tmpTBSMESVer = (byte)bis.read();
        if ((tmpTBSMESVer & 0xFF) != this.TBSMESInfoVersion) {
            throw new KeyManagerException(2, 8, "Bad TBS MES Version number");
        }
        tag = (byte)bis.read();
        if (tag != -94) {
            throw new KeyManagerException(2, 9, "Sequence 0xA2 : xedkData");
        }
        bLen = (byte)bis.read();
        tmpLen = SEDK.getSeqLength(bLen, bis);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding MES Key Info Choice");
        }
        byte tmpTag = tag = (byte)bis.read();
        if (tag != this.kedkInfo && tag != this.cdkInfo) {
            throw new KeyManagerException(2, 8, "Bad MES Key Data Choice");
        }
        bLen = (byte)bis.read();
        tmpLen = SEDK.getSeqLength(bLen, bis);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding MES Data Choice");
        }
        if (tmpTag == this.kedkInfo) {
            ObjectIdentifier kekEncAlgo;
            tag = (byte)bis.read();
            if (tag != 2) {
                throw new KeyManagerException(2, 8, "Bad TBSMes Version type");
            }
            trash = (byte)bis.read();
            tmpKedkInfoVer = (byte)bis.read();
            if ((tmpKedkInfoVer & 0xFF) != this.kedkInfoVersion) {
                throw new KeyManagerException(2, 18, "Bad KEDK Info Version number");
            }
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK decode", "decoding KEKey ID");
            }
            if ((tag = (byte)bis.read()) != this.KEKIDPublicDigest && tag != this.KEKIDLabel) {
                throw new KeyManagerException(2, 18, "Unsupported KEK Indentifier Choice");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tag == this.KEKIDPublicDigest) {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK decode", "decoding kek Public Digest");
                }
                if ((tag = (byte)bis.read()) != 48) {
                    throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
                }
                bLen = (byte)bis.read();
                tmpLen = SEDK.getSeqLength(bLen, bis);
                tag = (byte)bis.read();
                if (tag != 6) {
                    throw new KeyManagerException(2, 12, "Bad KEK Alg OID Tag");
                }
                bLen = (byte)bis.read();
                tmpLen = bLen & 0xFF;
                this.kekAlgID = new byte[tmpLen + 2];
                this.kekAlgID[0] = tag;
                this.kekAlgID[1] = (byte)tmpLen;
                bis.read(this.kekAlgID, 2, tmpLen);
                buff2 = new DerInputStream(this.kekAlgID);
                try {
                    tempOID = new ObjectIdentifier(buff2);
                }
                catch (Exception exc) {
                    throw new KeyManagerException(2, 12, "Bad KEK Alg OID Value");
                }
                if (!tempOID.equals(SHA1_OID)) throw new KeyManagerException(2, 10, "Bad Digest Info");
                byte algoParams12 = (byte)bis.read();
                algoParams2 = (byte)bis.read();
                tag = (byte)bis.read();
                if (tag != 4) {
                    throw new KeyManagerException(2, 10, "Bad Digest Tag");
                }
                bLen = (byte)bis.read();
                tmpLen = SEDK.getSeqLength(bLen, bis);
                if (tmpLen == 0) {
                    this.digestData = new byte[bLen & 0xFF];
                    bis.read(this.digestData, 0, bLen & 0xFF);
                } else {
                    this.digestData = new byte[tmpLen];
                    bis.read(this.digestData, 0, tmpLen);
                }
                this.isDigest = true;
            } else {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK decode", "decoding kek Label");
                }
                if ((tag = (byte)bis.read()) != 22) {
                    throw new KeyManagerException(2, 11, "Bad IA5String Label Encoding");
                }
                bLen = (byte)bis.read();
                tmpLen = bLen & 0xFF;
                StringBuffer s = new StringBuffer(tmpLen);
                try {
                    int temp = tmpLen;
                    while (temp-- > 0) {
                        s.append((char)bis.read());
                    }
                    this.KEKLabel = new String(s);
                }
                catch (Exception e) {
                    throw new KeyManagerException(2, 11, "Bad IA5String Label");
                }
            }
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK decode", "decoding kek Alg");
            }
            if ((tag = (byte)bis.read()) != 48) {
                throw new KeyManagerException(2, 12, "Bad kekAlgo Encoding");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            tag = (byte)bis.read();
            if (tag != 6) {
                throw new KeyManagerException(2, 12, "Bad KEK Algo OID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            byte[] kekEncAlgID = new byte[tmpLen + 2];
            kekEncAlgID[0] = tag;
            kekEncAlgID[1] = (byte)tmpLen;
            bis.read(kekEncAlgID, 2, tmpLen);
            buff = new DerInputStream(kekEncAlgID);
            try {
                kekEncAlgo = new ObjectIdentifier(buff);
            }
            catch (Exception exc) {
                throw new KeyManagerException(2, 12, "Bad KEK Algo OID Value");
            }
            if (!kekEncAlgo.equals(RSA_ENCRYPTION_OID) && !kekEncAlgo.equals(RSAOAEP_ENCRYPTION_OID)) throw new KeyManagerException(2, 12, "Bad KEK Encryption Algorithm");
            algoParams1 = (byte)bis.read();
            byte algoParams22 = (byte)bis.read();
            tag = (byte)bis.read();
            if (tag != 4) {
                throw new KeyManagerException(2, 10, "Bad Digest Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.KEKDk = new byte[bLen & 0xFF];
                bis.read(this.KEKDk, 0, bLen & 0xFF);
            } else {
                this.KEKDk = new byte[tmpLen];
                bis.read(this.KEKDk, 0, tmpLen);
            }
            this.encAlgo = kekEncAlgo == RSA_ENCRYPTION_OID ? 1 : 2;
        } else {
            ObjectIdentifier tempOID2;
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK decode", "decoding Clear DK Info");
            }
            if ((tag = (byte)bis.read()) != 2) {
                throw new KeyManagerException(2, 8, "Bad TBSMes Version type");
            }
            trash = (byte)bis.read();
            tmpKedkInfoVer = (byte)bis.read();
            if ((tmpKedkInfoVer & 0xFF) != this.kedkInfoVersion) {
                throw new KeyManagerException(2, 19, "Bad Clear DK Version number");
            }
            tag = (byte)bis.read();
            if (tag != 48) {
                throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            tag = (byte)bis.read();
            if (tag != 6) {
                throw new KeyManagerException(2, 19, "Bad ClearDK Alg OID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            byte[] clearDKAlgID = new byte[tmpLen + 2];
            clearDKAlgID[0] = tag;
            clearDKAlgID[1] = (byte)tmpLen;
            bis.read(clearDKAlgID, 2, tmpLen);
            buff = new DerInputStream(clearDKAlgID);
            try {
                tempOID2 = new ObjectIdentifier(buff);
            }
            catch (Exception exc) {
                throw new KeyManagerException(2, 12, "Bad KEK Algo OID Value");
            }
            if (!tempOID2.equals(AES_ENCRYPTION_OID) && !tempOID2.equals(DES3_ENCRYPTION_OID)) throw new KeyManagerException(2, 19, "Bad Clear DK Algorithm");
            algoParams1 = (byte)bis.read();
            byte algoParams23 = (byte)bis.read();
            tag = (byte)bis.read();
            if (tag != 4) {
                throw new KeyManagerException(2, 10, "Bad Digest Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.ClearDK = new byte[bLen & 0xFF];
                bis.read(this.ClearDK, 0, bLen & 0xFF);
            } else {
                this.ClearDK = new byte[tmpLen];
                bis.read(this.ClearDK, 0, tmpLen);
            }
            this.Clear = true;
        }
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "SEDK decode", "decoding dkUUID");
        }
        if (bis.available() > 3 && (tag = (byte)bis.read()) == 4) {
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.dkUID = new byte[bLen & 0xFF];
                bis.read(this.dkUID, 0, bLen & 0xFF);
            } else {
                this.dkUID = new byte[tmpLen];
                bis.read(this.dkUID, 0, tmpLen);
            }
            if (bis.available() > 3) {
                tag = (byte)bis.read();
            }
        }
        if (bis.available() > 3) {
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK decode", "decoding MES Sig Alg ID");
            }
            if (tag != 48) {
                throw new KeyManagerException(2, 8, "Bad MES Signature ID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tag != 6) {
                throw new KeyManagerException(2, 8, "Bad MES Signature Alg OID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            byte[] mesSigAlgID = new byte[tmpLen];
            bis.read(mesSigAlgID, 0, tmpLen);
            buff2 = new DerInputStream(mesSigAlgID);
            try {
                tempOID = new ObjectIdentifier(buff2);
            }
            catch (Exception exc) {
                throw new KeyManagerException(2, 8, "Bad MES Signature Algo OID Value");
            }
            if (tempOID != SHA1_WITH_RSA_SIGNATURE_OID && tempOID != RSA_SIGNATURE_OID) throw new KeyManagerException(2, 8, "Bad MES Signature Algorithm");
            byte algoParams13 = (byte)bis.read();
            algoParams2 = (byte)bis.read();
            tag = (byte)bis.read();
            if (tag != 4) {
                throw new KeyManagerException(2, 10, "Bad Digest Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = SEDK.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.mesSig = new byte[bLen & 0xFF];
                bis.read(this.mesSig, 0, bLen & 0xFF);
            } else {
                this.mesSig = new byte[tmpLen];
                bis.read(this.mesSig, 0, tmpLen);
            }
            this.sigAlgo = tempOID == RSA_SIGNATURE_OID ? 1 : 2;
        } else {
            this.sigAlgo = 0;
            this.noSig = true;
        }
        if (!debug.isOn("logic")) return;
        debug.exit("logic", className, " SEDK encode()");
    }

    public String getSubjectKeyLabel() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getSubjectKeyLabel");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getSubjectKeyLabel");
        }
        return this.KEKLabel;
    }

    public byte[] getSubjectKeyId() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getSubjectKeyID");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getSubjectKeyID");
        }
        return this.digestData;
    }

    public byte[] getKEKDkey() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getKEKDkey");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getKEKDkey");
        }
        return this.KEKDk;
    }

    public byte[] getClearDkey() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getClearDkey");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getClearDkey");
        }
        return this.ClearDK;
    }

    public int getEncAlgo() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getEncAlgo");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getEncAlgo");
        }
        return this.encAlgo;
    }

    public int getSigAlgo() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getSigAlgo");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getSigAlgo");
        }
        return this.sigAlgo;
    }

    public byte[] getSig() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getSig");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getSig");
        }
        return this.mesSig;
    }

    public byte[] getDKI() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getDKI");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getDKI");
        }
        return this.dkUID;
    }

    public boolean isClear() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK isClear");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK isClear");
        }
        return this.Clear;
    }

    public boolean isDigest() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK isDigest");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK isDigest");
        }
        return this.isDigest;
    }

    public int getLength() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getLength");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getLength");
        }
        return SEDKLength;
    }

    public byte[] encode() throws KeyManagerException {
        try {
            DerOutputStream bytes;
            if (debug.isOn("logic")) {
                debug.entry("logic", className, " SEDK encode");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(17);
            bos.write(1);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK encode", "encoding signature");
            }
            DerOutputStream sigAlgBytes = new DerOutputStream();
            if (!this.noSig) {
                if (this.sigAlgo == 1) {
                    sigAlgBytes.putOID(RSA_SIGNATURE_OID);
                } else {
                    sigAlgBytes.putOID(SHA1_WITH_RSA_SIGNATURE_OID);
                }
                sigAlgBytes.putNull();
            }
            DerOutputStream mesKeyDataBytes = new DerOutputStream();
            if (!this.Clear) {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding kedk");
                }
                bytes = new DerOutputStream();
                bytes.putInteger(0);
                if (this.isDigest) {
                    if (debug.isOn("logic")) {
                        debug.trace("logic", className, "SEDK encode", "encoding digest");
                    }
                    DerOutputStream bytes3 = new DerOutputStream();
                    bytes3.putOID(SHA1_OID);
                    bytes3.putNull();
                    bytes3.putOctetString(this.digestData);
                    DerOutputStream kekPublicDigestDER = new DerOutputStream();
                    kekPublicDigestDER.write((byte)48, bytes3);
                    bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-96), kekPublicDigestDER);
                } else {
                    if (debug.isOn("logic")) {
                        debug.trace("logic", className, "SEDK encode", "encoding keklabel");
                    }
                    DerOutputStream kekLabelDER = new DerOutputStream();
                    kekLabelDER.putIA5String(this.KEKLabel);
                    bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-94), kekLabelDER);
                }
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding kekAlgo");
                }
                DerOutputStream encAlgoBytes = new DerOutputStream();
                if (this.encAlgo == 1) {
                    encAlgoBytes.putOID(RSA_ENCRYPTION_OID);
                } else {
                    encAlgoBytes.putOID(RSAOAEP_ENCRYPTION_OID);
                }
                encAlgoBytes.putNull();
                bytes.write((byte)48, encAlgoBytes);
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding kekdk");
                }
                bytes.putOctetString(this.KEKDk);
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding dkUUID");
                }
                if (this.dkUID != null) {
                    bytes.putOctetString(this.dkUID);
                }
                mesKeyDataBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-93), bytes);
            } else {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding ClearDK");
                }
                bytes = new DerOutputStream();
                bytes.putInteger(0);
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding ClearDK Key Alg");
                }
                DerOutputStream dataKeyAlgBytes = new DerOutputStream();
                if (this.encAlgo == 2) {
                    dataKeyAlgBytes.putOID(AES_ENCRYPTION_OID);
                } else {
                    dataKeyAlgBytes.putOID(DES3_ENCRYPTION_OID);
                }
                dataKeyAlgBytes.putNull();
                bytes.write((byte)48, dataKeyAlgBytes);
                bytes.putOctetString(this.ClearDK);
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "SEDK encode", "encoding dkUUID");
                }
                if (this.dkUID != null) {
                    bytes.putOctetString(this.dkUID);
                }
                mesKeyDataBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-94), bytes);
            }
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK encode", "encoding MesInfo");
            }
            DerOutputStream mesBytes = new DerOutputStream();
            mesBytes.putInteger(0);
            mesBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-94), mesKeyDataBytes);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "SEDK encode", "encoding MesData");
            }
            DerOutputStream mesDataBytes = new DerOutputStream();
            mesDataBytes.putInteger(0);
            mesDataBytes.write((byte)48, mesBytes);
            if (!this.noSig) {
                mesDataBytes.write((byte)48, sigAlgBytes);
                mesDataBytes.putOctetString(this.mesSig);
            }
            DerOutputStream mesDataDER = new DerOutputStream();
            mesDataDER.write((byte)48, mesDataBytes);
            byte[] output = mesDataDER.toByteArray();
            int padSize = 4 - output.length % 4;
            if (padSize == 4) {
                padSize = 0;
            }
            byte[] newOut = new byte[padSize + output.length];
            System.arraycopy(output, 0, newOut, 0, output.length);
            bos.write(newOut.length >>> 8 & 0xFF);
            bos.write(newOut.length >>> 0 & 0xFF);
            bos.write(newOut);
            if (debug.isOn("logic")) {
                debug.exit("logic", className, " SEDK encode");
            }
            return bos.toByteArray();
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 99, exc.getMessage());
        }
    }

    static int getSeqLength(byte lenByte, InputStream in) throws KeyManagerException {
        int value;
        int tmp = lenByte & 0xFF;
        if ((tmp & 0x80) == 0) {
            return 0;
        }
        if ((tmp &= 0x7F) < 0 || tmp > 4) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        try {
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        return value;
    }

    static {
        RSA_SIGNATURE_data = new int[]{1, 3, 14, 3, 2, 11};
        TRIPLE_DES_data = new int[]{1, 3, 6, 1, 4, 1, 4929, 1, 6};
        AES_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1};
        SHA1_data = new int[]{1, 3, 14, 3, 2, 26};
        SHA1_WITH_RSA_SIGNATURE_data = new int[]{1, 3, 14, 3, 2, 29};
        RSA_ENCRYPTION_OID_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        RSAOAEP_ENCRYPTION_OID_data = new int[]{1, 2, 840, 113549, 1, 1, 7};
        try {
            SHA1_WITH_RSA_SIGNATURE_OID = new ObjectIdentifier(SHA1_WITH_RSA_SIGNATURE_data);
            RSA_SIGNATURE_OID = new ObjectIdentifier(RSA_SIGNATURE_data);
            SHA1_OID = new ObjectIdentifier(SHA1_data);
            RSA_ENCRYPTION_OID = new ObjectIdentifier(RSA_ENCRYPTION_OID_data);
            RSAOAEP_ENCRYPTION_OID = new ObjectIdentifier(RSAOAEP_ENCRYPTION_OID_data);
            AES_ENCRYPTION_OID = new ObjectIdentifier(AES_data);
            DES3_ENCRYPTION_OID = new ObjectIdentifier(TRIPLE_DES_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = KMSDebug.getInstance();
    }
}

