/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.EncryptionCBDQuery;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.SigningInfo;
import java.math.BigInteger;

class RequestEEDKs {
    BigInteger encMsgLen;
    BigInteger signedMsgLen;
    ProxyRoutingInfo pri = null;
    byte[] modeParamHdr;
    byte[] origMsg;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "RequestEEDKs.class";

    RequestEEDKs(MsgHeader old, byte command, byte subPageCode, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "RequestEEDKs-Create");
        this.createMsg(old, command, subPageCode, crypto);
        this.debug.exit("logic", className, "RequestEEDKs-Create");
    }

    void createMsg(MsgHeader old, byte command, byte subPageCode, Crypto crypto) throws KeyManagerException {
        int encLen = 0;
        int sMsgLen = 0;
        this.debug.entry("logic", className, "createMsg");
        EncryptionCBDQuery encCDB = new EncryptionCBDQuery(subPageCode);
        ProxyRoutingInfo pri = new ProxyRoutingInfo(old.getProxyRoutingInfo(), command, true);
        sMsgLen = encCDB.getMsgLen() + pri.getMsgLen() + 8;
        this.signedMsgLen = new BigInteger("" + sMsgLen);
        encLen = this.signedMsgLen.intValue() + 4 + SigningInfo.getLength(1024);
        this.origMsg = new byte[encLen + 4];
        MsgHeader header = new MsgHeader(pri, encLen, sMsgLen);
        System.arraycopy(header.getMessage(), 0, this.origMsg, 0, header.getHeaderLen());
        int pos = header.getHeaderLen();
        this.origMsg[pos] = 32;
        this.origMsg[++pos] = 16;
        this.origMsg[++pos] = 0;
        this.origMsg[++pos] = 20;
        ++pos;
        this.origMsg[pos += 2] = 0;
        this.origMsg[++pos] = 16;
        System.arraycopy(encCDB.getMessage(), 0, this.origMsg, ++pos, encCDB.getMsgLen());
        SigningInfo si = new SigningInfo(this.origMsg, 8, sMsgLen, 1024, crypto);
        System.arraycopy(si.getMessage(), 0, this.origMsg, pos += encCDB.getMsgLen(), si.getMsgLen());
        this.debug.exit("logic", className, "createMsg");
    }

    BigInteger getEncMsgLen() {
        this.debug.entry("logic", className, "getEncMsgLen");
        this.debug.exit("logic", className, "getEncMsgLen");
        return this.encMsgLen;
    }

    BigInteger getSignedMsgLen() {
        this.debug.entry("logic", className, "getSignedMsgLen");
        this.debug.exit("logic", className, "getSignedMsgLen");
        return this.signedMsgLen;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.pri.getMsgLen() + 8;
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

