/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import com.ibm.keymanager.logic.EncryptionSubPage;
import com.ibm.keymanager.logic.EncryptionSubPageAlterEEDKs;
import com.ibm.keymanager.logic.EncryptionSubPageQuerydSK;
import com.ibm.keymanager.logic.EncryptionSubPageReqEEDKs;
import com.ibm.keymanager.logic.EncryptionSubPageReqEEDKsQuery;
import com.ibm.keymanager.logic.EncryptionSubPageSetupEEDKs;
import com.ibm.keymanager.logic.EncryptionSubPageTransEEDKs;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.MediumInfo;
import com.ibm.keymanager.logic.RoutingInfo;
import com.ibm.keymanager.logic.SigningInfo;
import java.math.BigInteger;

public class EncryptionSubPageWrapper {
    byte pageCode;
    byte subPageCode;
    BigInteger pageLen;
    BigInteger encryptionMessageLen;
    BigInteger signedMessageLen;
    RoutingInfo rteInfo;
    MediumInfo medInfo;
    byte[] subPagePayloadType = new byte[2];
    BigInteger payloadLen;
    SigningInfo si;
    Object payload = null;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageWrapper.class";
    byte asc;
    byte ascq;
    boolean statusMsg = false;

    /*
     * WARNING - void declaration
     */
    EncryptionSubPageWrapper(RoutingInfo ri, MediumInfo medInfo, byte payloadType, String[] labels, byte[][] skis, byte[][] edks, DKxEEDKUKI oldEEDKs, byte alterAction, byte[] dki, int keyType, byte[] sedk, byte[] publicKeyHash, byte command, byte respCode, byte senseKey, byte asc, byte ascq, Crypto crypto) throws KeyManagerException {
        void var24_26;
        Object esp;
        byte[] payloadData;
        this.debug.entry("logic", className, "EncryptionSubPageWrapper-Create");
        int pageLen = 0;
        int encLen = 0;
        int signMsgLen = 0;
        encLen = 4;
        boolean increment = true;
        if (payloadType == -2) {
            increment = false;
        }
        this.rteInfo = new RoutingInfo(ri, command, increment);
        encLen += this.rteInfo.getMsgLen();
        byte[] bmedInfo = new byte[medInfo.getMsgLen()];
        System.arraycopy(medInfo.getMessage(), 0, bmedInfo, 0, bmedInfo.length);
        medInfo = new MediumInfo(bmedInfo, 0);
        encLen += medInfo.getMsgLen();
        encLen += 4;
        if (payloadType == -32) {
            EncryptionSubPageSetupEEDKs espsEEDKs = new EncryptionSubPageSetupEEDKs(labels, skis, edks, dki, keyType, sedk, publicKeyHash);
            encLen += espsEEDKs.getMsgLen();
            this.payload = espsEEDKs;
            payloadData = espsEEDKs.getMessage();
        } else if (payloadType == -2) {
            esp = new EncryptionSubPage(respCode, senseKey, asc, ascq);
            encLen += ((EncryptionSubPage)esp).getMsgLen();
            this.payload = esp;
            payloadData = ((EncryptionSubPage)esp).getMessage();
        } else if (payloadType == -31) {
            esp = new EncryptionSubPageAlterEEDKs(labels, skis, edks, oldEEDKs, alterAction, keyType, sedk, publicKeyHash);
            encLen += ((EncryptionSubPageAlterEEDKs)esp).getMsgLen();
            this.payload = esp;
            payloadData = ((EncryptionSubPageAlterEEDKs)esp).getMessage();
        } else {
            this.debug.exit("logic", className, "EncryptionSubPageWrapper-Create", "Exception: Message the unknown sub page payload type");
            throw new KeyManagerException(2, 6, "Message the unknown sub page payload type");
        }
        signMsgLen = encLen - 4;
        encLen = crypto == null ? (encLen += SigningInfo.getLength(0)) : (encLen += SigningInfo.getLength(1024));
        pageLen = encLen + 4;
        this.origMsg = payloadType == -2 ? new byte[encLen + 4] : new byte[pageLen + 4];
        this.msglen = new BigInteger("" + this.origMsg.length);
        this.payloadLen = new BigInteger("" + ((void)var24_26).length);
        this.signedMessageLen = new BigInteger("" + signMsgLen);
        this.encryptionMessageLen = new BigInteger("" + encLen);
        this.pageLen = new BigInteger("" + pageLen);
        int pos = 0;
        this.pageCode = (byte)37;
        this.subPageCode = payloadType;
        this.subPagePayloadType[0] = 33;
        this.subPagePayloadType[1] = payloadType;
        if (payloadType != -2) {
            this.origMsg[pos] = 101;
            this.origMsg[++pos] = this.subPageCode;
            System.arraycopy(Logic.IntToByteArray(pageLen, 2), 0, this.origMsg, ++pos, 2);
            pos += 2;
        }
        System.arraycopy(Logic.IntToByteArray(encLen, 4), 0, this.origMsg, pos, 4);
        System.arraycopy(Logic.IntToByteArray(signMsgLen, 4), 0, this.origMsg, pos += 4, 4);
        System.arraycopy(this.rteInfo.getMessage(), 0, this.origMsg, pos += 4, this.rteInfo.getMsgLen());
        System.arraycopy(bmedInfo, 0, this.origMsg, pos += this.rteInfo.getMsgLen(), bmedInfo.length);
        this.origMsg[pos += bmedInfo.length] = 33;
        this.origMsg[++pos] = payloadType;
        System.arraycopy(Logic.IntToByteArray(((void)var24_26).length, 2), 0, this.origMsg, ++pos, 2);
        System.arraycopy(var24_26, 0, this.origMsg, pos += 2, ((void)var24_26).length);
        SigningInfo si = null;
        si = payloadType != -2 ? (crypto == null ? new SigningInfo(this.origMsg, 12, signMsgLen, 0, crypto) : new SigningInfo(this.origMsg, 12, signMsgLen, 1024, crypto)) : (crypto == null ? new SigningInfo(this.origMsg, 8, signMsgLen, 0, crypto) : new SigningInfo(this.origMsg, 8, signMsgLen, 1024, crypto));
        System.arraycopy(si.getMessage(), 0, this.origMsg, pos += ((void)var24_26).length, si.getMsgLen());
        this.debug.exit("logic", className, "EncryptionSubPageWrapper-Create");
    }

    EncryptionSubPageWrapper(byte[] msg, int offset, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageWrapper-Parse");
        this.parseAll(msg, offset, crypto);
        this.debug.exit("logic", className, "EncryptionSubPageWrapper-Parse");
    }

    EncryptionSubPageWrapper(byte[] msg, int offset, boolean flag, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageWrapper-Parse");
        this.parse5511(msg, offset, crypto);
        this.debug.exit("logic", className, "EncryptionSubPageWrapper-Parse");
    }

    void parseAll(byte[] msg, int offset, Crypto crypto) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parseAll");
        pos = offset;
        byte tmp = msg[pos];
        byte ps = (byte)(tmp >> 7);
        tmp = msg[pos];
        byte spf = (byte)(tmp << 1 >> 7);
        tmp = msg[pos];
        this.pageCode = (byte)(tmp & 0x3F);
        ++pos;
        if (ps != 0 || spf != 1 || this.pageCode != 37) {
            this.debug.exit("logic", className, "parseAll", "Wrong message type");
            throw new KeyManagerException(2, 1, "Page Codenot X25");
        }
        this.subPageCode = msg[pos];
        byte[] tmp1 = new byte[]{msg[++pos], msg[++pos]};
        ++pos;
        this.pageLen = new BigInteger(tmp1);
        this.msglen = this.pageLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        tmp1 = new byte[]{msg[pos], msg[++pos], msg[++pos], msg[++pos]};
        this.encryptionMessageLen = new BigInteger(tmp1);
        tmp1 = new byte[]{msg[++pos], msg[++pos], msg[++pos], msg[++pos]};
        this.signedMessageLen = new BigInteger(tmp1);
        this.rteInfo = new RoutingInfo(msg, ++pos);
        this.medInfo = new MediumInfo(msg, pos += this.rteInfo.getMsgLen());
        System.arraycopy(msg, pos += this.medInfo.getMsgLen(), this.subPagePayloadType, 0, 2);
        tmp1 = new byte[]{msg[pos += 2], msg[++pos]};
        ++pos;
        this.payloadLen = new BigInteger(tmp1);
        switch (this.subPagePayloadType[1]) {
            case -2: {
                this.payload = new EncryptionSubPage(msg, pos);
                break;
            }
            case -17: {
                this.payload = new EncryptionSubPageReqEEDKs(msg, pos);
                break;
            }
            case -29: {
                this.payload = new EncryptionSubPageReqEEDKsQuery(msg, pos);
                break;
            }
            case -18: {
                this.payload = new EncryptionSubPageTransEEDKs(msg, pos);
                break;
            }
            case -33: {
                this.payload = new EncryptionSubPageQuerydSK(msg, pos);
                break;
            }
            default: {
                this.debug.exit("logic", className, "parseAll", "Message the wrong sub page payload type");
                throw new KeyManagerException(2, 6, "Message the wrong sub page payload type");
            }
        }
        this.si = new SigningInfo(msg, pos += this.payloadLen.intValue());
        if (!this.si.verify(this.origMsg, 12, this.signedMessageLen.intValue(), crypto)) {
            this.debug.exit("logic", className, "parseAll", "Message has been tammpered with");
            throw new KeyManagerException(2, 2, "Message has been tammpered with");
        }
        this.debug.exit("logic", className, "parse");
    }

    void parse5511(byte[] msg, int offset, Crypto crypto) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parse5511");
        pos = offset;
        byte[] tmp1 = new byte[]{msg[pos], msg[++pos], msg[++pos], msg[++pos]};
        this.encryptionMessageLen = new BigInteger(tmp1);
        tmp1 = new byte[]{msg[++pos], msg[++pos], msg[++pos], msg[++pos]};
        this.signedMessageLen = new BigInteger(tmp1);
        this.msglen = this.encryptionMessageLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.rteInfo = new RoutingInfo(msg, ++pos);
        this.medInfo = new MediumInfo(msg, pos += this.rteInfo.getMsgLen());
        System.arraycopy(msg, pos += this.medInfo.getMsgLen(), this.subPagePayloadType, 0, 2);
        tmp1 = new byte[]{msg[pos += 2], msg[++pos]};
        ++pos;
        this.payloadLen = new BigInteger(tmp1);
        switch (this.subPagePayloadType[1]) {
            case -2: {
                this.payload = new EncryptionSubPage(msg, pos);
                break;
            }
            default: {
                this.debug.exit("logic", className, "parse5511", "Message the wrong sub page payload type");
                throw new KeyManagerException(2, 6, "Message the wrong sub page payload type");
            }
        }
        this.si = new SigningInfo(msg, pos += this.payloadLen.intValue());
        if (!this.si.verify(this.origMsg, 12, this.signedMessageLen.intValue(), crypto)) {
            this.debug.exit("logic", className, "parse5511", "Message has been tammpered with");
            throw new KeyManagerException(2, 2, "Message has been tammpered with");
        }
        this.debug.exit("logic", className, "parse5511");
    }

    byte getPageCode() {
        this.debug.entry("logic", className, "getPageCode");
        this.debug.exit("logic", className, "getPageCode");
        return this.pageCode;
    }

    byte getSubPageCode() {
        this.debug.entry("logic", className, "getSubPageCode");
        this.debug.exit("logic", className, "getSubPageCode");
        return this.pageCode;
    }

    int getPageLen() {
        this.debug.entry("logic", className, "getPageLen");
        this.debug.exit("logic", className, "getPageLen");
        return this.pageLen.intValue();
    }

    int getEncryptionMessageLen() {
        this.debug.entry("logic", className, "getEncryptionMessageLen");
        this.debug.exit("logic", className, "getEncryptionMessageLen");
        return this.encryptionMessageLen.intValue();
    }

    int getSignedMessageLen() {
        this.debug.entry("logic", className, "getSignedMessageLen");
        this.debug.exit("logic", className, "getSignedMessageLen");
        return this.signedMessageLen.intValue();
    }

    RoutingInfo getRoutingInformation() {
        this.debug.entry("logic", className, "getRoutingInformation");
        this.debug.exit("logic", className, "getRoutingInformation");
        return this.rteInfo;
    }

    MediumInfo getMediumInformation() {
        this.debug.entry("logic", className, "getMediumInformation");
        this.debug.exit("logic", className, "getMediumInformation");
        return this.medInfo;
    }

    byte[] getPagePayloadType() {
        this.debug.entry("logic", className, "getPagePayloadType");
        this.debug.exit("logic", className, "getPagePayloadType");
        return this.subPagePayloadType;
    }

    Object getPayLoad() {
        this.debug.entry("logic", className, "getPayLoad");
        this.debug.exit("logic", className, "getPayLoad");
        return this.payload;
    }

    int getPayloadLen() {
        this.debug.entry("logic", className, "getPayloadLen");
        this.debug.exit("logic", className, "getPayloadLen");
        return this.payloadLen.intValue();
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

