/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import java.math.BigInteger;

class EncryptionSubPageTransEEDKs {
    byte action;
    byte[] origMsg;
    BigInteger msglen;
    DKxEEDKUKI currEEDKs;
    DKxEEDKUKI transEEDKs;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageTransEEDKs.class";

    EncryptionSubPageTransEEDKs(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageTransEEDKs");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPageTransEEDKs");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = 0;
        int len = 0;
        this.debug.entry("logic", className, "parse");
        pos = offset;
        byte tmp = msg[pos += 2];
        this.action = (byte)(tmp & 3);
        ++pos;
        this.currEEDKs = new DKxEEDKUKI(msg, ++pos);
        this.transEEDKs = new DKxEEDKUKI(msg, pos += this.currEEDKs.getMsgLen());
        len = 4 + this.currEEDKs.getMsgLen() + this.transEEDKs.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.debug.exit("logic", className, "parse");
    }

    DKxEEDKUKI getCurrentDKxEEDKUKI() {
        this.debug.entry("logic", className, "getCurrentDKxEEDKUKI");
        this.debug.exit("logic", className, "getCurrentDKxEEDKUKI");
        return this.currEEDKs;
    }

    DKxEEDKUKI getTranslateDKxEEDKUKI() {
        this.debug.entry("logic", className, "getTranslateDKxEEDKUKI");
        this.debug.exit("logic", className, "getTranslateDKxEEDKUKI");
        return this.transEEDKs;
    }

    byte getAction() {
        this.debug.entry("logic", className, "getAction");
        this.debug.exit("logic", className, "getAction");
        return this.action;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }
}

