/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import java.math.BigInteger;

class EncryptionSubPageReqEEDKs {
    byte EEDKGen;
    byte oldDK;
    byte oldDKi;
    byte[] origMsg;
    BigInteger msglen;
    DKxEEDKUKI refEEDKs;
    DKxEEDKUKI eedks;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageReqEEDKs.class";

    EncryptionSubPageReqEEDKs(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageReqEEDKs");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPageReqEEDKs");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = 0;
        int len = 0;
        this.debug.entry("logic", className, "parse");
        pos = offset;
        byte tmp = msg[pos += 2];
        this.EEDKGen = (byte)(tmp >> 7);
        tmp = msg[pos];
        this.oldDK = (byte)(tmp << 1 >> 7);
        tmp = msg[pos];
        this.oldDKi = (byte)(tmp << 2 >> 7);
        ++pos;
        this.refEEDKs = new DKxEEDKUKI(msg, ++pos);
        this.eedks = new DKxEEDKUKI(msg, pos += this.refEEDKs.getMsgLen());
        len = 4 + this.refEEDKs.getMsgLen() + this.eedks.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.debug.exit("logic", className, "parse");
    }

    DKxEEDKUKI getRefDKxEEDKUKI() {
        this.debug.entry("logic", className, "getRefDKxEEDKUKI");
        this.debug.exit("logic", className, "getRefDKxEEDKUKI");
        return this.refEEDKs;
    }

    DKxEEDKUKI getDKxEEDKUKI() {
        this.debug.entry("logic", className, "getRefDKxEEDKUKI");
        this.debug.exit("logic", className, "getRefDKxEEDKUKI");
        return this.eedks;
    }

    byte getGenerateEEDK() {
        this.debug.entry("logic", className, "getDKxEEDKUKI");
        this.debug.exit("logic", className, "getDKxEEDKUKI");
        return this.EEDKGen;
    }

    byte getOldDK() {
        this.debug.entry("logic", className, "getOldDK");
        this.debug.exit("logic", className, "getOldDK");
        return this.oldDK;
    }

    byte getOldDKi() {
        this.debug.entry("logic", className, "getOldDKi");
        this.debug.exit("logic", className, "getOldDKi");
        return this.oldDKi;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }
}

