/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.EncryptionSubPageWrapper;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.SigningInfo;
import java.math.BigInteger;

public class EncSubPageQueryResponse {
    BigInteger encMsgLen;
    BigInteger signedMsgLen;
    ProxyRoutingInfo pri = null;
    MsgHeader header;
    EncryptionSubPageWrapper esp;
    byte[] modeParamHdr;
    byte[] origMsg;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncSubPageQueryResponse.class";

    EncSubPageQueryResponse(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "EncSubPageQueryResponse");
        this.origMsg = new byte[msg.length];
        System.arraycopy(msg, 0, this.origMsg, 0, msg.length);
        this.parse(msg, crypto);
        this.debug.exit("logic", className, "EncSubPageQueryResponse");
    }

    void parse(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        this.header = new MsgHeader(msg);
        int pos = this.header.getHeaderLen();
        if (msg[pos] != 33 || msg[pos + 1] != 0) {
            this.debug.exit("logic", className, "parse", "Message type not X2100");
            throw new KeyManagerException(2, 1, "Message type not X2100");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(msg, pos += 2, tmp, 0, 2);
        BigInteger subPayloadLen = new BigInteger(tmp);
        this.modeParamHdr = new byte[8];
        System.arraycopy(msg, pos += 2, this.modeParamHdr, 0, 8);
        this.esp = new EncryptionSubPageWrapper(msg, pos += 8, crypto);
        SigningInfo si = new SigningInfo(msg, pos += this.esp.getMsgLen());
        if (!si.verify(msg, 8, this.header.getSignedMsgLen().intValue(), crypto)) {
            this.debug.exit("logic", className, "parse", "Message has been tammpered with");
            throw new KeyManagerException(2, 2, "Message has been tammpered with");
        }
        this.debug.exit("logic", className, "parse");
    }

    EncryptionSubPageWrapper getEncryptionSubPageWrapper() {
        this.debug.entry("logic", className, "getEncryptionSubPageWrapper");
        this.debug.exit("logic", className, "getEncryptionSubPageWrapper");
        return this.esp;
    }

    MsgHeader getMessageHeader() {
        this.debug.entry("logic", className, "getMessageHeader");
        this.debug.exit("logic", className, "getMessageHeader");
        return this.header;
    }

    BigInteger getEncMsgLen() {
        this.debug.entry("logic", className, "getEncMsgLen");
        this.debug.exit("logic", className, "getEncMsgLen");
        return this.encMsgLen;
    }

    BigInteger getSignedMsgLen() {
        this.debug.entry("logic", className, "getSignedMsgLen");
        this.debug.exit("logic", className, "getSignedMsgLen");
        return this.signedMsgLen;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.pri.getMsgLen() + 8;
    }
}

