/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DKx;
import com.ibm.keymanager.logic.EEDKUKI;
import com.ibm.keymanager.logic.Logic;
import java.math.BigInteger;

public class DKxEEDKUKI {
    byte[] structType = new byte[2];
    BigInteger DKxLen;
    DKx dkx = null;
    BigInteger EEDKUKICount;
    EEDKUKI[] eedkukiArray = null;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "DKxEEDKUKI.class";

    DKxEEDKUKI(String[] labels, byte[][] skis, byte[][] edks, byte[] dki, int keyType) throws KeyManagerException {
        this.debug.entry("logic", className, "DKxEEDKUKI-Create");
        int len = 0;
        this.structType[0] = 24;
        this.structType[1] = 0;
        this.EEDKUKICount = labels == null && skis == null && edks == null ? BigInteger.ZERO : new BigInteger("2");
        this.eedkukiArray = new EEDKUKI[this.EEDKUKICount.intValue()];
        if (this.EEDKUKICount.intValue() != 0) {
            this.dkx = new DKx(dki, null, 0, 0, 0, 0, 0);
            this.DKxLen = new BigInteger("" + this.dkx.getMsgLen());
        } else {
            this.DKxLen = BigInteger.ZERO;
        }
        for (int i = 0; i < this.EEDKUKICount.intValue(); ++i) {
            this.eedkukiArray[i] = new EEDKUKI(labels[i], skis[i], edks[i], keyType);
            len += this.eedkukiArray[i].getMsgLen();
        }
        len = len + 4 + this.DKxLen.intValue() + 4;
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        int pos = 0;
        this.origMsg[pos] = 24;
        this.origMsg[++pos] = 0;
        System.arraycopy(Logic.IntToByteArray(this.DKxLen.intValue(), 2), 0, this.origMsg, ++pos, 2);
        pos += 2;
        if (this.DKxLen.intValue() != 0) {
            System.arraycopy(this.dkx.getMessage(), 0, this.origMsg, pos, this.DKxLen.intValue());
            pos += this.DKxLen.intValue();
        }
        System.arraycopy(Logic.IntToByteArray(this.EEDKUKICount.intValue(), 2), 0, this.origMsg, pos += 2, 2);
        pos += 2;
        for (int i = 0; i < this.EEDKUKICount.intValue(); ++i) {
            System.arraycopy(this.eedkukiArray[i].getMessage(), 0, this.origMsg, pos, this.eedkukiArray[i].getMsgLen());
            pos += this.eedkukiArray[i].getMsgLen();
        }
        this.debug.exit("logic", className, "DKxEEDKUKI-Create");
    }

    DKxEEDKUKI(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "DKxEEDKUKI-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "DKxEEDKUKI-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        int pos = 0;
        pos = offset;
        System.arraycopy(msg, pos, this.structType, 0, 2);
        pos += 2;
        if (this.structType[0] != 24 || this.structType[1] != 0) {
            if (this.debug.isOn("logic")) {
                this.debug.trace("logic", className, "parse", "offset " + offset);
                this.debug.trace("logic", className, "parse", this.structType);
                this.debug.exit("logic", className, "parse", "Message type not X1800");
            }
            throw new KeyManagerException(2, 1, "Message type not X1800");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.DKxLen = new BigInteger(tmp);
        if (this.DKxLen.intValue() > 0) {
            this.dkx = new DKx(msg, pos, this.DKxLen.intValue());
            pos += this.DKxLen.intValue();
        }
        tmp = new byte[]{msg[pos += 2], msg[++pos]};
        ++pos;
        this.EEDKUKICount = new BigInteger(tmp);
        this.eedkukiArray = new EEDKUKI[this.EEDKUKICount.intValue()];
        for (int i = 0; i < this.eedkukiArray.length; ++i) {
            this.eedkukiArray[i] = new EEDKUKI(msg, pos);
            pos += this.eedkukiArray[i].getMsgLen();
        }
        this.msglen = new BigInteger(new Integer(pos - offset).toString());
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "parse");
    }

    DKx getDKX() {
        this.debug.entry("logic", className, "getDKX");
        this.debug.exit("logic", className, "getDKX");
        return this.dkx;
    }

    int getDKxLength() {
        this.debug.entry("logic", className, "getDKxLength");
        this.debug.exit("logic", className, "getDKxLength");
        return this.DKxLen.intValue();
    }

    EEDKUKI[] getEEDKUKIs() {
        this.debug.entry("logic", className, "getEEDKUKIs");
        this.debug.exit("logic", className, "getEEDKUKIs");
        return this.eedkukiArray;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

