/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "Crypto.class";
    String providerName = null;
    Provider prov = null;
    boolean sync = false;

    public Crypto(ServerParameters sparams) throws KeyManagerException {
        this.debug.entry("logic", className, "Crypto");
        String FIPSString = (String)sparams.getConfig().get("fips");
        if (FIPSString.compareToIgnoreCase("ON") == 0) {
            this.providerName = "IBMJCEFIPS";
        } else {
            String keyStoreType = sparams.getKeyStore().getType();
            this.prov = sparams.getKeyStore().getProvider();
            if (keyStoreType.compareToIgnoreCase("PKCS11IMPLKS") == 0) {
                this.prov = sparams.getKeyStore().getProvider();
                this.sync = true;
            } else {
                this.providerName = keyStoreType.compareToIgnoreCase("JCE4758KS") == 0 || keyStoreType.compareToIgnoreCase("JCE4758RACFKS") == 0 ? "IBMJCE4758" : (keyStoreType.compareToIgnoreCase("JCECCAKS") == 0 || keyStoreType.compareToIgnoreCase("JCECCARACFKS") == 0 ? "IBMJCECCA" : "IBMJCE");
            }
        }
        this.debug.exit("logic", className, "Crypto");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] hash(String algo, byte[] data, int off, int len) throws KeyManagerException {
        byte[] result;
        MessageDigest md = null;
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    md = MessageDigest.getInstance(algo, this.prov);
                }
                catch (NoSuchAlgorithmException e) {
                    try {
                        md = MessageDigest.getInstance(algo);
                    }
                    catch (NoSuchAlgorithmException e1) {
                        this.debug.exit("logic", className, "hash", "Exception: " + e1.getMessage());
                        throw new KeyManagerException(e);
                    }
                }
                md.update(data, off, len);
                result = md.digest();
            }
        }
        try {
            md = MessageDigest.getInstance(algo, this.providerName);
        }
        catch (Exception e) {
            this.debug.trace("logic", className, "hash", "Expected Exception: " + e.getMessage());
            try {
                md = MessageDigest.getInstance(algo);
            }
            catch (NoSuchAlgorithmException e1) {
                this.debug.exit("logic", className, "hash", "Exception: " + e1.getMessage());
                throw new KeyManagerException(e);
            }
        }
        md.update(data, off, len);
        result = md.digest();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecretKey GenerateKey(String algo) throws KeyManagerException, NoSuchAlgorithmException {
        SecretKey dk;
        KeyGenerator keyGen = null;
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    keyGen = KeyGenerator.getInstance(algo, this.prov);
                }
                catch (NoSuchAlgorithmException e) {
                    this.debug.exit("logic", className, "GenerateKey1", "Exception: " + e.getMessage());
                    throw new NoSuchAlgorithmException(e.getMessage());
                }
                if (keyGen.getAlgorithm().equals("AES")) {
                    keyGen.init(256);
                }
                dk = keyGen.generateKey();
            }
        }
        try {
            keyGen = KeyGenerator.getInstance(algo, this.providerName);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "GenerateKey2", "Exception: " + e.getMessage());
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        if (keyGen.getAlgorithm().equals("AES")) {
            keyGen.init(256);
        }
        dk = keyGen.generateKey();
        return dk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[][] EncryptKey(PublicKey[] pubs, SecretKey dk) throws KeyManagerException {
        Cipher cp = null;
        byte[][] ekeys = new byte[pubs.length][];
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    cp = Cipher.getInstance("RSA", this.prov);
                }
                catch (Exception e) {
                    this.debug.exit("logic", className, "EncryptKey1", "Exception: " + e.getMessage());
                    throw new KeyManagerException(e.getMessage());
                }
                for (int i = 0; i < pubs.length; ++i) {
                    try {
                        cp.init(3, pubs[i]);
                        ekeys[i] = cp.wrap(dk);
                        continue;
                    }
                    catch (Exception e) {
                        this.debug.exit("logic", className, "EncryptKey2", "Exception: " + e.getMessage());
                        throw new KeyManagerException(e.getMessage());
                    }
                }
            }
        }
        try {
            cp = Cipher.getInstance("RSA", this.providerName);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "EncryptKey3", "Exception: " + e.getMessage());
            throw new KeyManagerException(e.getMessage());
        }
        for (int i = 0; i < pubs.length; ++i) {
            try {
                cp.init(3, pubs[i]);
                ekeys[i] = cp.wrap(dk);
                continue;
            }
            catch (Exception e) {
                this.debug.exit("logic", className, "EncryptKey4", "Exception: " + e.getMessage());
                throw new KeyManagerException(e.getMessage());
            }
        }
        return ekeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    SecretKey DecryptKey(byte[] data, PrivateKey priv, String algo) throws KeyManagerException {
        void var5_10;
        SecretKey dk;
        Cipher cp = null;
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    cp = Cipher.getInstance("RSA", this.prov);
                }
                catch (Exception e) {
                    this.debug.exit("logic", className, "DecryptKey1", "Exception: " + e.getMessage());
                    throw new KeyManagerException(e.getMessage());
                }
                try {
                    cp.init(4, priv);
                    dk = (SecretKey)cp.unwrap(data, algo, 3);
                }
                catch (Exception e) {
                    this.debug.exit("logic", className, "DecryptKey2", "Exception: " + e.getMessage());
                    throw new KeyManagerException(e.getMessage());
                }
            }
        }
        try {
            cp = Cipher.getInstance("RSA", this.providerName);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "DecryptKey3", "Exception: " + e.getMessage());
            throw new KeyManagerException(e.getMessage());
        }
        try {
            cp.init(4, priv);
            dk = (SecretKey)cp.unwrap(data, algo, 3);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "DecryptKey4", "Exception: " + e.getMessage());
            throw new KeyManagerException(e.getMessage());
        }
        return var5_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    RSAPublicKey KeyFactoryPublic(X509EncodedKeySpec spec) throws KeyManagerException {
        void var3_5;
        RSAPublicKey result;
        KeyFactory kf = null;
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    kf = KeyFactory.getInstance("RSA", this.prov);
                    result = (RSAPublicKey)kf.generatePublic(spec);
                }
                catch (Exception e) {
                    this.debug.exit("logic", className, "KeyFactoryPublic1", "Exception: " + e.getMessage());
                    throw new KeyManagerException(e.getMessage());
                }
            }
        }
        try {
            kf = KeyFactory.getInstance("RSA", this.providerName);
            result = (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "KeyFactoryPublic2", "Exception: " + e.getMessage());
            throw new KeyManagerException(e.getMessage());
        }
        return var3_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    SecretKey SecretKeyFactory(String algo, SecretKeySpec spec) throws KeyManagerException {
        void var4_6;
        SecretKey result;
        SecretKeyFactory skf = null;
        if (this.sync) {
            Provider provider = this.prov;
            synchronized (provider) {
                try {
                    skf = SecretKeyFactory.getInstance(algo, this.prov);
                    result = skf.generateSecret(spec);
                }
                catch (Exception e) {
                    this.debug.exit("logic", className, "SecretKeyFactory1", "Exception: " + e.getMessage());
                    throw new KeyManagerException(e.getMessage());
                }
            }
        }
        try {
            skf = SecretKeyFactory.getInstance(algo, this.providerName);
            result = skf.generateSecret(spec);
        }
        catch (Exception e) {
            this.debug.exit("logic", className, "SecretKeyFactory2", "Exception: " + e.getMessage());
            throw new KeyManagerException(e.getMessage());
        }
        return var4_6;
    }
}

