/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.drivetable.file;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTableEntry;
import com.ibm.keymanager.drivetable.DriveTableSpi;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class FileDriveTable
extends DriveTableSpi {
    private static Vector FileData;
    private static Hashtable TableData;
    public static final String DEFAULT_TABLE_FILE = "DT.dat";
    public static String urlString;
    private static Config DTconf;
    private Audit DTaudit;
    private String className = "com.ibm.keymanager.drivetable.file.FileDriveTable";
    private KMSDebug debug;

    public void init(Config conf, Audit audit) throws KeyManagerException {
        if (conf == null || audit == null) {
            throw new KeyManagerException("NULL Config or Audit not supported");
        }
        DTconf = conf;
        this.DTaudit = audit;
        this.debug = KMSDebug.getInstance();
        FileData = this.loadDriveTableFile();
        TableData = FileData != null ? this.parseTableData(FileData) : new Hashtable();
    }

    public DriveTableEntry createDriveEntry(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " createDriveEntry");
        }
        DriveTableEntry dte = new DriveTableEntry(DTconf, this.DTaudit);
        dte.init(WorldWideName, DriveSN, mapObjects);
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " createDriveEntry");
        }
        return dte;
    }

    public DriveTableEntry createDriveEntry(byte[] encoding) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " createDriveEntry");
        }
        DriveTableEntry dte = new DriveTableEntry(DTconf, this.DTaudit);
        dte.init(encoding);
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " createDriveEntry");
        }
        return dte;
    }

    public void modifyDriveEntry(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        String key;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " modifyDriveEntry");
        }
        if (DriveSN == null) {
            throw new KeyManagerException("NULL DriveSN not supported");
        }
        try {
            key = new String(DriveSN, "8859_1");
        }
        catch (Exception exc) {
            key = new String(DriveSN);
        }
        if (!TableData.containsKey(key)) {
            throw new KeyManagerException("Drive Entry does not exist");
        }
        DriveTableEntry dte = (DriveTableEntry)TableData.get(key);
        if (dte.isDeleted()) {
            throw new KeyManagerException("Deleted Entries cannot be modified");
        }
        if (WorldWideName != null) {
            dte.setWWName(WorldWideName);
        }
        if (mapObjects != null) {
            Iterator mapIterator = mapObjects.entrySet().iterator();
            while (mapIterator.hasNext()) {
                Map.Entry entry = mapIterator.next();
                if (!dte.isValidEntryType((String)entry.getKey())) continue;
                dte.setObject((String)entry.getKey(), entry.getValue());
            }
        }
        TableData.remove(key);
        TableData.put(key, dte);
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " modifyDriveEntry");
        }
    }

    public DriveTableEntry fetchDriveEntry(byte[] DriveSN, Map comparisonObjects) throws KeyManagerException {
        String key;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " fetchDriveEntry");
        }
        if (DriveSN == null) {
            throw new KeyManagerException("NULL DriveSN not supported");
        }
        try {
            key = new String(DriveSN, "8859_1");
        }
        catch (Exception exc) {
            key = new String(DriveSN);
        }
        if (!TableData.containsKey(key)) {
            return null;
        }
        DriveTableEntry dte = (DriveTableEntry)TableData.get(key);
        if (comparisonObjects != null) {
            Iterator mapIterator = comparisonObjects.entrySet().iterator();
            boolean equals = false;
            while (mapIterator.hasNext()) {
                Map.Entry entry = mapIterator.next();
                if (!dte.isValidEntryType((String)entry.getKey())) continue;
                if (entry.getValue() == dte.getObject((String)entry.getKey())) {
                    equals = true;
                    continue;
                }
                equals = false;
            }
            if (equals) {
                return dte;
            }
            return null;
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " fetchDriveEntry");
        }
        return dte;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDriveEntry(DriveTableEntry newEntry) throws KeyManagerException {
        void var2_2;
        String key;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " saveDriveEntry");
        }
        if (newEntry == null) {
            throw new KeyManagerException("NULL Drive Table Entry not supported");
        }
        if (newEntry.getSN() == null) throw new KeyManagerException("NULL Drive SN");
        try {
            key = new String(newEntry.getSN(), "8859_1");
        }
        catch (Exception exc) {
            key = new String(newEntry.getSN());
        }
        if (TableData.containsKey(var2_2)) {
            DriveTableEntry dte = (DriveTableEntry)TableData.get(var2_2);
            if (!dte.isDeleted()) throw new KeyManagerException("Drive Table Entry already exists in the Table");
            TableData.remove(var2_2);
            newEntry.setUpdated();
            TableData.put(var2_2, newEntry);
        } else {
            TableData.put(var2_2, newEntry);
        }
        if (!this.debug.isOn("drivetable")) return;
        this.debug.exit("drivetable", this.className, " saveDriveEntry");
    }

    public boolean driveExists(byte[] DriveSN, Map comparisonObjects) throws KeyManagerException {
        String key;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " driveExists");
        }
        if (DriveSN == null) {
            return false;
        }
        try {
            key = new String(DriveSN, "8859_1");
        }
        catch (Exception exc) {
            key = new String(DriveSN);
        }
        if (!TableData.containsKey(key)) {
            return false;
        }
        DriveTableEntry dte = (DriveTableEntry)TableData.get(key);
        if (comparisonObjects != null) {
            Iterator mapIterator = comparisonObjects.entrySet().iterator();
            boolean equals = false;
            while (mapIterator.hasNext()) {
                Map.Entry entry = mapIterator.next();
                if (!dte.isValidEntryType((String)entry.getKey())) continue;
                if (entry.getValue() == dte.getObject((String)entry.getKey())) {
                    equals = true;
                    continue;
                }
                equals = false;
            }
            return equals;
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " driveExists");
        }
        return true;
    }

    public DriveTableEntry queryDriveEntry(Map mapObjects) throws KeyManagerException {
        return null;
    }

    public Enumeration fetchAllDriveEntries() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " fetchAllDriveEntries");
        }
        if (TableData != null) {
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, " fetchAllDriveEntries");
            }
            return TableData.elements();
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " fetchAllDriveEntries");
        }
        return null;
    }

    public void deleteDriveEntry(byte[] DriveSN) throws KeyManagerException {
        String key;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " deleteDriveEntry");
        }
        if (DriveSN == null) {
            return;
        }
        try {
            key = new String(DriveSN, "8859_1");
        }
        catch (Exception exc) {
            key = new String(DriveSN);
        }
        if (!TableData.containsKey(key)) {
            throw new KeyManagerException("Drive Entry does not exist");
        }
        DriveTableEntry dte = (DriveTableEntry)TableData.get(key);
        dte.setDeleted();
        TableData.remove(key);
        TableData.put(key, dte);
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " deleteDriveEntry");
        }
    }

    public byte[] export() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " export");
        }
        try {
            ByteArrayOutputStream bto = new ByteArrayOutputStream();
            Enumeration eData = TableData.elements();
            while (eData.hasMoreElements()) {
                DriveTableEntry dte = (DriveTableEntry)eData.nextElement();
                byte[] bData = dte.exportData();
                bto.write(bData.length);
                bto.write(bData);
            }
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, " export");
            }
            return bto.toByteArray();
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc);
        }
    }

    public void mergeTable(byte[] tableData) throws KeyManagerException {
        Hashtable mergeTable;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " mergeTable");
        }
        if (tableData == null) {
            throw new KeyManagerException("NULL input data");
        }
        try {
            ByteArrayInputStream bti = new ByteArrayInputStream(tableData);
            Vector<DriveTableEntry> v = new Vector<DriveTableEntry>();
            while (bti.available() > 0) {
                int inLength = bti.read();
                byte[] inData = new byte[inLength];
                bti.read(inData);
                DriveTableEntry dti = this.createDriveEntry(inData);
                if (this.debug.isOn("drivetable")) {
                    this.debug.trace("drivetable", this.className, "mergeTable", "Adding Drive Element:" + dti.toEntryString());
                }
                v.add(dti);
            }
            mergeTable = this.parseTableData(v);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc);
        }
        if (mergeTable != null) {
            if (this.debug.isOn("drivetable")) {
                this.debug.trace("drivetable", this.className, "mergeTable", "Input Table Start parsing");
            }
            Enumeration keys = mergeTable.keys();
            while (keys.hasMoreElements()) {
                DriveTableEntry dte;
                String key = (String)keys.nextElement();
                if (this.debug.isOn("drivetable")) {
                    this.debug.trace("drivetable", this.className, "mergeTable", "Key:" + key);
                }
                if (!TableData.containsKey(key)) {
                    dte = (DriveTableEntry)mergeTable.get(key);
                    if (dte.isDeleted()) continue;
                    TableData.put(key, dte);
                    continue;
                }
                dte = (DriveTableEntry)mergeTable.get(key);
                DriveTableEntry dteCurrent = (DriveTableEntry)TableData.get(key);
                if (dte.isDeleted()) {
                    if (this.debug.isOn("drivetable")) {
                        this.debug.trace("drivetable", this.className, "mergeTable", "adding a deleted entry");
                    }
                    dteCurrent = (DriveTableEntry)TableData.get(key);
                    dteCurrent.setDeleted();
                    TableData.remove(key);
                    TableData.put(key, dteCurrent);
                    continue;
                }
                if (!dte.isUpdated()) continue;
                if (this.debug.isOn("drivetable")) {
                    this.debug.trace("drivetable", this.className, "mergeTable", "checking an updated entry");
                    this.debug.trace("drivetable", this.className, "mergeTable", "old TimeStamp: " + dteCurrent.getTimeStamp());
                    this.debug.trace("drivetable", this.className, "mergeTable", "new TimeStamp: " + dte.getTimeStamp());
                }
                if (!dte.getTimeStamp().after(dteCurrent.getTimeStamp())) continue;
                TableData.remove(key);
                TableData.put(key, dte);
            }
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " mergeTable");
        }
    }

    public void overrideTable(byte[] tableData) throws KeyManagerException {
        Hashtable overrideTable;
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " overrideTable");
        }
        if (tableData == null) {
            throw new KeyManagerException("NULL input data");
        }
        try {
            ByteArrayInputStream bti = new ByteArrayInputStream(tableData);
            Vector<DriveTableEntry> v = new Vector<DriveTableEntry>();
            while (bti.available() > 0) {
                int inLength = bti.read();
                byte[] inData = new byte[inLength];
                bti.read(inData);
                DriveTableEntry dti = this.createDriveEntry(inData);
                v.add(dti);
            }
            overrideTable = this.parseTableData(v);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc);
        }
        if (overrideTable != null) {
            TableData = overrideTable;
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " overrideTable");
        }
    }

    public void refresh(Config conf, Audit audit) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " refresh");
        }
        if (conf != null) {
            DTconf = conf;
        }
        if (audit != null) {
            this.DTaudit = audit;
        }
        this.debug = KMSDebug.getInstance();
        try {
            if (TableData.size() >= 1) {
                this.saveTableFile();
            }
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " refresh");
        }
    }

    public void shutdown() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " shutdown");
        }
        try {
            if (TableData.size() >= 1) {
                this.saveTableFile();
            }
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " shutdown");
        }
    }

    private Vector loadDriveTableFile() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " loadDriveTableFile");
        }
        try {
            final String fileName = this.getFileName();
            FileInputStream inputData = null;
            if (!new File(fileName).exists()) {
                return null;
            }
            if (!fileName.equals("")) {
                inputData = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileInputStream(fileName);
                    }
                });
            }
            if (inputData == null) {
                return null;
            }
            DataInputStream dataIn = new DataInputStream(inputData);
            Vector<DriveTableEntry> v = new Vector<DriveTableEntry>();
            while (dataIn.available() >= 1) {
                int length = dataIn.readInt();
                byte[] dataBytes = new byte[length];
                dataIn.read(dataBytes);
                DriveTableEntry dti = this.createDriveEntry(dataBytes);
                v.add(dti);
            }
            inputData.close();
            if (this.debug.isOn("drivetable")) {
                this.debug.exit("drivetable", this.className, " loadDriveTableFile");
            }
            return v;
        }
        catch (Exception e) {
            throw new KeyManagerException(e.toString());
        }
    }

    private synchronized void saveTableFile() throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " saveTableFile");
        }
        try {
            final String fileName = this.getFileName();
            BufferedOutputStream bo = null;
            File tabFile = new File(fileName);
            File tabFileBK = new File(fileName + ".backup");
            if (!tabFileBK.exists()) {
                try {
                    tabFileBK.createNewFile();
                }
                catch (IOException ex) {
                    File tmp = tabFileBK.getAbsoluteFile().getParentFile();
                    if (!tmp.exists()) {
                        if (!tmp.mkdirs()) {
                            throw new KeyManagerException("DriveTable File " + fileName + " can not be created");
                        }
                    } else {
                        throw (KeyManagerException)new KeyManagerException().initCause(ex);
                    }
                    try {
                        tabFileBK.createNewFile();
                    }
                    catch (IOException ex1) {
                        throw (KeyManagerException)new KeyManagerException().initCause(ex1);
                    }
                }
            }
            bo = new BufferedOutputStream((FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileOutputStream(fileName + ".backup");
                }
            }));
            Enumeration data = TableData.elements();
            while (data.hasMoreElements()) {
                try {
                    ByteArrayOutputStream bto = new ByteArrayOutputStream();
                    DataOutputStream dataOut = new DataOutputStream(bto);
                    DriveTableEntry entry = (DriveTableEntry)data.nextElement();
                    if (!entry.isDeleted()) {
                        byte[] dataBytes = entry.exportData();
                        dataOut.writeInt(dataBytes.length);
                        dataOut.write(dataBytes);
                    }
                    bo.write(bto.toByteArray());
                    bo.flush();
                }
                catch (Exception exc) {
                    throw new KeyManagerException(exc);
                }
            }
            bo.close();
            if (tabFile.exists()) {
                tabFile.delete();
            }
            tabFileBK.renameTo(tabFile);
        }
        catch (Exception e) {
            throw new KeyManagerException("Drive Table corrupt or invalid");
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " saveTableFile");
        }
    }

    private String getFileName() throws Exception {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " getFileName");
        }
        String name = null;
        urlString = (String)DTconf.get("config.drivetable.file.url");
        if (urlString != null) {
            try {
                name = new URL(urlString).getFile();
            }
            catch (Exception exc) {
                name = null;
            }
            return name;
        }
        if (name != null && new File(name).exists()) {
            return name;
        }
        String osname = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        });
        name = osname.startsWith("Windows") ? "C:\\Program Files\\IBM\\KeyManagementServer\\DT.dat" : (osname.startsWith("Linux") ? "/var/IBM/KeyManagementServer/DT.dat" : "/var/IBM/KeyManagementServer/DT.dat");
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " getFileName");
        }
        return name;
    }

    private Hashtable parseTableData(Vector v) throws KeyManagerException {
        if (this.debug.isOn("drivetable")) {
            this.debug.entry("drivetable", this.className, " parseTableData");
        }
        Hashtable<String, DriveTableEntry> table = new Hashtable<String, DriveTableEntry>();
        if (v == null) {
            return table;
        }
        for (int i = 0; i < v.size(); ++i) {
            String key;
            DriveTableEntry entry = (DriveTableEntry)v.elementAt(i);
            try {
                key = new String(entry.getSN(), "8859_1");
            }
            catch (Exception exc) {
                key = new String(entry.getSN());
            }
            if (this.debug.isOn("drivetable")) {
                this.debug.trace("drivetable", this.className, "parseTableData", "Adding Key:" + key);
            }
            table.put(key, entry);
        }
        if (this.debug.isOn("drivetable")) {
            this.debug.exit("drivetable", this.className, " parseTableData");
        }
        return table;
    }
}

