/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.drivetable;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTableEntry;
import com.ibm.keymanager.drivetable.DriveTableSpi;
import java.util.Enumeration;
import java.util.Map;

public class DriveTable {
    private static Config conf = null;
    private static Audit audit = null;
    private static DriveTable instance;
    private DriveTableSpi dt = null;

    private DriveTable(String driveClass) throws KeyManagerException {
        this.dt = this.loadDriveTable(driveClass);
        this.init(conf, audit);
    }

    public static synchronized DriveTable getInstance(Config config, Audit aud, String type) throws KeyManagerException {
        if (config == null) {
            throw new KeyManagerException("Null config object");
        }
        if (aud == null) {
            throw new KeyManagerException("Null Audit object");
        }
        conf = config;
        audit = aud;
        String driveClass = (String)conf.get("config.drivetable.provider");
        if (driveClass == null) {
            driveClass = "com.ibm.keymanager.drivetable.file.FileDriveTable";
        }
        if (instance != null) {
            return instance;
        }
        instance = new DriveTable(driveClass);
        return instance;
    }

    public synchronized void init() throws KeyManagerException {
        this.dt.init(conf, audit);
    }

    public synchronized DriveTableEntry createDriveEntry(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        return this.dt.createDriveEntry(WorldWideName, DriveSN, mapObjects);
    }

    public synchronized DriveTableEntry createDriveEntry(byte[] encoding) throws KeyManagerException {
        return this.dt.createDriveEntry(encoding);
    }

    public synchronized Enumeration fetchAllDriveEntries() throws KeyManagerException {
        return this.dt.fetchAllDriveEntries();
    }

    public synchronized void deleteDriveEntry(byte[] DriveSN) throws KeyManagerException {
        this.dt.deleteDriveEntry(DriveSN);
    }

    public synchronized byte[] export() throws KeyManagerException {
        return this.dt.export();
    }

    public synchronized void mergeTable(byte[] tableData) throws KeyManagerException {
        this.dt.mergeTable(tableData);
    }

    public synchronized void overrideTable(byte[] tableData) throws KeyManagerException {
        this.dt.overrideTable(tableData);
    }

    public synchronized void refresh(Config conf, Audit audit) throws KeyManagerException {
        this.dt.refresh(conf, audit);
    }

    public synchronized void shutdown() throws KeyManagerException {
        this.dt.shutdown();
        instance = null;
    }

    private DriveTableSpi loadDriveTable(String className) throws KeyManagerException {
        try {
            return this.loadClass(className);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    private DriveTableSpi loadClass(String className) throws Exception {
        Class<?> implementation = null;
        ClassLoader loader = null;
        implementation = loader == null ? Class.forName(className) : loader.loadClass(className);
        return (DriveTableSpi)implementation.newInstance();
    }

    public synchronized void init(Config conf, Audit aud) throws KeyManagerException {
        this.dt.init(conf, audit);
    }

    public synchronized void modifyDriveEntry(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        this.dt.modifyDriveEntry(WorldWideName, DriveSN, mapObjects);
    }

    public synchronized DriveTableEntry fetchDriveEntry(byte[] DriveSN, Map comparisonObjects) throws KeyManagerException {
        return this.dt.fetchDriveEntry(DriveSN, comparisonObjects);
    }

    public synchronized void saveDriveEntry(DriveTableEntry newEntry) throws KeyManagerException {
        this.dt.saveDriveEntry(newEntry);
    }

    public synchronized boolean driveExists(byte[] DriveSN, Map comparisonObjects) throws KeyManagerException {
        return this.dt.driveExists(DriveSN, comparisonObjects);
    }

    public synchronized DriveTableEntry queryDriveEntry(Map mapObjects) throws KeyManagerException {
        return this.dt.queryDriveEntry(mapObjects);
    }
}

