/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.config;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConfigImpl
extends Config {
    private static final String WINCONFFILE = "C:/Program Files/IBM/KeyManagerServer/KeyManagerConfig.properties";
    private static final String IXCONFFILE = "/opt/ibm/KeyManagerServer/KeyManagerConfig.properties";
    private static KMSDebug debug = null;
    private static String className = "com.ibm.keymanger.config.ConfigImpl";
    private static ConfigImpl configInstance = new ConfigImpl();
    private static Hashtable configInMemory = new Hashtable(25);
    private static Properties p = new Properties();
    private static FileInputStream fis = null;
    private static FileOutputStream fos = null;
    private static String configFile = null;

    public void init() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry("config", className, "init");
        String os = System.getProperty("os.name");
        debug.trace("config", className, "init", os);
        if (os.toUpperCase().indexOf("WIN") != -1) {
            debug.trace("config", className, "init", "WINDOWS IT IS!");
            ConfigImpl.load(WINCONFFILE);
        } else if (os.toUpperCase().indexOf("X") != -1) {
            debug.trace("config", className, "init", os + " IT IS!");
            ConfigImpl.load(IXCONFFILE);
        } else {
            debug.trace("config", className, "init", os + " IT IS!");
            ConfigImpl.load(IXCONFFILE);
        }
        debug.exit("config", className, "init");
    }

    public void init(String confFile) throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry("config", className, "init");
        if (confFile != null) {
            ConfigImpl.load(confFile);
        } else {
            this.init();
        }
        debug.exit("config", className, "init");
    }

    public static void load(String confFile) throws KeyManagerException {
        debug.entry("config", className, "load");
        String loadFile = null;
        if (confFile == null) {
            String os = System.getProperty("os.name");
            if (os.toUpperCase().indexOf("WIN") != -1) {
                loadFile = WINCONFFILE;
                debug.trace("config", className, "init", "WINDOWS IT IS!");
            } else if (os.toUpperCase().indexOf("X") != -1) {
                loadFile = IXCONFFILE;
                debug.trace("config", className, "init", os + " IT IS!");
            }
            configFile = loadFile;
        } else {
            configFile = confFile;
        }
        try {
            debug.trace("config", className, "load", configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(e);
        }
        catch (IOException e2) {
            throw new KeyManagerException(e2);
        }
        ConfigImpl.buildConfig(p);
        debug.exit("config", className, "load");
    }

    public void add(String item, Object value) throws KeyManagerException {
        debug.entry("config", className, "add");
        try {
            if (item.toLowerCase().indexOf("password") == 0) {
                debug.trace("config", className, "add", item + " = " + value);
            }
            configInMemory.put(item, value);
        }
        catch (NullPointerException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "add");
    }

    public void delete(String item) throws KeyManagerException {
        debug.entry("config", className, "delete");
        try {
            if (item.toLowerCase().indexOf("password") == 0) {
                debug.trace("config", className, "delete", item);
            }
            configInMemory.remove(item);
        }
        catch (NullPointerException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "delete");
    }

    public void replace(String item, Object value) throws KeyManagerException {
        debug.entry("config", className, "replace");
        try {
            if (item.toLowerCase().indexOf("password") == 0) {
                debug.trace("config", className, "replace", item + " = " + value);
                debug.trace("config", className, "replace", item + " WAS " + configInMemory.get(item));
            }
            configInMemory.remove(item);
            configInMemory.put(item, value);
        }
        catch (NullPointerException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "replace");
    }

    public void reload() throws KeyManagerException {
        debug.entry("config", className, "reload");
        try {
            debug.trace("config", className, "reload", configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(e);
        }
        catch (IOException e2) {
            throw new KeyManagerException(e2);
        }
        configInMemory.clear();
        ConfigImpl.buildConfig(p);
        debug.exit("config", className, "reload");
    }

    public Hashtable get() {
        debug.entry("config", className, "get");
        Hashtable retTable = new Hashtable(configInMemory.size());
        Enumeration e = configInMemory.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            retTable.put(o, configInMemory.get(o));
        }
        debug.exit("config", className, "get");
        return retTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String item) throws KeyManagerException {
        debug.entry("config", className, "get");
        if (item == null) {
            return null;
        }
        Object value = null;
        try {
            value = configInMemory.get(item);
            if (item.toLowerCase().indexOf("password") == 0) {
                debug.trace("config", className, "get", item + " = " + value);
            }
        }
        catch (NullPointerException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "get");
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value;
    }

    public void shutdown() throws KeyManagerException {
        debug.entry("config", className, "shutdown");
        this.sync();
        debug.exit("config", className, "shutdown");
    }

    public void sync() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry("config", className, "sync");
        try {
            ConfigImpl.write();
        }
        catch (Exception e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "sync");
    }

    public void sync(Hashtable config) throws KeyManagerException {
        debug.entry("config", className, "sync");
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            configInMemory.put(item, config.get(item));
        }
        try {
            ConfigImpl.write();
        }
        catch (Exception ex) {
            throw new KeyManagerException(ex.getMessage());
        }
        debug.exit("config", className, "sync");
    }

    private static void buildConfig(Properties config) {
        debug.entry("config", className, "buildConfig");
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String item = (String)e.nextElement();
            String obj = null;
            obj = p.getProperty(item);
            int length = obj.toString().length();
            if (length >= 1) {
                if (item.toLowerCase().indexOf("password") == 0) {
                    debug.trace("config", className, "buildConfig", "updating " + item + " to " + obj);
                }
                configInMemory.put(item, obj);
                continue;
            }
            if (configInMemory.get(item) != null) continue;
            if (item.toLowerCase().indexOf("password") == 0) {
                debug.trace("config", className, "buildConfig", "VALUE NULL: " + item);
            }
            configInMemory.put(item, p.getProperty(item));
        }
        debug.exit("config", className, "buildConfig");
    }

    private static void mergeConfig(Properties config) {
        debug.entry("config", className, "mergeConfig");
        Enumeration<?> e = config.propertyNames();
        while (e.hasMoreElements()) {
            String item = (String)e.nextElement();
            String obj = null;
            obj = config.getProperty(item);
            int length = obj.toString().length();
            if (length >= 1) {
                configInMemory.put(item, obj);
                if (item.toLowerCase().indexOf("password") != 0) continue;
                debug.trace("config", className, "mergeConfig", "updating " + item + " to " + obj);
                continue;
            }
            if (configInMemory.get(item) != null) continue;
            debug.trace("config", className, "mergeConfig", "VALUE NULL: " + item);
            configInMemory.put(item, p.getProperty(item));
        }
        debug.exit("config", className, "mergeConfig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void write() throws Exception {
        String confFile = configFile;
        debug.entry("config", className, "write");
        String string = configFile;
        synchronized (string) {
            debug.trace("config", className, "write", confFile);
            File confFileF = new File(confFile);
            File confFileFBK = new File(confFile + ".backup");
            if (!confFileFBK.exists()) {
                try {
                    confFileFBK.createNewFile();
                }
                catch (IOException ex) {
                    File tmp = confFileFBK.getAbsoluteFile().getParentFile();
                    if (!tmp.exists()) {
                        if (!tmp.mkdirs()) {
                            throw new KeyManagerException("Configuration File " + confFile + " can not be created");
                        }
                    } else {
                        throw (KeyManagerException)new KeyManagerException().initCause(ex);
                    }
                    try {
                        confFileFBK.createNewFile();
                    }
                    catch (IOException ex1) {
                        throw (KeyManagerException)new KeyManagerException().initCause(ex1);
                    }
                }
            }
            fos = new FileOutputStream(confFileFBK);
            Enumeration e = configInMemory.keys();
            Object value = null;
            while (e.hasMoreElements()) {
                value = e.nextElement();
                String data = value + " = " + configInMemory.get(value) + "\n";
                if (data.toLowerCase().indexOf("password") == 0) {
                    debug.trace("config", className, "write", "" + data);
                }
                if (configInMemory.get(value) == null) continue;
                fos.write(data.getBytes());
                fos.flush();
            }
            fos.close();
            if (confFileF.exists()) {
                confFileF.delete();
            }
            confFileFBK.renameTo(confFileF);
        }
        debug.exit("config", className, "write");
    }

    public void write(String fileName) throws KeyManagerException {
        debug.entry("config", className, "write");
        try {
            String savedFile = configFile;
            configFile = fileName;
            ConfigImpl.write();
            configFile = savedFile;
        }
        catch (Exception e) {
            throw new KeyManagerException(e);
        }
        debug.entry("config", className, "write");
    }

    public void merge(File fileName) throws KeyManagerException {
        Hashtable mergeConfig = new Hashtable(25);
        debug.entry("config", className, "merge");
        if (fileName == null) {
            return;
        }
        try {
            p = new Properties();
            fis = new FileInputStream(fileName);
            p.load(fis);
            ConfigImpl.mergeConfig(p);
            fis.close();
        }
        catch (IOException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "merge");
    }

    public void load(File fileName) throws KeyManagerException {
        debug.entry("config", className, "load");
        if (fileName == null) {
            return;
        }
        try {
            debug.trace("config", className, "load", fileName.getName());
            p = new Properties();
            fis = new FileInputStream(fileName);
            p.load(fis);
            ConfigImpl.buildConfig(p);
            fis.close();
        }
        catch (IOException e) {
            throw new KeyManagerException(e);
        }
        debug.exit("config", className, "load");
    }

    public Enumeration list() {
        debug.entry("config", className, "list");
        debug.exit("config", className, "list");
        return configInMemory.keys();
    }
}

