/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.SecurityEventHandlerSpi;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.config.Config;

class SecurityEventHandler {
    private SecurityEventHandlerSpi handler;

    protected SecurityEventHandler(SecurityEventHandlerSpi spi) {
        this.handler = spi;
    }

    public static SecurityEventHandler getInstance(String providerClass) throws KeyManagerException {
        Class<?> classObj = null;
        try {
            classObj = Class.forName(providerClass);
        }
        catch (ClassNotFoundException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        Object obj = null;
        try {
            obj = classObj.newInstance();
        }
        catch (InstantiationException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        if (obj instanceof SecurityEventHandlerSpi) {
            return new SecurityEventHandler(obj);
        }
        throw new KeyManagerException("The instantiated object is not instance of SecurityEventHandlerSpi");
    }

    public void init(Config kmconfig) throws KeyManagerException {
        this.handler.init(kmconfig);
    }

    public void handleEvents(Security_Event[] events) throws KeyManagerException {
        this.handler.handleEvents(events);
    }

    public void handleEvent(Security_Event event) throws KeyManagerException {
        this.handler.handleEvent(event);
    }

    public String getType() {
        return this.handler.getType();
    }

    public void shutdown() {
        this.handler.shutdown();
    }

    public void refresh(Config config) {
        this.handler.refresh(config);
    }
}

