/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class Authn_Event
implements Security_Event {
    public static final String AUTHN_SSL = "SSL";
    public static final String AUTHN_BASIC_AUTH = "BasicAuthn";
    public static final String AUTHN_TOKEN_USERNAME = "TokenUserName";
    private Object source;
    private String authnType;
    private UserInfo[] users;
    private AuditOutcomeType outcome;
    private String message;
    private Date timestamp;

    public Authn_Event(Object source, String authn_type, String user_name, boolean outcome) {
        this.source = source;
        this.authnType = authn_type;
        this.users = new UserInfo[]{new UserInfo(user_name)};
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public Authn_Event(Object source, String authn_type, UserInfo user, AuditOutcomeType outcome) {
        this.source = source.getClass().getName();
        this.authnType = authn_type;
        this.users = new UserInfo[]{user};
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public Authn_Event(Object source, String authn_type, UserInfo[] users, AuditOutcomeType outcome) {
        this.source = source.getClass().getName();
        this.authnType = authn_type;
        this.users = users;
        this.outcome = outcome;
    }

    public UserInfo[] getUsers() {
        return this.users;
    }

    public String getAuthnType() {
        return this.authnType;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_AUTHN";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Authentication event:[");
        sb.append("\n  timestamp=" + this.timestamp.toString());
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome);
        sb.append("\n  event type=SECURITY_AUTHN");
        if (this.message != null) {
            sb.append("\n message=" + this.message);
        }
        sb.append("\n  anthentication type=" + this.authnType);
        String users = this.users[0].toString();
        for (int i = 1; i < this.users.length; ++i) {
            users = users + "," + this.users[i].toString();
        }
        sb.append("\n  users=" + users);
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

