/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.UserInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class AdminInfo
extends UserInfo {
    private String registryUserName = "Not Available";
    private String userName;
    private HashMap location;
    private HashMap attributes;
    private String domain;
    private Long uuid;

    public AdminInfo(String name) {
        this.userName = name;
    }

    public AdminInfo(String name, String nameInRegistry) {
        this.userName = name;
        this.registryUserName = nameInRegistry;
    }

    public void setLocation(String type, String location) {
        if (location == null) {
            this.location = new HashMap();
        }
        this.location.put(type, location);
    }

    public String getLocation(String type) {
        if (this.location != null) {
            return (String)this.location.get(type);
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Set getAttributeNames() {
        if (this.attributes != null) {
            return Collections.unmodifiableSet(this.attributes.keySet());
        }
        return null;
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return (String)this.attributes.get(name);
        }
        return null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRegistryUserName() {
        return this.registryUserName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setUniqueId(Long uuid) {
        this.uuid = uuid;
    }

    public Long getUniqueId() {
        return this.uuid;
    }

    public String toString() {
        String value;
        String key;
        Iterator it;
        Set keyset;
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("name=" + this.userName);
        if (this.registryUserName != "Not Available") {
            sb.append(";registry user name=" + this.registryUserName);
        }
        if (this.domain != null) {
            sb.append(";domain=" + this.domain);
        }
        if (this.uuid != null) {
            String uuidst = this.uuid.toString();
            sb.append(";uuid=" + uuidst);
        }
        if (this.location != null) {
            keyset = this.location.keySet();
            it = keyset.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)this.location.get(key);
                sb.append(";" + key + "=" + value);
            }
        }
        if (this.attributes != null) {
            keyset = this.attributes.keySet();
            it = keyset.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)this.attributes.get(key);
                sb.append(";" + key + "=" + value);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

