/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ListenerThread;
import com.ibm.keymanager.ProcessorThread;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportListener;
import com.ibm.keymanager.transport.TransportThread;
import java.util.Enumeration;
import java.util.Vector;

public class ThreadManager {
    private static final int MAX_THREAD_CLEANUP = 95;
    private static final long MAX_AVAILABLE = 100L;
    private static ThreadManager instance;
    private String progName;
    private Vector listenerThreads;
    private Vector processorThreads;
    private static Vector transportThreads;
    private ThreadGroup listenerThreadGroup;
    private ThreadGroup processorThreadGroup;
    private ThreadGroup transportThreadGroup;
    private Config conf;
    private KMSDebug debug;
    private ServerParameters params;
    private final Semaphore workers = new FairSemaphore(100L);
    private static final String className = "com.ibm.keymanager.ThreadManager";

    private ThreadManager(ServerParameters parms, String progName) throws KeyManagerException {
        if (parms == null) {
            throw new KeyManagerException("Null Server Parameters object");
        }
        if (progName == null) {
            throw new KeyManagerException("Null Program Name object");
        }
        try {
            this.listenerThreadGroup = new ThreadGroup(progName + "-Listeners");
            this.processorThreadGroup = new ThreadGroup(progName + "-Processors");
            this.transportThreadGroup = new ThreadGroup(progName + "-Transport");
            this.listenerThreads = new Vector();
            this.processorThreads = new Vector();
            transportThreads = new Vector();
            this.params = parms;
            this.conf = parms.getConfig();
            this.debug = parms.getDebug();
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    public static synchronized ThreadManager getInstance(ServerParameters parms, String progName) throws KeyManagerException {
        if (instance != null) {
            return instance;
        }
        instance = new ThreadManager(parms, progName);
        return instance;
    }

    public void startListenerThreads() throws KeyManagerException {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " startListenerThreads");
        }
        String SSLClassname = null;
        String TCPClassname = null;
        try {
            SSLClassname = (String)this.conf.get("TransportListener.ssl.class");
            TCPClassname = (String)this.conf.get("TransportListener.tcp.class");
            if (SSLClassname == null) {
                SSLClassname = "com.ibm.keymanager.transport.ssl.SSLListener";
            }
            ListenerThread SSLthread = new ListenerThread(this, SSLClassname, this.conf);
            this.listenerThreads.add(SSLthread);
            if (TCPClassname == null) {
                TCPClassname = "com.ibm.keymanager.transport.tcp.TCPListener";
            }
            ListenerThread TCPthread = new ListenerThread(this, TCPClassname, this.conf);
            this.listenerThreads.add(TCPthread);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
        Enumeration enums = this.listenerThreads.elements();
        while (enums.hasMoreElements()) {
            ListenerThread lthread = (ListenerThread)enums.nextElement();
            try {
                lthread.getThread().start();
                this.getStatus(lthread.getListener());
            }
            catch (KeyManagerException exc) {
                throw exc;
            }
            catch (Exception exc) {
                throw new KeyManagerException(exc.toString());
            }
        }
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " startListenerThreads");
        }
    }

    private synchronized void getStatus(TransportListener t) throws KeyManagerException {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.getStatus() != 1) {
            throw new KeyManagerException("Listener thread is not up and running");
        }
    }

    public ProcessorThread startProcessorThread(Transport transport, ServerParameters parms, boolean admin) throws KeyManagerException {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " startProcessorThread");
        }
        if (this.processorThreads.size() >= 95) {
            this.cleanUp();
        }
        ProcessorThread pthread = new ProcessorThread(this, transport, parms, admin);
        this.processorThreads.add(pthread);
        try {
            this.workers.acquire();
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        pthread.getThread().start();
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " startProcessorThread");
        }
        return pthread;
    }

    public TransportThread startTransportThread() {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " startTransportThread");
        }
        if (transportThreads.size() >= 95) {
            this.cleanUp();
        }
        TransportThread tthread = new TransportThread();
        transportThreads.add(tthread);
        try {
            this.workers.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " startTransportThread");
        }
        return tthread;
    }

    public void addThread(TransportThread thread) throws KeyManagerException {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " addThread");
        }
        transportThreads.add(thread);
        try {
            this.workers.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread.start();
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " addThread");
        }
    }

    public void destroyProcessorThread(ProcessorThread processorThread) {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " destroyProcessorThread");
        }
        if (!processorThread.getThread().isAlive()) {
            if (processorThread.getProcessor() != null) {
                processorThread.getProcessor().dispose();
            } else {
                processorThread.getAdminProcessor().dispose();
            }
            this.processorThreads.remove(processorThread);
            this.workers.release();
        }
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " destroyProcessorThread");
        }
    }

    public void destroyTransportThread(TransportThread transThread) {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " destroyTransportThread");
        }
        if (!transThread.isAlive()) {
            transThread.destroy();
            transportThreads.remove(transThread);
            this.workers.release();
        }
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " destroyTransportThread");
        }
    }

    public void shutdown() {
        int i;
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " shutdown");
        }
        Enumeration enumPThreads = this.processorThreads.elements();
        Enumeration listThreads = this.listenerThreads.elements();
        Enumeration transThreads = transportThreads.elements();
        if (this.debug.isOn("server")) {
            this.debug.trace("server", className, "shutdown", "shuting down processor threads");
        }
        while (enumPThreads.hasMoreElements()) {
            ProcessorThread testThread = (ProcessorThread)enumPThreads.nextElement();
            if (testThread.getProcessor() != null) {
                if (this.debug.isOn("server")) {
                    this.debug.trace("server", className, "shutdown", "shuting down a processor thread");
                }
                testThread.getProcessor().dispose();
                continue;
            }
            if (this.debug.isOn("server")) {
                this.debug.trace("server", className, "shutdown", "shuting down an admin thread");
            }
            testThread.getAdminProcessor().dispose();
        }
        for (i = 0; i < this.processorThreads.size(); ++i) {
            this.workers.release();
        }
        this.processorThreads.removeAllElements();
        if (this.debug.isOn("server")) {
            this.debug.trace("server", className, "shutdown", "shuting down listener threads");
        }
        while (listThreads.hasMoreElements()) {
            ListenerThread testListThread = (ListenerThread)listThreads.nextElement();
            try {
                if (this.debug.isOn("server")) {
                    this.debug.trace("server", className, "shutdown", "shutting down  a listener thread");
                }
                testListThread.getListener().shutdown();
            }
            catch (Exception exc) {
                if (!this.debug.isOn("server")) continue;
                this.debug.trace("server", className, "shutdown", "error shutting down listenr thread: " + exc.getMessage());
            }
        }
        for (i = 0; i < this.listenerThreads.size(); ++i) {
            this.workers.release();
        }
        this.listenerThreads.removeAllElements();
        if (this.debug.isOn("server")) {
            this.debug.trace("server", className, "shutdown", "shuting down transport threads");
        }
        while (transThreads.hasMoreElements()) {
            if (this.debug.isOn("server")) {
                this.debug.trace("server", className, "shutdown", "shuting down  a transport thread");
            }
            TransportThread testTransThread = (TransportThread)transThreads.nextElement();
            testTransThread.destroy();
        }
        for (i = 0; i < transportThreads.size(); ++i) {
            this.workers.release();
        }
        transportThreads.removeAllElements();
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " shutdown");
        }
    }

    public void cleanUp() {
        if (this.debug.isOn("server")) {
            this.debug.entry("server", className, " cleanUp");
        }
        Enumeration enumPThreads = this.processorThreads.elements();
        Enumeration transThreads = transportThreads.elements();
        while (enumPThreads.hasMoreElements()) {
            ProcessorThread testThread = (ProcessorThread)enumPThreads.nextElement();
            if (testThread.getThread().isAlive()) continue;
            if (testThread.getProcessor() != null) {
                testThread.getProcessor().dispose();
            } else {
                testThread.getAdminProcessor().dispose();
            }
            this.processorThreads.remove(testThread);
            this.workers.release();
        }
        while (transThreads.hasMoreElements()) {
            TransportThread testTransThread = (TransportThread)transThreads.nextElement();
            if (testTransThread.isAlive()) continue;
            testTransThread.destroy();
            transportThreads.remove(testTransThread);
            this.workers.release();
        }
        if (this.debug.isOn("server")) {
            this.debug.exit("server", className, " cleanUp");
        }
    }

    public String getProgramName() {
        return this.progName;
    }

    public ThreadGroup getListenerThreadGroup() {
        return this.listenerThreadGroup;
    }

    public ThreadGroup getProcessorThreadGroup() {
        return this.processorThreadGroup;
    }

    public ThreadGroup getTransportThreadGroup() {
        return this.transportThreadGroup;
    }

    public ServerParameters getServerParameters() {
        return this.params;
    }

    public class FairSemaphore
    extends Semaphore {
        protected final WaitQueue queue = new WaitQueue();

        public FairSemaphore(long initialPermits) {
            super(initialPermits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            WaitNode node = null;
            FairSemaphore fairSemaphore = this;
            synchronized (fairSemaphore) {
                if (this.permits > 0L) {
                    --this.permits;
                    return;
                }
                node = new WaitNode();
                this.queue.enq(node);
            }
            node.doWait();
        }

        public synchronized void release() {
            WaitNode node;
            do {
                if ((node = this.queue.deq()) != null) continue;
                ++this.permits;
                return;
            } while (!node.doNotify());
        }

        protected class WaitQueue {
            protected WaitNode head = null;
            protected WaitNode last = null;

            protected WaitQueue() {
            }

            protected void enq(WaitNode node) {
                if (this.last == null) {
                    this.head = this.last = node;
                } else {
                    this.last.next = node;
                    this.last = node;
                }
            }

            protected WaitNode deq() {
                WaitNode node = this.head;
                if (node != null) {
                    this.head = node.next;
                    if (this.head == null) {
                        this.last = null;
                    }
                    node.next = null;
                }
                return node;
            }
        }

        protected class WaitNode {
            boolean released = false;
            WaitNode next = null;

            protected WaitNode() {
            }

            synchronized void doWait() throws InterruptedException {
                try {
                    while (!this.released) {
                        this.wait();
                    }
                }
                catch (InterruptedException exc) {
                    if (!this.released) {
                        this.released = true;
                        throw exc;
                    }
                    Thread.currentThread().interrupt();
                }
            }

            synchronized boolean doNotify() {
                if (this.released) {
                    return false;
                }
                this.released = true;
                this.notify();
                return true;
            }

            synchronized boolean doTimedwait(long msecs) throws InterruptedException {
                return true;
            }
        }
    }

    public class Semaphore {
        protected long permits;

        public Semaphore(long initialPermits) {
            this.permits = initialPermits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Semaphore semaphore = this;
            synchronized (semaphore) {
                try {
                    while (this.permits <= 0L) {
                        this.wait();
                    }
                    --this.permits;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Semaphore semaphore = this;
            synchronized (semaphore) {
                if (this.permits > 0L) {
                    --this.permits;
                    return true;
                }
                if (msecs <= 0L) {
                    return false;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    long waitTime = msecs;
                    do {
                        this.wait(waitTime);
                        if (this.permits <= 0L) continue;
                        --this.permits;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }

        public synchronized void release() {
            ++this.permits;
            this.notify();
        }

        public synchronized void release(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits += n;
            for (long i = 0L; i < n; ++i) {
                this.notify();
            }
        }

        public synchronized long permits() {
            return this.permits;
        }
    }
}

