/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.AdminProcessor;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.LogicProcessor;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.transport.Transport;

class ProcessorThread {
    private Thread thread;
    private LogicProcessor logicProc;
    private AdminProcessor adminProc;
    private ThreadManager threadManager;

    ProcessorThread(ThreadManager threadManager, Transport trans, ServerParameters parms, boolean admin) throws KeyManagerException {
        if (threadManager == null) {
            throw new KeyManagerException("No thread manager");
        }
        this.threadManager = threadManager;
        if (!admin) {
            this.logicProc = new LogicProcessor(trans, parms);
            this.thread = new Thread(threadManager.getProcessorThreadGroup(), this.logicProc);
        } else {
            this.adminProc = new AdminProcessor(trans, parms);
            this.thread = new Thread(threadManager.getProcessorThreadGroup(), this.adminProc);
        }
    }

    Thread getThread() {
        return this.thread;
    }

    AdminProcessor getAdminProcessor() {
        return this.adminProc;
    }

    LogicProcessor getProcessor() {
        return this.logicProc;
    }
}

