/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.util.CommandOptions;

public class KeyManagementServer {
    private static KeyManagementServer instance;
    private static ServerParameters parms;
    private static String configFileName;
    private static String keyStorePassword;
    private static String usageStr;
    private String progName = "KeyManagementServerV1";
    private ThreadManager threadManager;

    private KeyManagementServer() throws Exception {
    }

    static synchronized KeyManagementServer getInstance() throws Exception {
        if (instance != null) {
            return instance;
        }
        instance = new KeyManagementServer();
        parms = ServerParameters.getInstance(instance, configFileName, keyStorePassword);
        return instance;
    }

    public static ServerParameters getParameters() {
        if (parms != null) {
            return parms;
        }
        return null;
    }

    void processRequests() throws Exception {
        this.threadManager = ThreadManager.getInstance(parms, this.progName);
        this.threadManager.startListenerThreads();
    }

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("Starting the Key Management Server 1.0");
            KeyManagementServer.processArgs(args);
            final KeyManagementServer server = KeyManagementServer.getInstance();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        1 v0 = this;
                        KMSDebug dbg = v0.server.getParameters().getDebug();
                        1 v1 = this;
                        v1.server.getParameters().shutdownAll();
                        dbg.trace("server", "com.ibm.keymanager.KeyManagementServer", "main", "Shutdown Complete");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            try {
                server.processRequests();
            }
            catch (Exception ex) {
                server.shutdown();
                throw ex;
            }
        }
        catch (Exception exc) {
            throw exc;
        }
        finally {
            try {
                System.out.println("Processing");
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
    }

    private static void processArgs(String[] args) throws KeyManagerException {
        System.out.println("Processing Arguments");
        CommandOptions cmdopts = new CommandOptions(args, "?:F:P:", true);
        if (cmdopts.isSet('?')) {
            throw new KeyManagerException(usageStr);
        }
        String val = cmdopts.getValue('F');
        if (val == null) {
            throw new KeyManagerException(usageStr);
        }
        configFileName = val;
        val = cmdopts.getValue('P');
        if (val == null) {
            throw new KeyManagerException(usageStr);
        }
        keyStorePassword = val;
    }

    public void shutdown() {
        if (this.threadManager != null) {
            this.threadManager.shutdown();
        }
        instance = null;
    }

    static {
        usageStr = " [-?] [-F Config File] [-P Keystore Password] ";
    }
}

