/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.p;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncryptedData
implements Cloneable {
    int a;
    Integer b;
    byte[] c;
    byte[] d;
    public static final int ETYPE_NULL = 0;
    public static final int ETYPE_DES_CBC_CRC = 1;
    public static final int ETYPE_DES_CBC_MD4 = 2;
    public static final int ETYPE_DES_CBC_MD5 = 3;
    public static final int ETYPE_DES3_CBC_SHA1 = 16;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_128 = 17;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_256 = 18;
    public static final int KERB_ETYPE_RC4_HMAC = 23;
    public static final int KERB_ETYPE_RC4_HMAC_EXP = 24;
    private static String[] z;

    private EncryptedData() {
    }

    public Object clone() {
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.a = this.a;
        if (this.b != null) {
            encryptedData.b = new Integer(this.b);
        }
        if (this.c != null) {
            encryptedData.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, encryptedData.c, 0, this.c.length);
        }
        return encryptedData;
    }

    public EncryptedData(int n2, Integer n3, byte[] byArray) {
        this.a = n2;
        this.b = n3;
        this.c = byArray;
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray) throws KdcErrException, KrbCryptoException {
        p p2 = p.a(encryptionKey.getEType());
        this.c = p2.encrypt(byArray, encryptionKey.getBytes());
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, int n2) throws KdcErrException, KrbCryptoException {
        p p2 = p.a(encryptionKey.getEType());
        this.c = p2.encrypt(byArray, encryptionKey.getBytes(), n2);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, byte[] byArray2, int n2) throws KdcErrException, KrbCryptoException {
        p p2 = p.a(encryptionKey.getEType());
        this.c = p2.encrypt(byArray, encryptionKey.getBytes(), byArray2, n2);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, byte[] byArray2) throws KdcErrException, KrbCryptoException {
        p p2 = p.a(encryptionKey.getEType());
        this.c = p2.encrypt(byArray2, encryptionKey.getBytes(), byArray);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    EncryptedData(String string, byte[] byArray) throws KdcErrException, KrbCryptoException {
        EncryptionKey encryptionKey = new EncryptionKey(string);
        p p2 = p.a(encryptionKey.getEType());
        this.c = p2.encrypt(byArray, encryptionKey.getBytes());
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public byte[] decrypt(EncryptionKey encryptionKey) throws KdcErrException, KrbApErrException, KrbCryptoException {
        p p2 = p.a(this.a);
        p2.decrypt(this.c, encryptionKey.getBytes());
        this.d = this.c;
        this.c = null;
        return p2.decryptedData(this.d);
    }

    public byte[] decrypt(EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        p p2 = p.a(this.a);
        p2.decrypt(this.c, encryptionKey.getBytes(), n2);
        this.d = this.c;
        this.c = null;
        return p2.decryptedData(this.d);
    }

    public byte[] decrypt(EncryptionKey encryptionKey, byte[] byArray) throws KdcErrException, KrbApErrException, KrbCryptoException {
        p p2 = p.a(this.a);
        p2.decrypt(this.c, encryptionKey.getBytes(), byArray);
        this.d = this.c;
        this.c = null;
        return p2.decryptedData(this.d);
    }

    byte[] a(String string) throws KdcErrException, KrbApErrException, KrbCryptoException {
        EncryptionKey encryptionKey = new EncryptionKey(string);
        p p2 = p.a(this.a);
        p2.decrypt(this.c, encryptionKey.getBytes());
        this.d = this.c;
        this.c = null;
        return p2.decryptedData(this.d);
    }

    public byte[] decryptedData() throws KdcErrException {
        if (this.d != null) {
            p p2 = p.a(this.a);
            return p2.decryptedData(this.d);
        }
        return null;
    }

    public EncryptedData(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        if ((derValue.getData().peekByte() & 0x1F) == 1) {
            derValue2 = derValue.getData().getDerValue();
            int n2 = derValue2.getData().getBigInteger().intValue();
            this.b = new Integer(n2);
        } else {
            this.b = null;
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.c = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        if (this.b != null) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.b.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.putOctetString(this.c);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static EncryptedData parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptedData(derValue2);
    }

    public byte[] reset(byte[] byArray, boolean bl) {
        if (this.isRc4HMacEncType()) {
            return byArray;
        }
        byte[] byArray2 = null;
        if (bl) {
            if ((byArray[1] & 0xFF) < 128) {
                byArray2 = new byte[byArray[1] + 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray[1] + 2);
            } else if ((byArray[1] & 0xFF) > 128) {
                int n2 = byArray[1] & 0x7F;
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    n3 |= (byArray[i2 + 2] & 0xFF) << 8 * (n2 - i2 - 1);
                }
                byArray2 = new byte[n3 + n2 + 2];
                System.arraycopy(byArray, 0, byArray2, 0, n3 + n2 + 2);
            }
        } else {
            byArray2 = new byte[byArray.length - byArray[byArray.length - 1]];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length - byArray[byArray.length - 1]);
        }
        return byArray2;
    }

    public int getEType() {
        return this.a;
    }

    public Integer getKeyVersionNumber() {
        return this.b;
    }

    public byte[] getBytes() {
        return this.c;
    }

    public static int stringToEncType(String string) throws Exception {
        if (string == null) {
            I18NException.throwException(z[9]);
        }
        if (string.equalsIgnoreCase(z[7]) || string.equalsIgnoreCase(z[6]) || string.equalsIgnoreCase(z[14]) || string.equalsIgnoreCase(z[13])) {
            return 16;
        }
        if (string.equalsIgnoreCase(z[12])) {
            return 1;
        }
        if (string.equalsIgnoreCase(z[11])) {
            return 3;
        }
        if (string.equalsIgnoreCase(z[10])) {
            return 23;
        }
        if (string.equalsIgnoreCase(z[8])) {
            return 24;
        }
        if (string.equalsIgnoreCase(z[5])) {
            return 23;
        }
        if (string.equalsIgnoreCase(z[4])) {
            return 24;
        }
        if (string.equalsIgnoreCase(z[3])) {
            return 17;
        }
        if (string.equalsIgnoreCase(z[2])) {
            return 18;
        }
        if (string.equalsIgnoreCase(z[1])) {
            return 2;
        }
        if (string.equalsIgnoreCase(z[0])) {
            return 0;
        }
        I18NException.throwException(z[15], new String[]{string});
        return -999;
    }

    public boolean isSupportedEncType() {
        return EncryptedData.isSupportedEncType(this.a);
    }

    public static boolean isSupportedEncType(int n2) {
        return n2 == 16 || n2 == 1 || n2 == 3 || n2 == 23 || n2 == 24 || n2 == 17 || n2 == 18 || n2 == 0;
    }

    public String encTypeToString() {
        return EncryptedData.encTypeToString(this.a);
    }

    public static String encTypeToString(int n2) {
        switch (n2) {
            case 16: {
                return z[7];
            }
            case 1: {
                return z[12];
            }
            case 3: {
                return z[11];
            }
            case 23: {
                return z[10];
            }
            case 24: {
                return z[8];
            }
            case 17: {
                return z[17];
            }
            case 18: {
                return z[2];
            }
            case 2: {
                return z[1];
            }
            case 0: {
                return z[0];
            }
        }
        I18NException.throwIllegalArgumentException(z[16], new Integer[]{new Integer(n2)});
        return null;
    }

    public boolean isDesEncType() {
        return this.a == 16 || this.a == 3 || this.a == 1;
    }

    public static boolean isDesEncType(int n2) {
        return n2 == 16 || n2 == 3 || n2 == 1;
    }

    public boolean isRc4HMacEncType() {
        return this.a == 23 || this.a == 24;
    }

    public static boolean isRc4HMacEncType(int n2) {
        return n2 == 23 || n2 == 24;
    }

    public boolean isAES128EncType() {
        return this.a == 17;
    }

    public static boolean isAES128EncType(int n2) {
        return n2 == 17;
    }

    public boolean isAES256EncType() {
        return this.a == 18;
    }

    public static boolean isAES256EncType(int n2) {
        return n2 == 18;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block197: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block196: {
                char[] cArray3;
                Object var0;
                block195: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block194: {
                        char[] cArray5;
                        block193: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block192: {
                                char[] cArray7;
                                block191: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block190: {
                                        char[] cArray9;
                                        block189: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block188: {
                                                char[] cArray11;
                                                block187: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block186: {
                                                        char[] cArray13;
                                                        block185: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block184: {
                                                                char[] cArray15;
                                                                block183: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block182: {
                                                                        char[] cArray17;
                                                                        block181: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block180: {
                                                                                char[] cArray19;
                                                                                block179: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block178: {
                                                                                        char[] cArray21;
                                                                                        block177: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block176: {
                                                                                                char[] cArray23;
                                                                                                block175: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block174: {
                                                                                                        char[] cArray25;
                                                                                                        block173: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block172: {
                                                                                                                char[] cArray27;
                                                                                                                block171: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block170: {
                                                                                                                        char[] cArray29;
                                                                                                                        block169: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block168: {
                                                                                                                                char[] cArray31;
                                                                                                                                block167: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block166: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block165: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block164: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block163: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block162: {
                                                                                                                                                        stringArray = new String[18];
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray37 = "\u000f9\u000e\u0018".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n39 = cArray37.length;
                                                                                                                                                        cArray36 = cArray37;
                                                                                                                                                        n38 = n39;
                                                                                                                                                        if (n39 <= 1) break block162;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block163;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray38 = cArray36;
                                                                                                                                                        char[] cArray39 = cArray36;
                                                                                                                                                        int n40 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n41;
                                                                                                                                                            char c2 = cArray38[n40];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n41 = 97;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n41 = 76;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n41 = 98;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n41 = 116;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n41 = 55;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray38[n40] = (char)(c2 ^ n41);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray39;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray39 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n40 = n38;
                                                                                                                                                            cArray38 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[0] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray40 = "\u0005)\u0011YT\u0003/O\u0019SU".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n42 = cArray40.length;
                                                                                                                                                cArray34 = cArray40;
                                                                                                                                                n36 = n42;
                                                                                                                                                if (n42 <= 1) break block164;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block165;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray41 = cArray34;
                                                                                                                                                char[] cArray42 = cArray34;
                                                                                                                                                int n43 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n44;
                                                                                                                                                    char c3 = cArray41[n43];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n44 = 97;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n44 = 76;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n44 = 98;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n44 = 116;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n44 = 55;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray41[n43] = (char)(c3 ^ n44);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray42;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray42 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n43 = n36;
                                                                                                                                                    cArray41 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[1] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray43 = "\u0000)\u0011F\u0002Wa\u0001\u0000DL$\u000f\u0015TL?\n\u0015\u0006LuT".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n45 = cArray43.length;
                                                                                                                                        cArray32 = cArray43;
                                                                                                                                        n34 = n45;
                                                                                                                                        if (n45 <= 1) break block166;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block167;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray44 = cArray32;
                                                                                                                                        char[] cArray45 = cArray32;
                                                                                                                                        int n46 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n47;
                                                                                                                                            char c4 = cArray44[n46];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n47 = 97;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n47 = 76;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n47 = 98;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n47 = 116;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n47 = 55;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray44[n46] = (char)(c4 ^ n47);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray45;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray45 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n46 = n34;
                                                                                                                                            cArray44 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[2] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray46 = "\u0000)\u0011E\u0005Ya\u0001\u0000DL$\u000f\u0015TL?\n\u0015\u0006LuT".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n48 = cArray46.length;
                                                                                                                                cArray30 = cArray46;
                                                                                                                                n32 = n48;
                                                                                                                                if (n48 <= 1) break block168;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block169;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray47 = cArray30;
                                                                                                                                char[] cArray48 = cArray30;
                                                                                                                                int n49 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n50;
                                                                                                                                    char c5 = cArray47[n49];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n50 = 97;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n50 = 76;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n50 = 98;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n50 = 116;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n50 = 55;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray47[n49] = (char)(c5 ^ n50);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray48;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray48 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n49 = n32;
                                                                                                                                    cArray47 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[3] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray49 = "\u0000>\u0001\u0012X\u0014>O\u001cZ\u0000/O\u0011O\u0011".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n51 = cArray49.length;
                                                                                                                        cArray28 = cArray49;
                                                                                                                        n30 = n51;
                                                                                                                        if (n51 <= 1) break block170;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block171;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray50 = cArray28;
                                                                                                                        char[] cArray51 = cArray28;
                                                                                                                        int n52 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n53;
                                                                                                                            char c6 = cArray50[n52];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n53 = 97;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n53 = 76;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n53 = 98;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n53 = 116;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n53 = 55;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray50[n52] = (char)(c6 ^ n53);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray51;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray51 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n52 = n30;
                                                                                                                            cArray50 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[4] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray52 = "\u0000>\u0001\u0012X\u0014>O\u001cZ\u0000/".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n54 = cArray52.length;
                                                                                                                cArray26 = cArray52;
                                                                                                                n28 = n54;
                                                                                                                if (n54 <= 1) break block172;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block173;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray53 = cArray26;
                                                                                                                char[] cArray54 = cArray26;
                                                                                                                int n55 = n4;
                                                                                                                while (true) {
                                                                                                                    int n56;
                                                                                                                    char c7 = cArray53[n55];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n56 = 97;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n56 = 76;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n56 = 98;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n56 = 116;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n56 = 55;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray53[n55] = (char)(c7 ^ n56);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray54;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray54 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n55 = n28;
                                                                                                                    cArray53 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[5] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray55 = "\u0005)\u0011G\u001a\t!\u0003\u0017\u001a\u0012$\u0003E".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n57 = cArray55.length;
                                                                                                        cArray24 = cArray55;
                                                                                                        n26 = n57;
                                                                                                        if (n57 <= 1) break block174;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block175;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray56 = cArray24;
                                                                                                        char[] cArray57 = cArray24;
                                                                                                        int n58 = n4;
                                                                                                        while (true) {
                                                                                                            int n59;
                                                                                                            char c8 = cArray56[n58];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n59 = 97;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n59 = 76;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n59 = 98;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n59 = 116;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n59 = 55;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray56[n58] = (char)(c8 ^ n59);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray57;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray57 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n58 = n26;
                                                                                                            cArray56 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[6] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray58 = "\u0005)\u0011G\u001a\u0002.\u0001YD\t-S".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n60 = cArray58.length;
                                                                                                cArray22 = cArray58;
                                                                                                n24 = n60;
                                                                                                if (n60 <= 1) break block176;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block177;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray59 = cArray22;
                                                                                                char[] cArray60 = cArray22;
                                                                                                int n61 = n4;
                                                                                                while (true) {
                                                                                                    int n62;
                                                                                                    char c9 = cArray59[n61];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n62 = 97;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n62 = 76;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n62 = 98;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n62 = 116;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n62 = 55;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray59[n61] = (char)(c9 ^ n62);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray60;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray60 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n61 = n24;
                                                                                                    cArray59 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[7] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray61 = "\u0013/VY_\f-\u0001YR\u0019<".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n63 = cArray61.length;
                                                                                        cArray20 = cArray61;
                                                                                        n22 = n63;
                                                                                        if (n63 <= 1) break block178;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block179;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray62 = cArray20;
                                                                                        char[] cArray63 = cArray20;
                                                                                        int n64 = n4;
                                                                                        while (true) {
                                                                                            int n65;
                                                                                            char c10 = cArray62[n64];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n65 = 97;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n65 = 76;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n65 = 98;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n65 = 116;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n65 = 55;
                                                                                                }
                                                                                            }
                                                                                            cArray62[n64] = (char)(c10 ^ n65);
                                                                                            ++n4;
                                                                                            cArray20 = cArray63;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray63 = cArray20;
                                                                                            n21 = n22;
                                                                                            n64 = n22;
                                                                                            cArray62 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[8] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray64 = "/9\u000e\u0018r\u000f/6\rG\u0004\u001f\u0016\u0006^\u000f+".toCharArray();
                                                                                n4 = 0;
                                                                                int n66 = cArray64.length;
                                                                                cArray18 = cArray64;
                                                                                n20 = n66;
                                                                                if (n66 <= 1) break block180;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block181;
                                                                            }
                                                                            do {
                                                                                char[] cArray65 = cArray18;
                                                                                char[] cArray66 = cArray18;
                                                                                int n67 = n4;
                                                                                while (true) {
                                                                                    int n68;
                                                                                    char c11 = cArray65[n67];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n68 = 97;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n68 = 76;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n68 = 98;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n68 = 116;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n68 = 55;
                                                                                        }
                                                                                    }
                                                                                    cArray65[n67] = (char)(c11 ^ n68);
                                                                                    ++n4;
                                                                                    cArray18 = cArray66;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray66 = cArray18;
                                                                                    n19 = n20;
                                                                                    n67 = n20;
                                                                                    cArray65 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[9] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray67 = "\u0013/VY_\f-\u0001".toCharArray();
                                                                        n4 = 0;
                                                                        int n69 = cArray67.length;
                                                                        cArray16 = cArray67;
                                                                        n18 = n69;
                                                                        if (n69 <= 1) break block182;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block183;
                                                                    }
                                                                    do {
                                                                        char[] cArray68 = cArray16;
                                                                        char[] cArray69 = cArray16;
                                                                        int n70 = n4;
                                                                        while (true) {
                                                                            int n71;
                                                                            char c12 = cArray68[n70];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n71 = 97;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n71 = 76;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n71 = 98;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n71 = 116;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n71 = 55;
                                                                                }
                                                                            }
                                                                            cArray68[n70] = (char)(c12 ^ n71);
                                                                            ++n4;
                                                                            cArray16 = cArray69;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray69 = cArray16;
                                                                            n17 = n18;
                                                                            n70 = n18;
                                                                            cArray68 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[10] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray70 = "\u0005)\u0011YT\u0003/O\u0019ST".toCharArray();
                                                                n4 = 0;
                                                                int n72 = cArray70.length;
                                                                cArray14 = cArray70;
                                                                n16 = n72;
                                                                if (n72 <= 1) break block184;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block185;
                                                            }
                                                            do {
                                                                char[] cArray71 = cArray14;
                                                                char[] cArray72 = cArray14;
                                                                int n73 = n4;
                                                                while (true) {
                                                                    int n74;
                                                                    char c13 = cArray71[n73];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n74 = 97;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n74 = 76;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n74 = 98;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n74 = 116;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n74 = 55;
                                                                        }
                                                                    }
                                                                    cArray71[n73] = (char)(c13 ^ n74);
                                                                    ++n4;
                                                                    cArray14 = cArray72;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray72 = cArray14;
                                                                    n15 = n16;
                                                                    n73 = n16;
                                                                    cArray71 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[11] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray73 = "\u0005)\u0011YT\u0003/O\u0017E\u0002".toCharArray();
                                                        n4 = 0;
                                                        int n75 = cArray73.length;
                                                        cArray12 = cArray73;
                                                        n14 = n75;
                                                        if (n75 <= 1) break block186;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block187;
                                                    }
                                                    do {
                                                        char[] cArray74 = cArray12;
                                                        char[] cArray75 = cArray12;
                                                        int n76 = n4;
                                                        while (true) {
                                                            int n77;
                                                            char c14 = cArray74[n76];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n77 = 97;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n77 = 76;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n77 = 98;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n77 = 116;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n77 = 55;
                                                                }
                                                            }
                                                            cArray74[n76] = (char)(c14 ^ n77);
                                                            ++n4;
                                                            cArray12 = cArray75;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray75 = cArray12;
                                                            n13 = n14;
                                                            n76 = n14;
                                                            cArray74 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[12] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray76 = "\u0005)\u0011G\u001a\u0002.\u0001Y_\f-\u0001YD\t-SY\\\u0005".toCharArray();
                                                n4 = 0;
                                                int n78 = cArray76.length;
                                                cArray10 = cArray76;
                                                n12 = n78;
                                                if (n78 <= 1) break block188;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block189;
                                            }
                                            do {
                                                char[] cArray77 = cArray10;
                                                char[] cArray78 = cArray10;
                                                int n79 = n4;
                                                while (true) {
                                                    int n80;
                                                    char c15 = cArray77[n79];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n80 = 97;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n80 = 76;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n80 = 98;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n80 = 116;
                                                            break;
                                                        }
                                                        default: {
                                                            n80 = 55;
                                                        }
                                                    }
                                                    cArray77[n79] = (char)(c15 ^ n80);
                                                    ++n4;
                                                    cArray10 = cArray78;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray78 = cArray10;
                                                    n11 = n12;
                                                    n79 = n12;
                                                    cArray77 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[13] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray79 = "\u0005)\u0011G\u001a\u0002.\u0001YD\t-SY\\\u0005".toCharArray();
                                        n4 = 0;
                                        int n81 = cArray79.length;
                                        cArray8 = cArray79;
                                        n10 = n81;
                                        if (n81 <= 1) break block190;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block191;
                                    }
                                    do {
                                        char[] cArray80 = cArray8;
                                        char[] cArray81 = cArray8;
                                        int n82 = n4;
                                        while (true) {
                                            int n83;
                                            char c16 = cArray80[n82];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n83 = 97;
                                                    break;
                                                }
                                                case 1: {
                                                    n83 = 76;
                                                    break;
                                                }
                                                case 2: {
                                                    n83 = 98;
                                                    break;
                                                }
                                                case 3: {
                                                    n83 = 116;
                                                    break;
                                                }
                                                default: {
                                                    n83 = 55;
                                                }
                                            }
                                            cArray80[n82] = (char)(c16 ^ n83);
                                            ++n4;
                                            cArray8 = cArray81;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray81 = cArray8;
                                            n9 = n10;
                                            n82 = n10;
                                            cArray80 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[14] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray82 = "#-\u00061Y\u0002\u0018\u001b\u0004R28\u0010\u001dY\u0006".toCharArray();
                                n4 = 0;
                                int n84 = cArray82.length;
                                cArray6 = cArray82;
                                n8 = n84;
                                if (n84 <= 1) break block192;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block193;
                            }
                            do {
                                char[] cArray83 = cArray6;
                                char[] cArray84 = cArray6;
                                int n85 = n4;
                                while (true) {
                                    int n86;
                                    char c17 = cArray83[n85];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n86 = 97;
                                            break;
                                        }
                                        case 1: {
                                            n86 = 76;
                                            break;
                                        }
                                        case 2: {
                                            n86 = 98;
                                            break;
                                        }
                                        case 3: {
                                            n86 = 116;
                                            break;
                                        }
                                        default: {
                                            n86 = 55;
                                        }
                                    }
                                    cArray83[n85] = (char)(c17 ^ n86);
                                    ++n4;
                                    cArray6 = cArray84;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray84 = cArray6;
                                    n7 = n8;
                                    n85 = n8;
                                    cArray83 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[15] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray85 = "#-\u00061Y\u0002\u0018\u001b\u0004R".toCharArray();
                        n4 = 0;
                        int n87 = cArray85.length;
                        cArray4 = cArray85;
                        n6 = n87;
                        if (n87 <= 1) break block194;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block195;
                    }
                    do {
                        char[] cArray86 = cArray4;
                        char[] cArray87 = cArray4;
                        int n88 = n4;
                        while (true) {
                            int n89;
                            char c18 = cArray86[n88];
                            switch (n4 % 5) {
                                case 0: {
                                    n89 = 97;
                                    break;
                                }
                                case 1: {
                                    n89 = 76;
                                    break;
                                }
                                case 2: {
                                    n89 = 98;
                                    break;
                                }
                                case 3: {
                                    n89 = 116;
                                    break;
                                }
                                default: {
                                    n89 = 55;
                                }
                            }
                            cArray86[n88] = (char)(c18 ^ n89);
                            ++n4;
                            cArray4 = cArray87;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray87 = cArray4;
                            n5 = n6;
                            n88 = n6;
                            cArray86 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[16] = new String(cArray3).intern();
                var0 = null;
                char[] cArray88 = "\u0000)\u0011E\u0005Ya\u0001\u0000DL$\u000f\u0015TL?\n\u0015\u0006LuTT".toCharArray();
                n4 = 0;
                int n90 = cArray88.length;
                cArray2 = cArray88;
                n3 = n90;
                if (n90 <= 1) break block196;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block197;
            }
            do {
                char[] cArray89 = cArray2;
                char[] cArray90 = cArray2;
                int n91 = n4;
                while (true) {
                    int n92;
                    char c19 = cArray89[n91];
                    switch (n4 % 5) {
                        case 0: {
                            n92 = 97;
                            break;
                        }
                        case 1: {
                            n92 = 76;
                            break;
                        }
                        case 2: {
                            n92 = 98;
                            break;
                        }
                        case 3: {
                            n92 = 116;
                            break;
                        }
                        default: {
                            n92 = 55;
                        }
                    }
                    cArray89[n91] = (char)(c19 ^ n92);
                    ++n4;
                    cArray2 = cArray90;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray90 = cArray2;
                    n2 = n3;
                    n91 = n3;
                    cArray89 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[17] = new String(cArray).intern();
        z = stringArray;
    }
}

